/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.integration.datapark.service;

import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/03/08 10:27
 */
@Component
public class DataparkIncomeIntergration {

    @Autowired
    private RestTemplateClient restTemplateClient;
    @Value("${datapark.url}")
    private String DATAPARKURL ;


	/**
	 * 处理礼券收益
	 *
	 * @author 阿导
	 * @time 2018/3/19
	 * @CopyRight 杭州微财科技有限公司
	 * @param datetime
	 * @param mapCertificate
	 * @param mapApp
	 * @param mapBusiness
	 * @param certificateidList
	 * @return void
	 */
	public void dealTicketCash(String datetime,String mapCertificate,String mapApp,String mapBusiness,String certificateidList) throws IOException {
			//参数封装
			Map<String,Object> map=new HashMap<String, Object>();
			map.put("datetime",datetime);
			map.put("mapCertificate",mapCertificate);
			map.put("mapApp",mapApp);
			map.put("mapBusiness", mapBusiness);
			map.put("certificateidList", certificateidList);

			//调用更新礼券收益
            restTemplateClient.getByParams(DATAPARKURL+"/income/ticket", map, HttpMethod.PUT, null);

	}

	/**
	 * @description
	 * @author 阿导
	 * @time 2018/3/8
	 * @CopyRight 杭州微财科技有限公司
	 * @param datetime 更新日期
	 * @param mapAppIncome 开发者收入
	 * @param mapBusinessIncome 子链接收入
	 * @param mapApp 开发者收益
	 * @param mapBusiness 开发者子链接收益
	 * @param appkeyList 开发者标志集合
	 * @return void
	 */
	public void dealAppCash(String datetime,
							String mapAppIncome,
							String mapApp,
							String mapBusinessIncome,
							String mapBusiness,
							String appkeyList) throws IOException {
    	//参数封装
		Map<String,Object> map=new HashMap<String, Object>();
		map.put("datetime",datetime);
		map.put("mapAppIncome",mapAppIncome);
		map.put("mapApp",mapApp);
		map.put("mapBusinessIncome",mapBusinessIncome);
		map.put("mapBusiness",mapBusiness);
		map.put("appkeyList",appkeyList);
		//更新开发者报表收益
		restTemplateClient.getByParams(DATAPARKURL+"/income/app", map, HttpMethod.PUT, null);
	}
}
