package com.bxm.adsmanager.integration.datapark.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.integration.datapark.model.AppCount;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;

/**  
* @Title: DataparkListToMap 
* @Description:  将获取到list转成MAP
* @author xavier  
* @date 2018年3月6日  
*/  
@Configuration
@Component
public class DataparkListToMapService {
	
	private static final Logger logger = Logger.getLogger(DataparkListToMapService.class);

	@Autowired
	private DataparkTicketPullerIntegration dataParkTicketPullIntegration;
	@Autowired
	private DataparkAppPullerIntegration dataparkAppPullerIntegration;
	
	/**  
	 * @Title: getTicketCountMap  
	 * @Description:  通过时间查询礼券统计信息拼装成MAP
	 * @author xavier  
	 * @date 2018年3月6日
	 */  
	public Map<Long, Integer> getTicketCountMap(String datetime){
		Map<Long, Integer> results = new HashMap<>();
		try {
			List<TicketCountCommon> counts = dataParkTicketPullIntegration.getTicketCount(datetime,null,null);
			for (TicketCountCommon count : counts) {
				results.put(count.getCertificateid(), count.getClickPv());
			}
		} catch (IOException e) {
			logger.error("getTicketCountMap ERROR",e);
		}
		return results;
	}

	/**  
	 * @Title: getTicketCountMap  
	 * @Description:  通过时间查询礼券统计信息拼装成MAP
	 * @author xavier  
	 * @date 2018年3月6日
	 */  
	public Map<Long, TicketCountCommon> getTicketCountEntityMap(String datetime){
		Map<Long, TicketCountCommon> results = new HashMap<>();
		try {
			List<TicketCountCommon> counts = dataParkTicketPullIntegration.getTicketCount(datetime,null,null);
			for (TicketCountCommon count : counts) {
				results.put(count.getCertificateid(), count);
			}
		} catch (IOException e) {
			logger.error("getTicketCountMap ERROR",e);
		}
		return results;
	}
	
	/**  
	 * @Title: getAppCountMap  
	 * @Description:  通过时间查询APP统计信息拼装成MAP
	 * @author xavier  
	 * @date 2018年3月6日
	 */  
	public Map<String, AppCount> getAppCountMap(String datetime){
		Map<String, AppCount> results = new HashMap<>();
		try {
			List<AppCount> counts = dataparkAppPullerIntegration.getAppCountVos(
					datetime, null, null, null);
			for (AppCount count : counts) {
				results.put(count.getAppKey(), count);
			}
		} catch (IOException e) {
			logger.error("getAppCountMap ERROR",e);
		}
		return results;
	}

	/**  
	 * @Title: getPositionCountMap  
	 * @Description:  通过时间查询广告位统计信息拼装成MAP
	 * @author xavier  
	 * @date 2018年3月6日
	 */  
	public Map<String, AppCount> getPositionCountMap(String datetime){
		Map<String, AppCount> results = new HashMap<>();
		try {
			List<AppCount> counts = dataparkAppPullerIntegration.getAppBusinessCountVosBydatime(datetime);
			for (AppCount count : counts) {
				String positionId = count.getBusiness();
				if(StringUtils.isNotBlank(positionId)){
					positionId  = positionId.replace("ad-","");
				}
				results.put(count.getAppKey()+ "-" + positionId, count);
			}
		} catch (IOException e) {
			logger.error("getPositionCountMap ERROR",e);
		}
		return results;
	}
	
	/**  
	 * @Title: getTicketCountByTicket  
	 * @Description: 通过时间和礼券ID查询礼券统计信息
	 * @author xavier  
	 * @throws IOException 
	 * @date 2018年4月3日
	 */  
	public TicketCountCommon getTicketCountByTicket(String datetime,Long ticketId) throws IOException{
		List<Long> search = new ArrayList<>();
		search.add(ticketId);
		List<TicketCountCommon> results = dataParkTicketPullIntegration.getTicketCount(
				datetime, null, JSONObject.toJSONString(search));
		if (results != null && results.size() > 0) {
			return results.get(0);
		}
		return new TicketCountCommon();
	}
	
	/**  
	 * @Title: getPositionCountMapByTicket  
	 * @Description: 通过时间和礼券ID查询广告主发券信息 
	 * @author xavier  
	 * @throws IOException 
	 * @date 2018年4月3日
	 */  
	public Map<String, TicketCountCommon> getPositionCountMapByTicket(String datetime,Long ticketId) throws IOException{
		Map<String, TicketCountCommon> maps = new HashMap<>();
		List<Long> search = new ArrayList<>();
		search.add(ticketId);
		List<TicketCountCommon> results = dataparkAppPullerIntegration.getAppTicketCount(
				datetime, null, null, JSONObject.toJSONString(search));
		for (TicketCountCommon e : results) {
			maps.put(e.getAppkey() + "-" + e.getBusiness().replace("ad-", ""), e);
		}
		return maps;
	}

	/**
	 * @description 根据时间和礼券id查找该礼券下面所有的广告位发券信息，以广告位分类为map
	 * @author hcmony
	 * @time 2018/4/4
	 * @param datetime
	 * @param ticketId
	 * @return java.util.Map<java.lang.String,com.bxm.adsmanager.integration.datapark.model.TicketCountCommon>
	 */
	public Map<String, TicketCountCommon> getPositionCountMapByTicketWeight(String datetime,Long ticketId) throws IOException{

		Map<String, TicketCountCommon> maps = new HashMap<>();
		List<Long> search = new ArrayList<>();
		search.add(ticketId);
		List<TicketCountCommon> results = dataparkAppPullerIntegration.getAppTicketCountWeight(datetime, JSONObject.toJSONString(search));
		for (TicketCountCommon e : results) {
			maps.put(e.getAppkey() + "-" + e.getBusiness().replace("ad-", ""), e);
		}
		return maps;
	}
}
