package com.bxm.adsmanager.integration.datapark.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.datapark.model.Page;
import com.bxm.adsmanager.integration.datapark.model.media.PositionTest;
import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import com.google.common.collect.Maps;

@Configuration
@Component
public class DataparkMediaPositionTestPullerIntegration {

    @Autowired
    private RestTemplateClient restTemplateClient;
    @Value("${datapark.url}")
    private String             DATAPARKURL;

    /**
     * @Description: 分页查找媒体测试数据报表按照广告券
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @param keywords
     * @param positionid
     * @return
     * @throws IOException
     */
    public Page<PositionTest> getPositionTestReport(String keywords, String positionid, String sortName,
                                                    Integer pageNum, Integer pageSize, String sortType, String areatype,
                                                    String searchtype, String shopType) throws IOException {
        // 1、封装条件
        Map<String, Object> maps = Maps.newHashMap();

        if (pageSize != null) {
            maps.put("pageSize", pageSize);
        }
        if (pageNum != null) {
            maps.put("pageNum", pageNum);
        }
        if (StringUtils.isNotEmpty(sortName)) {
            maps.put("sortName", sortName);
        }
        if (StringUtils.isNotEmpty(sortType)) {
            maps.put("sortType", sortType);
        }
        if (StringUtils.isNotEmpty(positionid)) {
            maps.put("positionid", positionid);
        }
        if (StringUtils.isNotEmpty(keywords)) {
            maps.put("keywords", keywords);
        }
        if (StringUtils.isNotEmpty(areatype)) {
            maps.put("areatype", areatype);
        }
        if (StringUtils.isNotEmpty(searchtype)) {
            maps.put("searchtype", searchtype);
        }
        if (StringUtils.isNotEmpty(shopType)) {
            maps.put("shopType", shopType);
        }

        // 2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL + "/positiontest/getPositionTestReport", maps,
                                                       HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new Page<PositionTest>();
        }
        // 3、解析结果集
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<PositionTest> list = JSON.parseArray(page.getList().toString(), PositionTest.class);
            page.setList(list);
        }
        return page;
    }

    public List<PositionTest> getPositionTestReportExprot(String keywords, String positionid, String sortName,
                                                          String sortType, String areatype, String searchtype,
                                                          String shopType) throws IOException {
        // 1、封装条件
        Map<String, Object> maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty(keywords)) {
            maps.put("keywords", keywords);
        }
        if (StringUtils.isNotEmpty(sortName)) {
            maps.put("sortName", sortName);
        }
        if (StringUtils.isNotEmpty(sortType)) {
            maps.put("sortType", sortType);
        }
        if (StringUtils.isNotEmpty(positionid)) {
            maps.put("positionid", positionid);
        }
        if (StringUtils.isNotEmpty(areatype)) {
            maps.put("areatype", areatype);
        }
        if (StringUtils.isNotEmpty(searchtype)) {
            maps.put("searchtype", searchtype);
        }
        if (StringUtils.isNotEmpty(shopType)) {
            maps.put("shopType", shopType);
        }
        // 2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL + "/positiontest/getPositionTest/export", maps,
                                                       HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue") == null) {
            return new ArrayList<PositionTest>();
        }
        // 3、解析结果集
        List<PositionTest> list = JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(),
                                                  PositionTest.class);
        if (CollectionUtils.isEmpty(list)) {
            new ArrayList<PositionTest>();
        }
        return list;
    }

}
