package com.bxm.adsmanager.integration.datapark.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.datapark.model.Page;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;
import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 广告券日报
 *
 * @author zhangkai
 * @create 2018-03-02 18:55
 **/
@Configuration
@Component
public class DataparkTicketPullerIntegration {

    @Value("${datapark.url}")
    private String DATAPARKURL ;

    @Autowired
    private RestTemplateClient restTemplateClient;

    private static final Logger logger = Logger.getLogger(DataparkTicketPullerIntegration.class);


    /**
     * 获取礼券按小时维度数据
     * @param certificateid
     * @param appkey
     * @param business
     * @param datetime
     * @param sHour
     * @param eHour
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    public ResultModel TicketData(Long certificateid,String appkey, String business, String datetime,
                                      Integer sHour, Integer eHour,Integer pageSize,Integer pageNum,
                                      String sortName,String sortType){
        Map<String,Object> parm = new HashMap<>();
        if (certificateid != null){
            parm.put("certificateid",certificateid);
        }
        if (!StringUtils.isEmpty(appkey)){
            parm.put("appkey",appkey);
        }
        if (!StringUtils.isEmpty(business)){
            parm.put("business",business);
        }
        if (!StringUtils.isEmpty(datetime)){
            parm.put("datetime",datetime);
        }
        if (sHour != null){
            parm.put("sHour",sHour);
        }
        if (eHour != null){
            parm.put("eHour",eHour);
        }
        if (pageSize != null){
            parm.put("pageSize",pageSize);
        }
        if (pageNum != null){
            parm.put("pageNum",pageNum);
        }
        if (!StringUtils.isEmpty(sortName)){
            parm.put("sortName",sortName);
        }
        if (!StringUtils.isEmpty(sortType)){
            parm.put("sortType",sortType);
        }
        ResultModel resultModel = pullTicketData("/ticket/hour",parm);
        return resultModel;
    }


    /**
     * 导出礼券按小时维度
     * @param datetime
     * @param certificateid
     * @param appkey
     * @param business
     * @param sHour
     * @param eHour
     * @return
     */
    public List<TicketCountCommon> ticketHoursExport(String datetime,Long certificateid,String appkey,
                                                     String business,Integer sHour,Integer eHour){
        Map<String,Object> parm = new HashMap<>();
        if (certificateid != null){
            parm.put("certificateid",certificateid);
        }
        if (!StringUtils.isEmpty(appkey)){
            parm.put("appkey",appkey);
        }
        if (!StringUtils.isEmpty(business)){
            parm.put("business",business);
        }
        if (!StringUtils.isEmpty(datetime)){
            parm.put("datetime",datetime);
        }
        if (sHour != null){
            parm.put("sHour",sHour);
        }
        if (eHour != null){
            parm.put("eHour",eHour);
        }
        List<TicketCountCommon> ticketCountCommonList = ticketDateExport("/ticket/hour/export",parm);
        return ticketCountCommonList;
    }


    /**
     * 获取DataPark礼券数据
     * @param url
     * @param parm
     * @return
     */
    public ResultModel pullTicketData(String url,Map<String,Object> parm){
        ResultModel<Pagination> resultModel = new ResultModel<>();
        try {
            String result = restTemplateClient.getByParams(DATAPARKURL + url, parm, HttpMethod.POST, null);
            if (JSON.parseObject(result).get("returnValue")==null){
                resultModel.setReturnValue(null);
                return resultModel;
            }
            Page<TicketCountCommon> page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(),
                    Page.class);
            if (page.getList() == null) {
                resultModel.setReturnValue(null);
                return resultModel;
            }
            if (page.getSize() > 0) {
                List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
                page.setList(list);
            }
            Pagination pagination = new Pagination(page.getPageNum(), page.getSize(), page.getTotal().intValue(), page.getList());
            resultModel.setReturnValue(pagination);
        } catch (IOException e) {
            logger.error("调用datapark活动报表接口失败url:+"+url+e.getMessage(),e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("调用datapark活动报表接口失败");
        }
        return resultModel;
    }

    /**
     * 调用DataPark数据无分页
     * @param url
     * @param parm
     * @return
     */
    public List<TicketCountCommon> ticketDateExport(String url,Map<String,Object> parm){
        try {
            String result = restTemplateClient.getByParams(DATAPARKURL + url, parm, HttpMethod.POST, null);
            if (JSON.parseObject(result).get("returnValue")==null){
                return new ArrayList<>();
            }
            List<TicketCountCommon>  list = JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
            if (list.size() > 0){
                return list;
            }
        } catch (IOException e) {
            logger.error("调用datapark活动报表接口失败url:+"+url+e.getMessage(),e);
        }
        return new ArrayList<>();
    }


    public Page<TicketCountCommon> getTicketCount(String datetime, Integer scene,String json,
                                                  Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (scene!=null&&com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(scene.toString())){
            maps.put("scene",scene);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
        if (pageNum!=null){
            maps.put("pageNum",pageNum);
        }
        if (pageSize!=null){
            maps.put("pageSize",pageSize);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }

        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/ticket", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new Page<TicketCountCommon>();
        }
        //3、解析结果集
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getTicketCount(String datetime,Integer scene,String json) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (scene!=null&&com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(scene.toString())){
            maps.put("scene",scene);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/ticket/export", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue").toString()==null){
            return new ArrayList<TicketCountCommon>();
        }
        //3、解析结果集
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public Page<TicketCountCommon> getTicketAppCount(String datetime,Long certificateid,String json,Integer pageNum,
                                                     Integer pageSize,String sortName,String sortType) throws IOException{
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (certificateid!=null){
            maps.put("certificateid",certificateid);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
        if (pageNum!=null){
            maps.put("pageNum",pageNum);
        }
        if (pageSize!=null){
            maps.put("pageSize",pageSize);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/ticket", maps, HttpMethod.POST, null);
        //3、解析结果集
        if (JSON.parseObject(result).get("returnValue")==null){
            return new Page<TicketCountCommon>();
        }
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getTicketAppCount(String datetime,Long certificateid,String json) throws IOException{
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (certificateid!=null){
            maps.put("certificateid",certificateid);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/ticket/export", maps, HttpMethod.POST, null);
        //3、解析结果集
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public Page<TicketCountCommon> getTicketAppBusinessCount(String datetime,Long certificateid,String appKey,String json,Integer pageNum,
                                                             Integer pageSize,String sortName,String sortType) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (certificateid!=null){
            maps.put("certificateid",certificateid);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(appKey)){
            maps.put("appkey",appKey);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
        if (pageNum!=null){
            maps.put("pageNum",pageNum);
        }
        if (pageSize!=null){
            maps.put("pageSize",pageSize);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/ticket", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new Page<TicketCountCommon>();
        }
        //3、解析结果集
        Page page = JSON.parseObject(JSON.parseObject(result).get("returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List<TicketCountCommon> list = JSON.parseArray(page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getTicketAppBusinessCount(String datetime,Long certificateid,String appKey,String json) throws IOException{
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(datetime)){
            maps.put("datetime",datetime);
        }
        if (certificateid!=null){
            maps.put("certificateid",certificateid);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(appKey)){
            maps.put("appkey",appKey);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(json)){
            maps.put("json",json);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/ticket/profit", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<TicketCountCommon>();
        }
        //3、解析结果集
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

    public List<TicketCountCommon> getTicketCountDate(String startTime, String endTime, Long certificateid, String sortName, String sortType) throws IOException {
        //1、封装条件
        Map<String,Object> maps = Maps.newHashMap();
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(startTime)){
            maps.put("startTime",startTime);
        }
        if (endTime!=null){
            maps.put("endTime",endTime);
        }
        if (certificateid!=null){
            maps.put("certificateid",certificateid);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(sortName)){
            maps.put("sortName",sortName);
        }
        if (com.alibaba.dubbo.common.utils.StringUtils.isNotEmpty(sortType)){
            maps.put("sortType",sortType);
        }
        //2、调用datapark接口
        String result = restTemplateClient.getByParams(DATAPARKURL+"/ticket/date", maps, HttpMethod.POST, null);
        if (JSON.parseObject(result).get("returnValue")==null){
            return new ArrayList<TicketCountCommon>();
        }
        //3、解析结果集
        return JSON.parseArray(JSON.parseObject(result).get("returnValue").toString(), TicketCountCommon.class);
    }

}
