package com.bxm.adsmanager.integration.getui.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.integration.exception.PushGeTuiException;
import com.bxm.adsmanager.integration.getui.model.RuleForm;
import com.bxm.adsmanager.integration.getui.utils.HttpUtils;
import com.bxm.util.MD5Util;
import com.bxm.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * <h3>上传规则和对应的值到个推</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
@Configuration
@Component
public class GeTuiIntegration {

	private static final Logger logger = Logger.getLogger(GeTuiIntegration.class);

	@Value("${geTui.url}")
	private String GETUIURL ;
	@Value("${geTui.userCode}")
	private String USER_CODE ;
	@Value("${geTui.authCode}")
	private String AUTH_CODE ;

	/**
	private static final String GETUIURL = "dmp-hz.abeacon.com/"; //个推线上地址
	private static final String USER_CODE = "bianxianmaodf";			//个推秘钥
	private static final String AUTH_CODE = "QPSgh8RkYlAOEEHLRpW5y8"; //鉴别码
	 */
	
	private static final String ACCESSERURL = "/accesser/auth";
	
	private static final String UPLOADRULEURL = "/rules/uploadRule";
	
	private static final String DELETERULEURL = "/rules/delRule";
	
	private static final String GETRULEURL = "/rules/getRuleList";
	
	/**
	 * 个推规则上传接口
	 * @param ticketId  券id（唯一标识）
	 * @return
	 */
	public  void uploadRule(List<RuleForm> list, Long ticketId){
		try {
			long start = System.currentTimeMillis();
			//获取accessToken
			String accessToken = getAccessToken();
			//封装参数
			String parameter = packageParameter(list, ticketId);
			//上传规则
			logger.info("个推规则上传:parameter="+parameter);
			String result = sendPost("http://"+GETUIURL + UPLOADRULEURL, parameter, accessToken);
			if(StringUtils.isBlank(result)){
				return ;
			}
			JSONObject js = JSONObject.parseObject(result);
			String code = js.getString("code");
			long end = System.currentTimeMillis();
			logger.info("个推规则上传完成，用时："+(end-start)+"毫秒");
			if(code.equals("0")){
				return ;
			}
			logger.error("发送个推画像成功，但是返回值是失败的");
		}catch (Exception e){
			logger.error("个推规则上传接口失败",e);
		}

	}
	
	/**
	 * 个推删除规则接口
	 * @param ruleId
	 * @return
	 */
	public  void deleteRule(Long ruleId){
		try {
			logger.info("删除个推规则:ticketId="+ruleId);
			//获取accessToken
			String accessToken = getAccessToken();
			//删除规则
			String result = sendGet("http://"+GETUIURL + DELETERULEURL, "ruleId="+ruleId, accessToken);
			if(StringUtil.isBlank(result)){
				return ;
			}
			JSONObject json = JSONObject.parseObject(result);
			String code = json.getString("code");
			if("0".equals(code)){
				return ;
			}
			logger.error("发送个推画像成功，但是返回值是失败的");
		}catch (Exception e){
			logger.error("个推删除规则接口失败",e);
		}
	}
	
	/**
	 * 封装上传参数 实际要传的参数  score; isVeto:一票否决 1 ，不 0 ; ruleId
	 * @param list
	 * @param ticketId
	 * @return
	 */
	public  String packageParameter(List<RuleForm> list, Long ticketId){
		JSONArray ja = new JSONArray(list.size());
		for(RuleForm ruleForm : list){
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("tagExpress", ruleForm.getLabelid());
			if(1==ruleForm.getIsveto()){
				map.put("score", 0);
			}else{
				map.put("score", null==ruleForm.getFraction()?0:ruleForm.getFraction());
			}
			map.put("isVeto", ruleForm.getIsveto());
			ja.add(map);
		}
		JSONObject jo2 = new JSONObject();
		jo2.put("ruleId", ticketId);
		jo2.put("ruleScoreObjList", ja);
		JSONArray ss = new JSONArray();
		ss.add(jo2);
		JSONObject jo3 = new JSONObject();
		jo3.put("rules", ss);
		return jo3.toJSONString();
}
	
	/**
	 * 获取AccessToken
	 * @return
	 */
	public  String getAccessToken(){
		String access_token ="";
		try {
			String timestamp = String.valueOf(System.currentTimeMillis());
			String sign1 = MD5Util.md5(USER_CODE + MD5Util.md5(timestamp));
			String sign2 = MD5Util.md5(USER_CODE + AUTH_CODE + MD5Util.md5(timestamp));
			String url = "http://"+GETUIURL + ACCESSERURL +"?user_code="+USER_CODE+"&sign1="+sign1+"&sign2="+sign2+"&timestamp="+timestamp;
			CloseableHttpClient httpClient = HttpUtils.CreatHttpClient();
			HttpGet httpGet = HttpUtils.getHttpGet(url);
			httpGet.setHeader("Accept","application/vnd.dmp.v1+json");

			CloseableHttpResponse httpResp = httpClient.execute(httpGet);
			String result = EntityUtils.toString(httpResp.getEntity());
			JSONObject jsonObject = JSONObject.parseObject(result);
			access_token = jsonObject.getString("access_token");
		} catch(Exception e) {
			logger.error("获取AccessToken出错"+e.getMessage(),e);
		}
		return access_token;
	}
	
	
	/**
     * 向指定 URL 发送POST方法的请求
     * 
     * @param url
     *            发送请求的 URL
     * @param param
     *            请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
     * @return 所代表远程资源的响应结果
     */
    public  String sendPost(String url, String param, String access_token) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            URL realUrl = new URL(url);
            // 打开和URL之间的连接
            URLConnection conn = realUrl.openConnection();
            // 设置通用的请求属性
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer "+access_token);
            conn.setRequestProperty("Accept", "application/vnd.dmp.v1+json");
            // 发送POST请求必须设置如下两行
            conn.setDoOutput(true);
            conn.setDoInput(true);
            // 获取URLConnection对象对应的输出流
            out = new PrintWriter(conn.getOutputStream());
            // 发送请求参数
            out.print(param);
            // flush输出流的缓冲
            out.flush();
            // 定义BufferedReader输入流来读取URL的响应
            in = new BufferedReader(
                    new InputStreamReader(conn.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
			logger.error("发送POST请求出现异常"+e.getMessage(),e);
        }
        //使用finally块来关闭输出流、输入流
        finally{
            try{
                if(out!=null){
                    out.close();
                }
                if(in!=null){
                    in.close();
                }
            }
            catch(IOException ex){
                ex.printStackTrace();
            }
        }
        return result;
    }    
    
    
    
    public  String sendGet(String url, String param, String access_token ) {
        String result = "";
        BufferedReader in = null;
        try {
            String urlNameString = url + "?" + param;
            URL realUrl = new URL(urlNameString);
            // 打开和URL之间的连接
            URLConnection connection = realUrl.openConnection();
            // 设置通用的请求属性
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Authorization", "Bearer "+access_token);
            connection.setRequestProperty("Accept", "application/vnd.dmp.v1+json");
            connection.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            // 建立实际的连接
            connection.connect();
            // 获取所有响应头字段
            Map<String, List<String>> map = connection.getHeaderFields();
            // 遍历所有的响应头字段
            for (String key : map.keySet()) {
				logger.info(key + "--->" + map.get(key));
            }
            // 定义 BufferedReader输入流来读取URL的响应
            in = new BufferedReader(new InputStreamReader(
                    connection.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
			logger.error("发送GET请求出现异常"+e.getMessage(),e);
        }
        // 使用finally块来关闭输入流
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }
    
}
