package com.bxm.adsmanager.integration.getui.utils;

import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by Administrator on 2015/10/15.
 */
public class HttpUtils {

    /**
     * 关闭连接
     * @param httpclient
     */
    public static void close(CloseableHttpClient httpclient){
        if(httpclient != null){
            try {
                httpclient.close();
                httpclient = null;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
    public static void close(CloseableHttpResponse httpResp){
        if(httpResp != null){
            try {
                httpResp.close();
                httpResp = null;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 创建HttpClient
     * @return
     */
    public static CloseableHttpClient CreatHttpClient() {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        return httpclient;
    }

    /**
     * 创建HttpClient
     * @return
     */
    public static CloseableHttpClient CreatHttpClientSSL() {

        CloseableHttpClient httpclient = null;
        CookieStore cookieStore = new BasicCookieStore();
        try {
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, new javax.net.ssl.TrustManager[] { new MyX509TrustManager() }, null);

//            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslcontext);
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslcontext , SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder = httpClientBuilder.setSSLSocketFactory(sslConnectionSocketFactory);
            httpClientBuilder = httpClientBuilder.setDefaultCookieStore(cookieStore);
//            httpClientBuilder = httpClientBuilder.setSSLContext(sslcontext);

            httpclient = httpClientBuilder.build();


        }catch (Exception e) {
            e.printStackTrace();
        } finally {
        }

        return httpclient;
    }

    public static class MyX509TrustManager implements X509TrustManager {

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType)
                throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType)
                throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

    }



    public static HttpPost getHttpPost(String url){
        HttpPost httpPost = new HttpPost(url);
        httpPost =addHeader(httpPost);
        return httpPost;
    }
    public static HttpPost addHeader(HttpPost httpPost){
        httpPost.setHeader(new BasicHeader("UserAgent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36"));
        httpPost.setHeader(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36"));
        httpPost.setHeader(new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8"));
        httpPost.setHeader(new BasicHeader("Accept-Language", "zh-CN,zh;q=0.8"));
        httpPost.setHeader(new BasicHeader("Connection", "keep-alive"));

        return httpPost;
    }

    public static HttpGet getHttpGet(String url){
        HttpGet httpGet = new HttpGet(url);
        httpGet = addHeader(httpGet);
        return httpGet;
    }
    public static HttpGet addHeader(HttpGet httpGet){

        httpGet.setHeader(new BasicHeader("Content-Type", "application/x-www-form-urlencoded;CharSet=gbk"));
        httpGet.setHeader(new BasicHeader("UserAgent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36"));
        httpGet.setHeader(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36"));
        httpGet.setHeader(new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8"));
        httpGet.setHeader(new BasicHeader("Accept-Encoding", "gzip, deflate"));
        httpGet.setHeader(new BasicHeader("Accept-Language", "zh-CN,zh;q=0.8"));
        httpGet.setHeader(new BasicHeader("Connection", "keep-alive"));


        return httpGet;
    }

    public static boolean savePic(InputStream inputStream , String filePath){
        ByteArrayOutputStream outStream =null;
        FileOutputStream fileOutStream =null;
        try {
            outStream = new ByteArrayOutputStream();
            //创建一个Buffer字符串
            byte[] buffer = new byte[1024];
            //每次读取的字符串长度，如果为-1，代表全部读取完毕
            int len = 0;
            //使用一个输入流从buffer里把数据读取出来
            while( (len=inputStream.read(buffer)) != -1 ){
                //用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度
                outStream.write(buffer, 0, len);
            }
//			//关闭输入流
//			inputStream.close();
            //把outStream里的数据写入内存

            //得到图片的二进制数据，以二进制封装得到数据，具有通用性
            byte[] imgByte = outStream.toByteArray();
//            logger.info("image size={}", imgByte.length);
            //保存文本目录
            String fileDir = filePath.substring(0 ,filePath.lastIndexOf("/"));
            File imageFilePath = new File(fileDir);
            if(!imageFilePath.exists()){
                imageFilePath.mkdirs();
            }

            //new一个文件对象用来保存图片，默认保存当前工程根目录
            File imageFile = new File(filePath);

            //创建输出流
            fileOutStream = new FileOutputStream(imageFile);
            //写入数据
            fileOutStream .write(imgByte);


        } catch (Exception e) {
//            logger.error("noAccountValidateCode IOException", e);
            return false;
        }finally {
            if(outStream!=null){
                try {
                    outStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if(inputStream!=null){
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if(fileOutStream!=null){
                try {
                    fileOutStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        return true;


    }


    public static String savePic(byte[] imgByte , String pahtFile){

        // save image
        String session_token = UUID.randomUUID().toString();
//        Path pathFile = Paths.get(req.getSession(true).getServletContext().getRealPath("") + gateWayConfig.getImageSavePath() + "/" + session_token + IMAGE_SUFFIX);
        Path pathFile = Paths.get(""+pahtFile);
        try {
            java.nio.file.Files.write(pathFile, imgByte, StandardOpenOption.CREATE);
        } catch (IOException e) {
            e.printStackTrace();
        }

        return session_token;
    }

    public static HashMap<String ,String> findUrlParameters(String inUrl){
        HashMap<String ,String> parametersMap = new HashMap<String ,String>();

        if(inUrl == null || inUrl.length() == 0 || !inUrl.contains("?")){
            return parametersMap;
        }
        String inUrlQuerry = inUrl.substring(inUrl.indexOf("?") + 1, inUrl.length());

        if(inUrlQuerry.contains("&")){
            String[] kvs = inUrlQuerry.split("&");
            for (String kv : kvs){
                if(kv.contains("=")) {
                    String[] kvArray = kv.split("=");
                    if (kvArray.length != 2) {
                        parametersMap.put(kvArray[0], "");
                    }else {
                        parametersMap.put(kvArray[0], kvArray[1]);
                    }
                }
            }
        }else {


            if(inUrlQuerry.contains("=")) {
                String[] kvArray = inUrlQuerry.split("=");
                if (kvArray.length != 2) {
                    parametersMap.put(kvArray[0], "");
                }else {
                    parametersMap.put(kvArray[0], kvArray[1]);
                }
            }

        }

        return parametersMap;
    }


    public static String urlEncode(String inStr){
        if(inStr==null || inStr.trim().equalsIgnoreCase("")){
            return "";
        }

        try {
            inStr = URLEncoder.encode(inStr, "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return inStr;
    }

    public static String urlDecode(String inStr){
        {
            if(inStr==null || inStr.trim().equalsIgnoreCase("")){
                return "";
            }

            try {
                inStr = URLDecoder.decode(inStr, "utf-8");
//				inStr = URLEncoder.encode(inStr, "utf-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return inStr;
        }
    }
    public static String getHost(String url){
        //http://my.chsi.com.cn/archive/index.action
        String ret = "";
        if(url == null || url.length() == 0 || !(url.startsWith("http://") || url.startsWith("https://") ) ){
            return "";
        }
        url = url.substring(url.indexOf("://")+3 ,url.length() );
        if(url.contains("/")) {
            url = url.substring(0 ,url.indexOf("/"));
        }

        return url;
    }

    /**
     * 得到数据
     * @param url
     * @return
     */
    public static String getUrl(String url){
        int maxRunNum=3;
        int runNum=0;
        String responseStr = null;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResp = null ;
        try {
            httpClient = CreatHttpClient();
            HttpGet httpGet = new HttpGet(url);
            httpResp = httpClient.execute(httpGet);
            if (httpResp.getStatusLine().getStatusCode() != 200) {
                runNum++;
            }else {
                responseStr = EntityUtils.toString(httpResp.getEntity());
            }

        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            close(httpResp);
            close(httpClient);

        }

        return responseStr;


    }

    public static String LocationValue(CloseableHttpResponse httpResp){

        if(httpResp.getFirstHeader("Location")!=null){
            return  httpResp.getFirstHeader("Location").getValue();

        }
        return "";
    }
    
    
    public static String requestUrlWithPost(String postUrl, List<BasicNameValuePair> list){
    	String result = null;
    	try {
    		CloseableHttpClient httpClient = HttpUtils.CreatHttpClient();
    		HttpPost httpPost = HttpUtils.getHttpPost(encode(postUrl));
    		httpPost.setHeader(new BasicHeader("Upgrade-Insecure-Requests", "1"));
    		httpPost.setHeader(new BasicHeader("Connection", "keep-alive"));
    		httpPost.setHeader(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko"));
    		HttpEntity requestEntity = new UrlEncodedFormEntity(list, "UTF-8");
    		httpPost.setEntity(requestEntity);
    		CloseableHttpResponse httpResp = httpClient.execute(httpPost);
    		result = EntityUtils.toString(httpResp.getEntity());
    	} catch (ClientProtocolException e) {
//			e.printStackTrace();
    		return "ClientProtocolException failed";
		} catch (IOException e) {
//			e.printStackTrace();
			return "IOException failed";
		}
		return result;
    }
    
    /**
     * 通过get方式请求getUrl
     * @param getUrl
     * @return
     */
    public static String requestUrlWithGet(String getUrl){
    	String result = null;
    	try {
    		CloseableHttpClient httpClient = HttpUtils.CreatHttpClient();
    		HttpGet httpGet =getHttpGet(encode(getUrl));
    		//设置网络请求为30
    		RequestConfig requestConfig = RequestConfig.custom()
    		        .setConnectTimeout(5000).setConnectionRequestTimeout(30000)  
    		        .setSocketTimeout(5000).setRedirectsEnabled(true).build();
    		httpGet.setConfig(requestConfig);
    		httpGet.setHeader(new BasicHeader("Upgrade-Insecure-Requests", "1"));
    		httpGet.setHeader(new BasicHeader("Connection", "keep-alive"));
    		httpGet.setHeader(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko"));
    		CloseableHttpResponse httpResp = httpClient.execute(httpGet);
    		result = EntityUtils.toString(httpResp.getEntity());
//    		result = httpResp.getFirstHeader("header").getValue();
    		result = httpResp.getLastHeader("Location").getValue();
    	} catch (ClientProtocolException e) {
    		return "ClientProtocolException failed";
//			e.printStackTrace();
		} catch (IOException e) {
			return "IOException failed";
//			e.printStackTrace();
		}
		return result;
    }

    
    public static String encode(String url)
    {  
        try {        
             Matcher matcher = Pattern.compile("[\\u4e00-\\u9fa5]").matcher(url);
             while (matcher.find()) {  
               System.out.println(matcher.group());
               String tmp=matcher.group();
               url=url.replaceAll(tmp,java.net.URLEncoder.encode(tmp,"utf-8"));
             } 
        } catch (UnsupportedEncodingException e) {

            e.printStackTrace();  
        }  
        System.out.println(url);
        return url;
    }  
    
    
    
    //测试
    public static String http(String url, Map<String, String> params) {
        URL u = null;
        HttpURLConnection con = null;
        // 构建请求参数  
        StringBuffer sb = new StringBuffer();
        if (params != null) {  
            for (Entry<String, String> e : params.entrySet()) {
                sb.append(e.getKey());  
                sb.append("=");  
                sb.append(e.getValue());  
                sb.append("&");  
            }  
            sb.substring(0, sb.length() - 1);  
        }  
        // 尝试发送请求
        try {  
            u = new URL(url);
            con = (HttpURLConnection) u.openConnection();
            //// POST 只能为大写，严格限制，post会不识别  
            con.setRequestMethod("POST");  
            con.setDoOutput(true);  
            con.setDoInput(true);  
            con.setUseCaches(false);  
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");  
            OutputStreamWriter osw = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            osw.write(sb.toString());  
            osw.flush();  
            osw.close();  
        } catch (Exception e) {
            e.printStackTrace();  
        } finally {  
            if (con != null) {  
                con.disconnect();  
            }  
        }  
  
        // 读取返回内容  
        StringBuffer buffer = new StringBuffer();
        try {  
            //一定要有返回值，否则无法把请求发送给server端。  
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
            String temp;
            while ((temp = br.readLine()) != null) {  
                buffer.append(temp);  
                buffer.append("\n");  
            }  
        } catch (Exception e) {
            e.printStackTrace();  
        }  
  
        return buffer.toString();  
    }  
    
    
    
    
    
}
