/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.integration.platform.service;

import com.bxm.profit.facade.AdIncomeService;
import com.bxm.profit.model.dto.AdIncomeLogDto;
import com.bxm.profit.model.dto.AddAdIncomeLogDto;
import com.bxm.profit.model.dto.IncomeLogDto;
import com.bxm.profit.model.vo.AdIncomeLogVo;
import com.bxm.util.dto.ResultModel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <h3>集成springcloud 广告主 相关接口 </h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/03/26 14:28
 */
@Service
public class AdIncomeIntegration {

	private static final Logger logger = Logger.getLogger(AdIncomeIntegration.class);

	@Autowired
	private AdIncomeService adIncomeService;

	/**
	 * @Description 方法描述：新增广告收益（根据媒体）
	 * @author hcmony
	 * @param incomeLogDto
	 * @throws Exception
	 */
	public Boolean addByMedia(IncomeLogDto incomeLogDto) throws Exception{
		ResultModel<Boolean> resultModel =  adIncomeService.add(incomeLogDto);
		return  resultModel.getReturnValue();
	}

	/**
	 * @Description 方法描述：新增广告收益（根据广告位）
	 * @author hcmony
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param addAdIncomeLogDto
	 * @throws Exception
	 */
	public Boolean addByPosition(AddAdIncomeLogDto addAdIncomeLogDto) throws Exception{
		ResultModel<Boolean>  resultModel =  adIncomeService.add(addAdIncomeLogDto);
		return  resultModel.getReturnValue();
	}

	/**
	 * @Description 方法描述：根据条件查询列表
	 * @author hcmony
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param adIncomeLogDto
	 * @return
	 */
	public List<AdIncomeLogVo> getList(AdIncomeLogDto adIncomeLogDto){
		ResultModel<List<AdIncomeLogVo>>  resultModel =  adIncomeService.getList(adIncomeLogDto);
		return  resultModel.getReturnValue();
	}

}
