/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.integration.platform.service;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.bxm.app.facade.ProviderAppFacadeService;
import com.bxm.app.model.dto.ProviderAppAdDto;
import com.bxm.app.model.ro.ProviderAppAdRo;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Maps;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <h3>集成springcloud 媒体广告相关信息 </h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/03/26 14:30
 */

@Service
public class MediaIntegration {

	private static final Logger logger = Logger.getLogger(MediaIntegration.class);

	@Autowired
	private ProviderAppFacadeService providerAppFacadeService;


	/**
	 * @Description 方法描述：修改媒体相关信息
	 * @author hcmony
	 * @param providerAppAdDto
	 * @throws Exception
	 */
	public Boolean updateProviderAppAdInfo(ProviderAppAdDto providerAppAdDto) throws Exception{
		ResultModel<Boolean> resultModel =  providerAppFacadeService.updateProviderAppAdInfo(providerAppAdDto);
		return  resultModel.getReturnValue();
	}

	/**
	 * @Description 方法描述：根据appId获取媒体 详细信息：返回媒体名称，BD,媒介,备注
	 * @author hcmony
	 * @param id
	 * @throws Exception
	 */
	public ProviderAppAdRo getById(Long id) throws Exception{
		ResultModel<ProviderAppAdRo> resultModel =  providerAppFacadeService.getById(id);
		return  resultModel.getReturnValue();
	}

	/**
	 * @Description 方法描述：根据关键字查询媒体列表
	 * @author hcmony
	 * @param keywords 关键字：appName,别名,媒介,备注
	 * @throws Exception
	 */
	public List<ProviderAppAdRo> getList(String keywords) throws Exception{
		ResultModel<List<ProviderAppAdRo>> resultModel =  providerAppFacadeService.getList(keywords);
		return  resultModel.getReturnValue();
	}

	/**
	 * @Description 查询所有媒体信息，转为MAP KEY为appid
	 * @author hcmony
	 * @throws Exception
	 */
	public Map<String, ProviderAppAdRo> findMediaAllToMap() {
		Map<String, ProviderAppAdRo> results = Maps.newHashMap();
		try {
			List<ProviderAppAdRo> lists = getList(null);
			if(CollectionUtils.isNotEmpty(lists)){
				lists.forEach(mediaMsgDto -> results.put(mediaMsgDto.getAppKey(),mediaMsgDto));
			}
		}catch (Exception e){
			logger.error("根据关键字查询媒体列表出错",e);
		}
		return results;
	}
}
