package com.bxm.adsmanager.integration.platform.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.integration.platform.model.MediaMsgDto;
import com.bxm.adsmanager.integration.platform.model.PositionMsgDto;
import com.bxm.util.OkHttpUtils;


/**
 * <h3>获取媒体接口</h3>
 * <p>http://118.178.135.132:18121/swagger-ui.html#!/provider-app-controller/getListForAdUsingGET</p>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
@Service
public class MediaMsgIntegration {
	
	@Value("${platFormUrl}")
	private String url;
	
	private String getMediaAllList = "/getListForAd";

	private String getPositionList = "/getList";

	private static final Logger logger = Logger.getLogger(AdShopIntegration.class);
	
	/**  
	 * @Title: findMediaAll  
	 * @Description:  查询所有媒体
	 * @author xavier  
	 * @date 2018年3月9日
	 */  
	public List<MediaMsgDto> findMediaAll(){
		List<MediaMsgDto> results = new ArrayList<>();
		try {
			String response = OkHttpUtils.get(url + getMediaAllList+"?pageNum=1&pageSize=999999");
			JSONObject json = JSONObject.parseObject(response);
			json = json.getJSONObject("returnValue");
			String array = json.getString("list");
			results = JSONArray.parseArray(array, MediaMsgDto.class);
		} catch (IOException e) {
			logger.error("获取媒体列表出错",e);
		}
		return results;
	}
	
	/**  
	 * @Title: findMediaAllToMap  
	 * @Description: 查询所有媒体信息，转为MAP KEY为appid 
	 * @author xavier  
	 * @date 2018年3月9日
	 */  
	public Map<String, MediaMsgDto> findMediaAllToMap(){
		Map<String, MediaMsgDto> results = new HashMap<>();
		List<MediaMsgDto> lists = findMediaAll();
		if(CollectionUtils.isNotEmpty(lists)){
			lists.forEach(mediaMsgDto -> results.put(mediaMsgDto.getAppKey(),mediaMsgDto));
		}
		return results;
	}
	
	/**  
	 * @Title: findPositonAll  
	 * @Description:  通过appid 查询所有广告位信息
	 * @author xavier  
	 * @date 2018年3月9日
	 */  
	public List<PositionMsgDto> findPositonAll(String appId){
		List<PositionMsgDto> results = new ArrayList<>();
		try {
			String response = OkHttpUtils.get(url + getPositionList);
			JSONObject json = JSONObject.parseObject(response);
			String array = json.getString("returnValue");
			results = JSONArray.parseArray(array, PositionMsgDto.class);
		} catch (IOException e) {
			logger.error("获取广告位列表出错",e);
		}
		return results;
	}
	
	/**  
	 * @Title: findPositionAllToMap  
	 * @Description: 查询所有广告位信息，转为MAP KEY为positionId 
	 * @author xavier  
	 * @date 2018年3月9日
	 */  
	public Map<String, PositionMsgDto> findPositionAllToMap(String appId){
		Map<String, PositionMsgDto> results = new HashMap<>();
		List<PositionMsgDto> lists = findPositonAll(appId);
		for (PositionMsgDto position : lists) {
			results.put(position.getId().toString(), position);
		}
		return results;
	}
	
}
