/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.integration.platform.service;

import com.bxm.app.facade.AppEntranceFacadeService;
import com.bxm.app.model.dto.AppEntranceAdDto;
import com.bxm.app.model.ro.AppEntranceAdRo;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <h3>集成springcloud 广告位相关信息 </h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/03/26 14:30
 */

@Service
public class PositionIntegration {

	private static final Logger logger = Logger.getLogger(PositionIntegration.class);
	@Autowired
	private AppEntranceFacadeService appEntranceFacadeService;


	/**
	 * @Description 方法描述：修改开发者广告位相关信息，修改备注，别名，行业类型
	 * @author hcmony
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param appEntranceDto
	 * @throws Exception
	 */
	public Boolean updateAdPositionInfo(AppEntranceAdDto appEntranceDto) throws Exception{
		ResultModel<Boolean> resultModel =  appEntranceFacadeService.updateAdPositionInfo(appEntranceDto);
		return  resultModel.getReturnValue();
	}

	/**
	 * @Description 方法描述：根据positionId查询广告位信息，返回开发者名称,行业类型,备注,别名等信息
	 * @author hcmony
	 * @param positionId
	 * @throws Exception
	 */
	public AppEntranceAdRo getByPositionId(String positionId) throws Exception{
		ResultModel<AppEntranceAdRo> resultModel =  appEntranceFacadeService.getByPositionId(positionId);
		return  resultModel.getReturnValue();
	}

	/**
	 * @Description 方法描述：根据关键字查询列表，默认查询全部
	 * @author hcmony
	 * @param positionId 广告位id
	 * @param keywords 关键字：BD,媒介,备注
	 * @throws Exception
	 */
	public List<AppEntranceAdRo> getList(String positionId,String keywords) throws Exception{
		ResultModel<List<AppEntranceAdRo>> resultModel =  appEntranceFacadeService.getList(positionId,keywords);
		return  resultModel.getReturnValue();
	}

	/**
	 * @Title: findPositionAllToMap
	 * @Description: 查询所有广告位信息，转为MAP KEY为positionId
	 * @author hcmony
	 */
	public Map<String, AppEntranceAdRo> findPositionAllToMap(String appId){
		Map<String, AppEntranceAdRo> results = Maps.newHashMap();
		try {
			List<AppEntranceAdRo> lists = getList(null,null);
			if(CollectionUtils.isNotEmpty(lists)){
				lists.forEach(position ->{
					//这里没有返回positionId,所以自己动手去拼了
					String positionId = position.getAppKey()+"-"+position.getAppEntranceId();
					results.put(positionId, position);
				});
			}
		}catch (Exception e){
			logger.error(" 根据"+appId+"查询所有广告位信息出错",e);
		}
		return results;
	}
}
