/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.integration.resttemplate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/01/30 10:14
 */
@Component
public class RestTemplateClient<T> {

	@Autowired
	RestTemplate restTemplate;

	/***********HTTP GET method*************/

	/**
	 * 直接返回一个对象
	 * @param url
	 * @param responseType
	 * @return
	 */
	public T getNoParamsForObject(String url, Class<T> responseType){
		return  this.restTemplate.getForObject(URI.create(url), responseType);
	}

	public Map<String,Object> getForEntity(String url, Class<T> responseType){
		ResponseEntity<T> responseEntity = this.restTemplate.getForEntity(URI.create(url), responseType);
		Map<String,Object> map = Maps.newHashMap();
		map.put("statusCode",responseEntity.getStatusCode());
		map.put("header",responseEntity.getHeaders());
		map.put("body",responseEntity.getBody());
		return map;
	}

	/**
	 * 不传参数返回body,用字符串接收
	 * @param url
	 * @param responseType
	 * @return
	 */
	public T getNoParams(String url, Class<T> responseType){
		RequestEntity requestEntity = RequestEntity.get(URI.create(url)).build();
		ResponseEntity<T> responseEntity = this.restTemplate.exchange(requestEntity,responseType);
		return responseEntity.getBody();
	}



	/**********HTTP POST method**************/
	/**
	 * post 直接返回一个对象
	 * @param url
	 * @param responseType
	 * @return
	 */
	public T postNoParamsObject(String url,Object obj, Class<T> responseType){
		return  this.restTemplate.postForObject(URI.create(url),obj, responseType);
	}

	public Map<String,Object> postForEntity(String url,Object obj, Class<T> responseType){
		ResponseEntity<T> responseEntity = this.restTemplate.postForEntity(URI.create(url),obj, responseType);
		Map<String,Object> map = Maps.newHashMap();
		map.put("statusCode",responseEntity.getStatusCode());
		map.put("header",responseEntity.getHeaders());
		map.put("body",responseEntity.getBody());
		return map;
	}

	/**
	 * 不传参数返回body,用字符串接收
	 * @param url
	 * @param responseType
	 * @return
	 */
	public T postNoParams(String url, Class<T> responseType){
		RequestEntity requestEntity = RequestEntity.post(URI.create(url)).build();
		ResponseEntity<T> responseEntity = this.restTemplate.exchange(requestEntity,responseType);
		return responseEntity.getBody();
	}


	/**
	 * 支持传head参数 获取返回
	 * @param url 请求地址
	 * @param params 正常参数
	 * @param headerParams head参数
	 * @param method 请求方法
	 * @return
	 * @throws URISyntaxException
	 */
	public String getByHeadParams(String url, Map<String, Object> params,Map<String, Object> headerParams,HttpMethod method)throws URISyntaxException {
		HttpHeaders headers = new HttpHeaders();

		//头部参数封装
		if(MapUtils.isNotEmpty(headerParams)){
			Set<String> set = headerParams.keySet();
			for (String s:set){
				headers.set(s,(String) headerParams.get(s));
			}
		}

		//  请勿轻易改变此提交方式，大部分的情况下，提交方式都是表单提交
		headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
		//  封装参数，千万不要替换为Map与HashMap，否则参数无法传递
		LinkedMultiValueMap<String, String> p = new LinkedMultiValueMap<>();
		if(MapUtils.isNotEmpty(params)){
			Set<Map.Entry<String, Object>> entries = params.entrySet();
			for (Map.Entry<String, Object> entry : entries) {
				Object value = entry.getValue();
				if (null != value){
					p.put(entry.getKey(), Lists.newArrayList(value.toString()));
				}
			}
		}
		HttpEntity<MultiValueMap<String, String>> requestEntity = new HttpEntity<MultiValueMap<String, String>>(p, headers);
		//  执行HTTP请求
		ResponseEntity<String> response = restTemplate.exchange(url, method, requestEntity, String.class);
		return response.getBody();
	}




	/**
	 * 根据map参数获取返回值
	 * @param url 请求地址
	 * @param params 正常参数
	 * @param method 请求方法
	 * @return
	 * @throws URISyntaxException
	 */
	public  String getByParams(String url, Map<String, Object> params,HttpMethod method,MediaType mediaType) throws IOException {

		HttpHeaders headers = new HttpHeaders();
		//  请勿轻易改变此提交方式，大部分的情况下，提交方式都是表单提交
		headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
		if(null!=mediaType){
			headers.setContentType(mediaType);
		}
		//  封装参数，千万不要替换为Map与HashMap，否则参数无法传递

		LinkedMultiValueMap<String, String> p = new LinkedMultiValueMap<>();
		if(MapUtils.isNotEmpty(params)){
			Set<Map.Entry<String, Object>> entries = params.entrySet();
			for (Map.Entry<String, Object> entry : entries) {
				Object value = entry.getValue();
				if (null != value){
					p.put(entry.getKey(), Lists.newArrayList(value.toString()));
				}
			}
		}

		HttpEntity<MultiValueMap<String, String>> requestEntity = new HttpEntity<MultiValueMap<String, String>>(p, headers);
		//  执行HTTP请求
		ResponseEntity<String> response = restTemplate.exchange(url, method, requestEntity, String.class);
		return response.getBody();
	}

}
