/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.model.constant;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;

public interface CommonConstant {
    public static final String MEIJIE_CODE = "mj";
    public static final String AE_CODE = "ae";
    public static final String BD_CODE = "bd";
    public static final String CACHE_DEFAULT_VALUE = "1";
    public static final String ADX_TICKET_URL_ARGS_NAME = "xid";

    public static KeyGenerator getKeyGeneratorByPositionDomainiCode() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "DOMAINCODE"});
    }

    public static KeyGenerator getWeiboAppId() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "WEIBO"});
    }

    public static KeyGenerator wbToken() {
        return () -> KeyBuilder.build((Object[])new Object[]{"wb", "token"});
    }

    public static enum PhoneBrandType {
        XIAOMI("\u5c0f\u7c73", "xiaomi"),
        HUAWEI("\u534e\u4e3a", "huawei"),
        APPLE("\u82f9\u679c", "apple"),
        OPPO("OPPO", "oppo"),
        SAMSUNG("\u4e09\u661f", "samsung"),
        VIVO("Vivo", "vivo"),
        MEIZU("\u9b45\u65cf", "meizu");

        private String name;
        private String type;

        public static String getNamesByTypes(String types) {
            if (StringUtils.isNotBlank((CharSequence)types)) {
                Object[] typeArray = types.split(",");
                for (int i = 0; i < typeArray.length; ++i) {
                    typeArray[i] = PhoneBrandType.getNameByType((String)typeArray[i]);
                }
                return StringUtils.join((Object[])typeArray, (String)",");
            }
            return "";
        }

        public static String getNameByType(String type) {
            for (PhoneBrandType phoneBrand : PhoneBrandType.values()) {
                if (!phoneBrand.type.equals(type)) continue;
                return phoneBrand.getName();
            }
            return "";
        }

        @ConstructorProperties(value={"name", "type"})
        private PhoneBrandType(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public static enum NetworkType {
        WIFI("Wi-Fi", "1"),
        _5G("5G", "5"),
        _4G("4G", "4"),
        _3G("3G", "3"),
        _2G("2G", "2"),
        UNKNOWN("\u672a\u77e5", "0");

        private String name;
        private String type;

        public static String getNamesByTypes(String types) {
            if (StringUtils.isNotBlank((CharSequence)types)) {
                Object[] typeArray = types.split(",");
                for (int i = 0; i < typeArray.length; ++i) {
                    typeArray[i] = NetworkType.getNameByType((String)typeArray[i]);
                }
                return StringUtils.join((Object[])typeArray, (String)",");
            }
            return "";
        }

        public static String getNameByType(String type) {
            for (NetworkType network : NetworkType.values()) {
                if (!network.type.equals(type)) continue;
                return network.getName();
            }
            return "";
        }

        @ConstructorProperties(value={"name", "type"})
        private NetworkType(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class Environment {
        public static final String PROFILES_DEV = "dev";
        public static final String PROFILES_TEST = "test";
    }

    public static class Opera {

        public static enum Method {
            ADD(1, "\u65b0\u589e"),
            EDIT(2, "\u7f16\u8f91");

            private int type;
            private String desc;

            private Method(int type, String desc) {
                this.type = type;
                this.desc = desc;
            }

            public int getType() {
                return this.type;
            }

            public String getDesc() {
                return this.desc;
            }

            public static Method get(int type) {
                for (Method temp : Method.values()) {
                    if (temp.type != type) continue;
                    return temp;
                }
                return null;
            }

            public static boolean isEdit(Method method) {
                return EDIT == method;
            }

            public static boolean isAdd(Method method) {
                return ADD == method;
            }
        }

        public static enum Platform {
            ADVERTISER(1, "\u5e7f\u544a\u4e3b\u540e\u53f0"),
            ADSMANAGER(2, "\u8fd0\u8425\u540e\u53f0");

            private int type;
            private String desc;

            private Platform(int type, String desc) {
                this.type = type;
                this.desc = desc;
            }

            public int getType() {
                return this.type;
            }

            public String getDesc() {
                return this.desc;
            }

            public static Platform get(int type) {
                for (Platform temp : Platform.values()) {
                    if (temp.type != type) continue;
                    return temp;
                }
                return null;
            }
        }
    }

    public static class OpenFlag {
        public static final Integer OPEN_YES = 1;
        public static final Integer OPEN_NO = 0;
    }

    public static class ClosedFlag {
        public static final Integer CLOSED_YES = 1;
        public static final Integer CLOSED_NO = 0;
    }

    public static class AssetStatus {
        public static final short STATUS_DISABLE = 0;
        public static final short STATUS_ACTIVATE = 1;
        public static final short STATUS_DELETE = 2;
    }

    public static class AssetCheckStatus {
        public static final short CHECK_STATUS_PASS = 1;
        public static final short CHECK_STATUS_WAIT = 2;
    }

    public static class AssetAuditStatus {
        public static final short AUDIT_STATUS_WAIT = 1;
        public static final short AUDIT_STATUS_PASS = 2;
        public static final short AUDIT_STATUS_REFUSE = 3;
    }

    public static class AssetType {
        public static final int TICKET_TYPE_INTERACTIVE = 1;
        public static final int TICKET_TYPE_INSPIRE_VIDEO = 2;
        public static final int TICKET_TYPE_ASSETS_TEMPLATE_ASSETS = 3;
    }

    public static class StatusType {
        public static final short STATUS_DISABLE = 0;
        public static final short STATUS_ACTIVATE = 1;
        public static final short STATUS_DELETE = 2;
    }

    public static class MediaType {
        public static final String APP = "app";
        public static final String H5 = "h5";
        public static final String WECHAT = "weixin";
    }

    public static class RedisKey {
        public static final String POSITION_WEIGHT_KEY = "AD:WEIGHT:POSITION_MIF:";
        public static final String TICKET_WEIGHT_KEY = "AD:WEIGHT:TICKET_MIF";
    }

    public static class Dictionaries {
        public static final String TICKET_STATUS_GROUP_ID = "adstatus";
        public static final String PROXY_DOWNSTREAM = "downstream";
    }

    public static class Export {
        public static final String DEFAULT_FIELD_METHOD = "getDefaultExportFields";
    }

    public static class TicketTag {
        public static final Integer BASIC_PARENT_ID = 0;
        public static final Integer TAG_TYPE_PROPERTY = 1;
        public static final Integer TAG_TYPE_CLASSIFY = 2;
        public static final Integer TAG_TYPE_APTITUDE = 3;
    }

    public static enum SettleTypeEnum {
        CPC((short)1, "CPC"),
        CPA((short)2, "CPA"),
        CPM((short)4, "CPM"),
        OCPR((short)5, "OCPR");

        private Short type;
        private String name;

        public static String getNameBySettleType(Short type) {
            for (SettleTypeEnum settleTypeEnum : SettleTypeEnum.values()) {
                if (!settleTypeEnum.getType().equals(type)) continue;
                return settleTypeEnum.getName();
            }
            return "";
        }

        public static boolean isOcpr(Short settleType) {
            if (settleType == null) {
                return false;
            }
            return SettleTypeEnum.OCPR.type.equals(settleType);
        }

        public Short getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        @ConstructorProperties(value={"type", "name"})
        private SettleTypeEnum(Short type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static class TicketSettleType {
        public static final Short CPC = 1;
        public static final Short CPA = 2;
        public static final Short CPM = 4;
    }

    public static class TicketStatusGroupIdPreFix {
        public static final String PAUSE = "2-";
    }

    public static class Rule {
        public static final String POSITION_WHITE_PREFIX = "1";
        public static final String POSITION_BLACK_PREFIX = "2";
    }

    public static class BaseCharacter {
        public static final String BAR = "-";
        public static final String COMMA = ",";
        public static final String SPOT = ".";
        public static final String QUESTION_MARK = "?";
    }
}

