package com.bxm.adsmanager.monitor;

import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;


/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/03/16 11:46
 */
@EnableDiscoveryClient
@EnableFeignClients({ "com.bxm.adapi.facade",
        "com.bxm.app.facade",
        "com.bxm.profit.facade",
        "com.bxm.log.facade",
        "com.bxm.adsmanager.integration.advertiser.service",
        "com.bxm.datapark.facade",
        "com.bxm.acl.facade",
        "com.bxm.adsmedia.facade",
        "com.bxm.adsmanager.integration.adsmedia"})
//@MapperScan(basePackages = {"com.bxm.adsmanager.dal.mapper", "com.bxm.adsmanager.dal.mapper2"})
@MapperScan(basePackages = {"com.bxm.adsmanager.dal.mapper"})
//@ImportResource({ "classpath:application-domain.xml" })
@ComponentScan(basePackages = {"com.bxm"})
@EnableAsync(proxyTargetClass = true)
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class})
public class AdsMonitorApplication {
    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(AdsMonitorApplication.class);
        application.addListeners(new SpringBootEnvironmentListener());
        application.run(args);
    }

    @Bean
    public CorsFilter corsFilter() {

        final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        final CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(true); // 允许cookies跨域
        config.addAllowedOrigin("*");// #允许向该服务器提交请求的URI，*表示全部允许，在SpringMVC中，如果设成*，会自动转成当前请求头中的Origin
        config.addAllowedHeader("*");// #允许访问的头信息,*表示全部
        config.setMaxAge(18000L);// 预检请求的缓存时间（秒），即在这个时间段里，对于相同的跨域请求不会再预检了
        config.addAllowedMethod("OPTIONS");// 允许提交请求的方法，*表示全部允许
        config.addAllowedMethod("HEAD");
        config.addAllowedMethod("GET");// 允许Get的请求方法
        config.addAllowedMethod("PUT");
        config.addAllowedMethod("POST");
        config.addAllowedMethod("DELETE");
        config.addAllowedMethod("PATCH");
        source.registerCorsConfiguration("/**", config);
        //
        return new CorsFilter(source);
    }

    @Bean
    public ThreadPoolExecutor threadPoolExecutor() {
        return new ThreadPoolExecutor(10, 10, 0, TimeUnit.SECONDS, new LinkedBlockingDeque<>());
    }
}
