package com.bxm.adsmanager.monitor.controller.cesu;

import com.bxm.adsmanager.model.dao.monitor.CeSuUrl;
import com.bxm.adsmanager.monitor.controller.base.BaseController;
import com.bxm.adsmanager.service.monitor.CeSuUrlService;
import com.bxm.adsmanager.service.monitor.impl.CeSuUrlServiceImpl;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.SendTicketDto;
import com.bxm.datapark.facade.ticket.model.vo.SendTicketVo;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping("/17ce")
public class CeSuUrlController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(CeSuUrlController.class);
    
    @Autowired
    private CeSuUrlService ceSuUrlServiceImpl; 

    /**
     * 查找17测速网站，最近5分钟的测试结果
     */
    @RequestMapping(value = "/getList", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<List<CeSuUrl>> getTicketCompare(HttpServletRequest httpServletRequest,
                                                       HttpServletResponse httpServletResponse,
                                                       @RequestParam(name = "startTime",required = true) String startTime,
                                                       @RequestParam(name = "endTime",required = true) String endTime) {
        ResultModel<List<CeSuUrl>> rs = new ResultModel<>();
        try {
            List<CeSuUrl> list=ceSuUrlServiceImpl.getCeList(startTime,endTime);
            rs.setReturnValue(list);
        } catch (Exception e) { 
            LOGGER.error("查询测速列表错误");
            rs.setSuccessed(false);
            rs.setErrorDesc("查询测速列表错误");
        }
        return rs;
    }

}
