package com.bxm.adsmanager.monitor.controller.manual;

import com.bxm.adsmanager.monitor.controller.timer.*;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description 定时器手动触发接口(已经接入调度中心)
 * @date 2019/02/26 13:49
 */
@RestController
@RequestMapping("/common/adsmanager/monitor")
public class ManualController {

    @Autowired
    private PositionTimer positionTimer;

    @Autowired
    private TicketTimer ticketTimer;

//    @Autowired
//    private AlarmTimer alarmTimer;

    @Autowired
    private PositionTicketWarnTimer positionTicketWarnTimer;

    @Autowired
    private PositionUvUpdateTimer positionUvUpdateTimer;

    @Autowired
    private TicketCostWarnJob ticketCostWarnJob;

    /*
     * @description 广告位备用券报警信息,半个小时执行一次
     * @date 2019/2/26 14:04
     */
    @RequestMapping("/positionSpareTicketWarn")
    public ResultModel sendPositionSpareTicketWarnInfo() throws Exception{
        positionTimer.sendPositionSpareTicketWarnInfoJob();
        return ResultModelFactory.SUCCESS();
    }

    /**********************************************************************/

    /*
     * @description 广告券落地页报警信息,半个小时执行一次
     * @date 2019/2/26 14:05
     */
    @RequestMapping("/ticketUrlWarn")
    public ResultModel sendTicketUrlWarnInfo() {
        ticketTimer.sendTicketUrlWarnInfoJob();
        return ResultModelFactory.SUCCESS();
    }
    /*********************************************************************/


    /*
     * @description 人均券点击之类的报警
     * @date 2019/2/26 18:54
     */
    @RequestMapping("/alarmJob")
    public ResultModel alarmJob() {
//        alarmTimer.job();
        return ResultModelFactory.SUCCESS();
    }

    /*********************************************************************/

    @RequestMapping("/positionTicketWarn")
    public ResultModel positionTicketWarn() {
        positionTicketWarnTimer.positionTicketWarn();
        positionTicketWarnTimer.messageSend();
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping("/rePositionTicketWarn")
    public ResultModel rePositionTicketWarn() {
        positionTicketWarnTimer.rePositionTicketWarn();
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping("/deletePositionTicketDate")
    public ResultModel deletePositionTicketDate() {
        positionTicketWarnTimer.deletePositionTicketDate();
        return ResultModelFactory.SUCCESS();
    }

    /*********************************************************************/

    @RequestMapping("/positionUvUpdate")
    public ResultModel positionUvUpdateJob() {
        positionUvUpdateTimer.job();
        return ResultModelFactory.SUCCESS();
    }

    /**********************************************************************/

    @RequestMapping("/ticketCostWarn")
    public ResultModel ticketCostWarn() {
        ticketCostWarnJob.ticketCostWarnDing();
        return ResultModelFactory.SUCCESS();
    }

}
