package com.bxm.adsmanager.monitor.controller.timer;

import com.bxm.adsmanager.model.constant.WarnConfigTemplateConstant;
import com.bxm.adsmanager.model.dto.monitor.PositionSpareTicketDto;
import com.bxm.adsmanager.model.enums.WarnConfigEnum;
import com.bxm.adsmanager.model.vo.monitor.PositionSpareTicketVo;
import com.bxm.adsmanager.service.monitor.PositionWarnConfigService;
import com.bxm.adsmanager.utils.DingtalkMsgUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

import java.text.MessageFormat;
import java.util.List;

/**
 * @author wangchao
 * @Title:PositionTimer.java
 * @Package:com.bxm.adsmanager.monitor.controller.timer
 * @Description: 广告位上报警数据
 * @date:2018年10月8日 上午11:51:25
 */
@Component
@EnableScheduling
public class PositionTimer {

    private static final Logger LOGGER = LoggerFactory.getLogger(PositionTimer.class);

    /**
     * 广告位预警配置接口
     */
    @Autowired
    private PositionWarnConfigService positionWarnConfigService;

    @Autowired
    private Environment environment;

    //发送广告位备用券发券占比报警数据
    //@Scheduled(cron = "0 0/30 * * * ?")
    public void sendPositionSpareTicketWarnInfoJob() {
        //获取激活环境
        String[] env = environment.getActiveProfiles();
        Boolean envFlag = null;
        if (ArrayUtils.isNotEmpty(env)) {
            envFlag = false;
            if (ArrayUtils.contains(env, "dev") || ArrayUtils.contains(env, "test")) {
                envFlag = true;
            }
        }
        PositionSpareTicketDto param = new PositionSpareTicketDto();
        List<PositionSpareTicketVo> list = null;
        try {
            list = positionWarnConfigService.getPositionSpareTicketWarnList(param);
            if (!CollectionUtils.isEmpty(list)) {
                String desc = "";
                for (PositionSpareTicketVo record : list) {
                    //消息模板详细信息
                    desc += generateSpareTicketWarnTemplate(record) + ";" + "\n";
                }
                if (StringUtils.isNotBlank(desc) && envFlag!=null && !envFlag) {
                    //线上钉钉224cce0b19c459fdf43cdd04f8fd4b19dbad6edbfdb2908e223aa5bf3c818718
                    DingtalkMsgUtil.sendMsg(
                            "https://oapi.dingtalk.com/robot/send?access_token=224cce0b19c459fdf43cdd04f8fd4b19dbad6edbfdb2908e223aa5bf3c818718",
                            desc, false, null);
                }
                //上线可去掉以下代码
                if (StringUtils.isNotBlank(desc) && envFlag!= null && envFlag) {
                    //测试钉钉d733229dec9ee619316ce647080defbc29b725a03c1fbe9c19ed0b6628553361
                    DingtalkMsgUtil.sendMsg(
                            "https://oapi.dingtalk.com/robot/send?access_token=d733229dec9ee619316ce647080defbc29b725a03c1fbe9c19ed0b6628553361",
                            desc, false, null);
                }
            }
        } catch (Exception e) {
            LOGGER.error("发送广告位备用券发券占比报警信息异常:" + e.getMessage(), e);
        }
    }

    //消息模板封装
    private String generateSpareTicketWarnTemplate(PositionSpareTicketVo record) {
        //广告位名称
        String param0 = record.getAppEntranceName();
        //广告位ID
        String param1 = record.getPositionId();
        //监控项目
        String param2 = WarnConfigEnum.POSITION_SPARE_TICKET.getConfigDesc();
        //粒度环境
        String param3 = "广告位";
        //监控时间范围
        Integer param4 = record.getMonitorPeriod();
        //设置的阈值
        Double param5 = record.getThresholdSpareOpenProportionMax();
        //当前值
        Double param6 = record.getSpareOpenProportion();
        String templateInfo = MessageFormat.format(WarnConfigTemplateConstant.WARN_INFO_TEMPLATE, param0, param1, param2, param3, param4, param5, param6);
        return templateInfo;
    }

}
