package com.bxm.adsmanager.monitor.controller.timer;

import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkAlarmIntegration;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * Created by wuwenquan on 2018/12/17.
 */
@Component
@EnableScheduling
public class PositionUvUpdateTimer {
    @Autowired
    private DataparkAlarmIntegration dataparkAlarmIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    //@Scheduled(cron = "0 10 2 * * ? ")
    public void job() {
         List<AppEntranceAdRO> positionList = newAppEntranceFacadeIntegration.getAllList(new QueryAppEntranceParamDTO());
         String day = DateUtil.dateTo8String1(DateUtil.getDateBefore(new Date(), 1));
         for (AppEntranceAdRO appEntranceAdRo : positionList) {
             String positionId = appEntranceAdRo.getPositionId();
             String[] split = positionId.split("-");
             if (split.length != 2) {
                 continue;
             }
             String appkey=split[0];
             String business=split[1];
             String key = RedisKeys.AD_POSITION_UV_ + day;
             Long uvByDay = dataparkAlarmIntegration.findUvByDay(appkey, business, day);
             stringRedisTemplate.opsForHash().put(key, positionId, String.valueOf(uvByDay));

             }
         }

}
