package com.bxm.adsmanager.monitor.controller.timer;

import com.bxm.adsmanager.model.vo.AdTicketCostLogVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketCostService;
import com.bxm.adsmanager.utils.DingtalkMsgUtil;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author sunzs
 * created on 2019/1/24
 */

@Component
@EnableScheduling
public class TicketCostWarnJob {

    @Autowired
    private AdTicketCostService adTicketCostService;
    @Autowired
    JedisFetcher jedisFetcher;

    @Value("${ticket.cost.warn.dingding.token}")
    private String token;



    /**
     * ①每半小时运⾏推送钉钉群一次，上次已经做过推送的数据不再推送，即每天10:00开始推送，10:00推送9:45-10:00之间产生的数据；
     * 10:30进行二次推送，推送10:00-10:30产生的数据，以此类推，直到23:00点推送22:00-22:30的数据，
     * 当天结束推送（开始时间9:45，结束时间22:30，每天推送）
     *
     * ②只推送广告状态为启用（以当前查询推送时间为时间节点）的数据
     * */

    // TODO: 2019/4/2 暂时弃用 改为实时推送钉钉群
    //@Scheduled(cron = "0 0/30 10-23 * * ? ")//从10点开始到23点结束，每一小时一次
    public void ticketCostWarnDing(){

        //查找开启、在券消耗表中存在、
        List<AdTicketCostLogVo> list = Lists.newArrayList();
        String start = null;
        String end = null;
        Date now = new Date();

        SimpleDateFormat sdf1 = new SimpleDateFormat("HH:mm");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        String time = sdf1.format(now);
        String year = sdf2.format(now);
        //10:00推送9:45-10:00之间产生的数据
        if (time.equals("10:00")){
            start = year+" 09:45";
            end = year+" 10:01";
            list = findByParam(start,end);
            if (CollectionUtils.isNotEmpty(list)){
                sendDing(list);
            }
        }else{
            // 11:00推送10:00-11:00产生的数据,以此类推
            Date old_time = new Date(now.getTime() - 30*60*1000);
            Date end_time = new Date(now.getTime() + 60*1000);

            //加一分钟  防止mysql取头不取尾
            start = year+" "+sdf1.format(old_time);
            end =year+" "+sdf1.format(end_time);
            list = findByParam(start,end);
            if (CollectionUtils.isNotEmpty(list)){
                sendDing(list);
            }
        }
    }

    private void sendDing(List<AdTicketCostLogVo> list){
        String content = getContent(list);
        if (StringUtils.isNotBlank(content)){
            String url = "https://oapi.dingtalk.com/robot/send?access_token="+token;
            List<String> phones = new ArrayList<>();
            //占义昌、王凯琪
            phones.add("18268830685");
            phones.add("13755681624");
            DingtalkMsgUtil.sendMsg(url,content,false, phones);
        }
    }


    public  String getContent(List<AdTicketCostLogVo> list){
        String content = "";
        for (AdTicketCostLogVo adTicketCostLogVo : list){
           /* String TicketCostWarnNames =  jedisFetcher.hfetch(() -> KeyBuilder.build("AD","TICKET","COSWARNNAME"),adTicketCostLogVo.getTicketId()+"",String.class);
            List<TicketCostWarnName> oldList = JSON.parseArray(TicketCostWarnNames,TicketCostWarnName.class);
            StringBuffer string = new StringBuffer();
            if (CollectionUtils.isNotEmpty(oldList)){
                for (TicketCostWarnName ticketCostWarnName: oldList){
                    if (string.length() > 0) {
                        string.append("、");
                    }
                    if (StringUtils.isBlank(ticketCostWarnName.getNeedCost())){
                        ticketCostWarnName.setNeedCost("0");
                    }
                    string.append(ticketCostWarnName.getName()+ticketCostWarnName.getNeedCost()+"元");
                }
            }*/
            content += "\n id "+ adTicketCostLogVo.getTicketId()+" "+adTicketCostLogVo.getNeed()+" "+"\n "+adTicketCostLogVo.getOutsideUrl()+"&isSupplement=1"+"\n";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        Date time = new Date();
        String endTime =  sdf.format(time.getTime()+1000*60*60);
        content =  content + "\n\n 结束时间 " + endTime+"\n 注:充值金金额必须消耗完!!!所有的充值、复充金金额 不可以一样(以20、30、40、50、70来安排）\n";
        return content;
    }


    public List<AdTicketCostLogVo> findByParam(String start,String end){
        if (StringUtils.isBlank(start)||StringUtils.isBlank(end)){
            return new ArrayList<>();
        }
        Map<String,Object> map = new HashMap<>();
        map.put("start",start);
        map.put("end",end);
        return adTicketCostService.findToDing(map);
    }




}


