package com.bxm.adsmanager.monitor.controller.warn;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.ro.AdPositionAlarmRo;
import com.bxm.adsmanager.model.vo.AlarmPlanPositionVo;
import com.bxm.adsmanager.monitor.controller.base.BaseController;
import com.bxm.adsmanager.service.alarm.AdPositionAlarmService;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author yirenjie
 * createDate:  2019/3/6
 */
@RestController
@RequestMapping("/adPositionAlarm")
@Slf4j
public class AdPositionAlarmController extends BaseController {

    @Resource
    private AdPositionAlarmService adPositionAlarmService;

    @RequestMapping("/queryList")
    public ResultModel<PageInfo<AlarmPlanPositionVo>> queryList(HttpServletRequest request, HttpServletResponse response,
                                                                AdPositionAlarmRo adPositionAlarmRo){
        ResultModel<PageInfo<AlarmPlanPositionVo>> resultModel = new ResultModel<>();
        User user = getUser(request, response);
        resultModel.setReturnValue(adPositionAlarmService.queryList(adPositionAlarmRo, user));
        return resultModel;
    }

    @RequestMapping("/submitAlarmPlans")
    public ResultModel submitAlarmPlans(HttpServletRequest request, HttpServletResponse response,
                                        AdPositionAlarmRo adPositionAlarmRo) {
        ResultModel resultModel = new ResultModel();
        User user = getUser(request, response);
        resultModel.setSuccessed(adPositionAlarmService.submitAlarmPlans(adPositionAlarmRo, user));
        return resultModel;
    }
}
