package com.bxm.adsmanager.monitor.controller.warn;

import com.bxm.adsmanager.model.dao.monitor.AdPositionTagToday;
import com.bxm.adsmanager.model.dao.monitor.AdTicketTagToday;
import com.bxm.adsmanager.model.dao.monitor.PositionTicketThreshold;
import com.bxm.adsmanager.monitor.controller.base.BaseController;
import com.bxm.adsmanager.service.monitor.AdPositionTicketService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.util.dto.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author sunzs
 * created on 2019/1/7
 */
@RestController
@RequestMapping("/positionTicket")
@Slf4j
public class AdPositionTicketController extends BaseController {

    @Autowired
    private AdPositionTicketService adPositionTicketService;


    /**
     *
     * 功能描述:广告类别报警阈值添加
     * @fileName:
     * @param: [positionTicketThreshold]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/1/8 14:38
     */
    @RequestMapping(value = "/add",method = RequestMethod.GET)
    public ResultModel add(PositionTicketThreshold positionTicketThreshold){
        return adPositionTicketService.add(positionTicketThreshold);

    }
    /**
     *
     * 功能描述:
     * @fileName:广告类别报警阈值查询
     * @param: [positionTicketThreshold]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/1/8 14:38
     */
    @RequestMapping(value = "/findAll",method = RequestMethod.GET)
    public ResultModel findAll(PositionTicketThreshold positionTicketThreshold,
                               @RequestParam(value = "pageNum",defaultValue = "1") Integer pageNum,
                               @RequestParam(value = "pageSize",defaultValue = "10") Integer pageSize){
        return adPositionTicketService.findAll(positionTicketThreshold,pageNum,pageSize);
    }

    /**
     *
     * 功能描述:
     * @fileName:广告类别报警阈值修改
     * @param: [positionTicketThreshold]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/1/8 14:38
     */
    @RequestMapping(value = "/update",method = RequestMethod.POST)
    public  ResultModel update(PositionTicketThreshold positionTicketThreshold){
        return adPositionTicketService.update(positionTicketThreshold);
    }

    /**
     *
     * 功能描述:
     * @fileName:问题数据广告位维度报表分页查询
     * @param: [ticketTag, keyword, dateTime]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/1/9 14:13
     */
    @RequestMapping(value = "/findPositionWarnPage",method = RequestMethod.GET)
    public ResultModel findPositionWarnPage(@RequestParam(value = "ticketTag")String ticketTag,
                                            @RequestParam(value = "keyword") String keyword,
                                            @RequestParam(value = "dateTime")String dateTime,
                                            @RequestParam(value = "pageSize",defaultValue = "20")Integer pageSize,
                                            @RequestParam(value = "pageNum",defaultValue = "1")Integer pageNum,
                                            @RequestParam(value = "sortName",defaultValue = "clickPv")String sortName,
                                            @RequestParam(value = "sortType",defaultValue = "desc")String sortType){


        return adPositionTicketService.findPositionWarnPage(ticketTag,keyword,dateTime,pageNum,pageSize,sortName,sortType);
    }


    /**
     *
     * 功能描述:
     * @fileName:
     * @param: [adPositionTagToday]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/1/11 18:32
     */
    @RequestMapping(value = "/updatePositionWarn",method = RequestMethod.POST)
    public ResultModel updatePositionWarn(AdPositionTagToday adPositionTagToday){

        return adPositionTicketService.updatePositionWarn(adPositionTagToday);
    }

    /**
     *
     * 功能描述:
     * @fileName:问题数据广告位维度报表导出
     * @param: [ticketTag, keyword, dateTime]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/1/9 14:13
     */
    @RequestMapping(value = "/excludePositionWarn",method = RequestMethod.GET)
    public void excludePositionWarn(@RequestParam(value = "ticketTag")String ticketTag,
                                        @RequestParam(value = "keyword") String keyword,
                                        @RequestParam(value = "dateTime")String dateTime, HttpServletResponse response){
        List<AdPositionTagToday> list = adPositionTicketService.excludePositionWarn(ticketTag,keyword,dateTime);
        ExcelUtil.exportExcel(list,null,null,AdPositionTagToday.class,"广告位问题数据报表.xls",response);
    }


    /**
     *
     * 功能描述:
     * @fileName:问题数据广告券维度报表分页查询
     * @param: [ticketTag, ticketId, advertiser, dateTime]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/1/9 14:19
     */
    @RequestMapping(value = "/findTicketWarnPage",method = RequestMethod.GET)
    public ResultModel findTicketWarnPage(@RequestParam(value = "ticketTag")String ticketTag,
                                          @RequestParam(value = "ticketId")Long ticketId,
                                          @RequestParam(value = "advertiser")String advertiser,
                                          @RequestParam(value = "dateTime")String dateTime,
                                          @RequestParam(value = "pageNum")Integer pageNum,
                                          @RequestParam(value = "pageSize")Integer pageSize,
                                          @RequestParam(value = "sortName",defaultValue = "clickPv")String sortName,
                                          @RequestParam(value = "sortType",defaultValue = "desc")String sortType){
        ResultModel resultModel = new ResultModel();
        try {
           return adPositionTicketService.findTicketWarnPage(ticketTag,ticketId,dateTime,advertiser,pageNum,pageSize,sortName,sortType);
        }catch (Exception e){
            log.error("问题数据查询异常"+e.getMessage(),e);
        }
        return resultModel;

    }


    /**
     *
     * 功能描述:
     * @fileName:问题数据广告券维度报表导出
     * @param: [ticketTag, ticketId, advertiser, dateTime]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/1/9 14:22
     */
    @RequestMapping(value = "/excludeTicketWarn",method = RequestMethod.GET)
    public void excludeTicketWarn(@RequestParam(value = "ticketTag")String ticketTag,
                                  @RequestParam(value = "ticketId")Long ticketId,
                                  @RequestParam(value = "advertiser")String advertiser,
                                  @RequestParam(value = "dateTime")String dateTime, HttpServletResponse response){
        try {
           List<AdTicketTagToday> list = adPositionTicketService.excludeTicketWarn(ticketId,advertiser,dateTime,ticketTag);
           ExcelUtil.exportExcel(list,null,null,AdTicketTagToday.class,"广告券问题数据报表.xls",response);
        }catch (Exception e){
            log.error("问题数据导出异常"+e.getMessage(),e);
        }

    }

}
