package com.bxm.adsmanager.monitor.controller.warn;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdPositionSearchDto;
import com.bxm.adsmanager.model.dto.monitor.PositionSpareTicketDto;
import com.bxm.adsmanager.model.dto.monitor.PositionWarnConfigDto;
import com.bxm.adsmanager.model.enums.WarnConfigEnum;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.monitor.PositionSpareTicketVo;
import com.bxm.adsmanager.monitor.controller.base.BaseController;
import com.bxm.adsmanager.service.adkeeper.AdPositionService;
import com.bxm.adsmanager.service.monitor.PositionWarnConfigService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.util.ArrayList;
import java.util.List;

/**
* @Title:AdPrositionController.java
* @Package:com.bxm.adsmanager.monitor.controller.adkeeper
* @Description: 广告位预警配置类
* @date:2018年8月7日 下午4:32:08
 */
@RequestMapping("/monitor")
@RestController
public class AdPrositionConfigController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdPrositionConfigController.class);

    @Autowired
    private AdPositionService adPositionService;

    /**
     * 广告位预警配置接口
     */
    @Autowired
    private PositionWarnConfigService positionWarnConfigService;

    @RequestMapping(value = "/findPositionAll", method = RequestMethod.GET)
    public ResultModel<Pagination> findAll(HttpServletRequest request, HttpServletResponse response,
            AdPositionSearchDto adPositionSearchDto) {
        ResultModel<Pagination> rs = new ResultModel<Pagination>();
        if (null == adPositionSearchDto) {
            adPositionSearchDto = new AdPositionSearchDto();
        }
        Pagination result = null;
        try {
            result = adPositionService.findAll(adPositionSearchDto);
        } catch (Exception e) {
            LOGGER.error("广告位查询错误" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("广告位查询错误");
        }
        rs.setReturnValue(result);
        return rs;
    }

    @RequestMapping(value = "/findPositionConfigAll", method = RequestMethod.POST)
    public ResultModel<Pagination> findPositionConfigAll(HttpServletRequest request,
            @RequestParam(name = "positionIds", required = false) String positionIds,
            @RequestParam(name = "keywords", required = false) String keywords,
            @RequestParam(name = "pageNum", required = true) Integer pageNum,
            @RequestParam(name = "pageSize", required = true) Integer pageSize) {
        ResultModel<Pagination> resultModel = new ResultModel<Pagination>();
        Pagination pagination = null;
        PositionWarnConfigDto param = new PositionWarnConfigDto();
        param.setPageNum(pageNum);
        param.setPageSize(pageSize);
        if (StringUtils.isNotBlank(keywords)) {
            param.setKeywords(keywords);
        }
        try {
            //新添加的广告位
            if (StringUtils.isNotBlank(positionIds)) {
                //ID集合
                List<String> positionIdList = JSON.parseArray(positionIds, String.class);
                if (!CollectionUtils.isEmpty(positionIdList)) {
                    param.setPositionIdList(positionIdList);
                }
            }
            pagination = positionWarnConfigService.getAllPositionConfigList(param);
        } catch (Exception e) {
            LOGGER.error("查询广告位配置信息错误" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查询广告位配置信息错误");
        }
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    @RequestMapping(value = "/findPositionConfigNoPage", method = RequestMethod.GET)
    public ResultModel<List<String>> findPositionConfigNoPage(HttpServletRequest request, PositionWarnConfigDto param) {
        ResultModel<List<String>> resultModel = new ResultModel<List<String>>();
        if (null == param) {
            param = new PositionWarnConfigDto();
        }
        List<String> list = null;
        try {
            list = positionWarnConfigService
                    .getAllConfigPositionId(WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey());
        } catch (Exception e) {
            LOGGER.error("查询所有广告位配置信息错误" + e.getMessage(), e);
            resultModel.setErrorDesc("查询所有广告位配置信息错误");
            resultModel.setSuccessed(false);
            return resultModel;
        }
        resultModel.setReturnValue(list);
        return resultModel;
    }

    @RequestMapping(value = "/spareTicketReport", method = RequestMethod.GET)
    public ResultModel<PageInfo<PositionSpareTicketVo>> analysisPositionSpareTicket(HttpServletRequest request,HttpServletResponse response,
            PositionSpareTicketDto param) {
        ResultModel<PageInfo<PositionSpareTicketVo>> resultModel = new ResultModel<PageInfo<PositionSpareTicketVo>>();
        if (null == param) {
            param = new PositionSpareTicketDto();
        }
        User user= getUser(request,response);
        param.setUser(user);
        List<PositionSpareTicketVo> list = null;
        PageInfo<PositionSpareTicketVo> pageInfo = null;
        try {
            //查询广告位备用券报警数据
            pageInfo = positionWarnConfigService.getPositionSpareTicketWarnPageList(param);
        } catch (Exception e) {
            LOGGER.error("查询广告位备用券发券占比报警数据失败" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        resultModel.setReturnValue(pageInfo);
        return resultModel;
    }

    @RequestMapping(value = "/exportPositionSpareTicketReport", method = RequestMethod.GET)
    public void exportPositionSpareTicketReport(HttpServletRequest request, HttpServletResponse response,
            PositionSpareTicketDto param) {
        if (null == param) {
            param = new PositionSpareTicketDto();
        }
        User user= getUser(request,response);
        param.setUser(user);
        List<PositionSpareTicketVo> list = null;
        try {
            list = positionWarnConfigService.getPositionSpareTicketWarnList(param);
        } catch (Exception e) {
            LOGGER.error("导出广告位备用券发券占比报警数据失败" + e.getMessage(), e);
            list = new ArrayList<PositionSpareTicketVo>();
        }
        //导出数据
        ExcelUtil.exportExcel(list, null, "广告位备用券发券占比数据", PositionSpareTicketVo.class, "广告位备用券发券占比.xls", response);
    }
    
    @RequestMapping(value = "/spareTicketWarnCount", method = RequestMethod.GET)
    public ResultModel<Long> getPositionSpareTicketWarnCount(HttpServletRequest request,
            PositionSpareTicketDto param) {
        ResultModel<Long> resultModel = new ResultModel<Long>();
        if (null == param) {
            param = new PositionSpareTicketDto();
        }
        Long count = 0L;
        try {
            //查询广告位备用券报警记录数
            count = positionWarnConfigService.getPositionSpareTicketWarnCount(param);
        } catch (Exception e) {
            LOGGER.error("查询广告位备用券发券占比报警记录数失败" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        resultModel.setReturnValue(count);
        return resultModel;
    }
    

}
