package com.bxm.adsmanager.monitor.controller.warn;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.monitor.TicketUrlDto;
import com.bxm.adsmanager.model.dto.monitor.TicketWarnConfigDto;
import com.bxm.adsmanager.model.enums.WarnConfigEnum;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.monitor.TicketUrlVo;
import com.bxm.adsmanager.model.vo.monitor.TicketWarnConfigVo;
import com.bxm.adsmanager.monitor.controller.base.BaseController;
import com.bxm.adsmanager.service.monitor.TicketWarnConfigService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.util.ArrayList;
import java.util.List;

/**
* @Title:AdTicketConfigController.java
* @Package:com.bxm.adsmanager.monitor.controller.warn
* @Description: 广告券预警配置类
* @date:2018年8月8日 下午2:59:59
 */
@RestController
@RequestMapping("/monitor")
public class AdTicketConfigController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketConfigController.class);

    /**
     * 广告券预警配置接口
     */
    @Autowired
    private TicketWarnConfigService ticketWarnConfigService;

    @RequestMapping(value = "/findTicketConfigAll", method = RequestMethod.POST)
    public ResultModel<Pagination> findTicketConfigAll(HttpServletRequest request,
            @RequestParam(name = "ticketIds", required = false) String ticketIds,
            @RequestParam(name = "keywords", required = false) String keywords,
            @RequestParam(name = "pageNum", required = true) Integer pageNum,
            @RequestParam(name = "pageSize", required = true) Integer pageSize) {
        ResultModel<Pagination> resultModel = new ResultModel<Pagination>();
        Pagination pagination = null;
        TicketWarnConfigDto param = new TicketWarnConfigDto();
        param.setPageNum(pageNum);
        param.setPageSize(pageSize);
        if (StringUtils.isNotBlank(keywords)) {
            if (StringUtils.isNumeric(keywords)) {
                param.setTicketId(Long.parseLong(keywords));
            }
            if (!StringUtils.isNumeric(keywords)) {
                param.setTicketName(keywords);
            }
        }
        try {
            //新添加的广告位
            if (StringUtils.isNotBlank(ticketIds)) {
                //ID集合
                List<Long> ticketIdList = JSON.parseArray(ticketIds, Long.class);
                if (!CollectionUtils.isEmpty(ticketIdList)) {
                    param.setTicketIds(ticketIdList);
                }
            }
            pagination = ticketWarnConfigService.getAllTicketConfigList(param);
        } catch (Exception e) {
            LOGGER.error("查询广告券配置信息错误" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查询广告券配置信息错误");
        }
        resultModel.setReturnValue(pagination);
        return resultModel;
    }

    @RequestMapping(value = "/findTicketConfigNoPage", method = RequestMethod.GET)
    public ResultModel<List<Long>> findTicketConfigNoPage(HttpServletRequest request, TicketWarnConfigDto param) {
        ResultModel<List<Long>> resultModel = new ResultModel<List<Long>>();
        if (null == param) {
            param = new TicketWarnConfigDto();
        }
        if (StringUtils.isNotBlank(param.getKeywords()) && StringUtils.isNumeric(param.getKeywords())) {
            param.setTicketId(Long.parseLong(param.getKeywords()));
        }
        if (StringUtils.isNotBlank(param.getKeywords()) && !StringUtils.isNumeric(param.getKeywords())) {
            param.setTicketName(param.getKeywords());
        }
        List<Long> list = null;
        try {
            list = ticketWarnConfigService.getAllConfigTicketId(WarnConfigEnum.TICKET_URL.getConfigKey());
        } catch (Exception e) {
            LOGGER.error("查询所有广告券配置信息错误" + e.getMessage(), e);
            resultModel.setErrorDesc("查询所有广告券配置信息错误");
            resultModel.setSuccessed(false);
            return resultModel;
        }
        resultModel.setReturnValue(list);
        return resultModel;
    }

    @RequestMapping(value = "/findTicketAll", method = RequestMethod.GET)
    public ResultModel<PageInfo<TicketWarnConfigVo>> findTicketAll(HttpServletRequest request,
            TicketWarnConfigDto param) {
        ResultModel<PageInfo<TicketWarnConfigVo>> resultModel = new ResultModel<PageInfo<TicketWarnConfigVo>>();
        if (null == param) {
            param = new TicketWarnConfigDto();
        }
        if (StringUtils.isNotBlank(param.getKeywords()) && StringUtils.isNumeric(param.getKeywords())) {
            param.setTicketId(Long.parseLong(param.getKeywords()));
        }
        if (StringUtils.isNotBlank(param.getKeywords()) && !StringUtils.isNumeric(param.getKeywords())) {
            param.setTicketName(param.getKeywords());
        }
        PageInfo<TicketWarnConfigVo> pageInfo = null;
        try {
            pageInfo = ticketWarnConfigService.getAllTicketList(param);
        } catch (Exception e) {
            LOGGER.error("查询广告券信息错误" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查询广告券信息错误");
        }
        resultModel.setReturnValue(pageInfo);
        return resultModel;
    }

    @RequestMapping(value = "/ticketUrlReport", method = RequestMethod.GET)
    public ResultModel<PageInfo<TicketUrlVo>> analysisTicketUrl(HttpServletRequest request,HttpServletResponse response, TicketUrlDto param) {
        ResultModel<PageInfo<TicketUrlVo>> resultModel = new ResultModel<PageInfo<TicketUrlVo>>();
        if (null == param) {
            param = new TicketUrlDto();
        }
        PageInfo<TicketUrlVo> pageInfo = null;
        User user = getUser(request,response);
        if (StringUtils.isNotBlank(UserRoleCodeUtil.isAe(user)) && StringUtils.isNotBlank(param.getAeCode())
                && !param.getAeCode().equals(user.getUsername())){
            resultModel.setReturnValue(pageInfo);
            return resultModel;
        }
        if (StringUtils.isNotBlank(UserRoleCodeUtil.isSale(user))){
            param.setSale(user.getUsername());
        }
        if (StringUtils.isNotBlank(UserRoleCodeUtil.isAe(user))){
            param.setAeCode(user.getUsername());
        }
        try {
            //查询广告券落地页报警数据
            pageInfo = ticketWarnConfigService.getTicketUrlWarnPageList(param);
        } catch (Exception e) {
            LOGGER.error("查询广告券落地页到达率报警数据失败" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        resultModel.setReturnValue(pageInfo);
        return resultModel;
    }
    
    @RequestMapping(value = "/exportTicketUrlReport", method = RequestMethod.GET)
    public void exportTicketUrlReport(HttpServletRequest request, HttpServletResponse response,
            TicketUrlDto param) {
        if (null == param) {
            param = new TicketUrlDto();
        }
        List<TicketUrlVo> list = null;
        User user = getUser(request,response);

        if (StringUtils.isNotBlank(UserRoleCodeUtil.isSale(user))){
            param.setSale(user.getUsername());
        }
        if (StringUtils.isNotBlank(UserRoleCodeUtil.isAe(user))){
            param.setAeCode(user.getUsername());
        }
        try {
            if (StringUtils.isNotBlank(UserRoleCodeUtil.isAe(user)) && StringUtils.isNotBlank(param.getAeCode())
                    && !param.getAeCode().equals(user.getUsername())){
                list = new ArrayList<TicketUrlVo>();
            }else {
                list = ticketWarnConfigService.getTicketUrlWarnList(param);
            }
        } catch (Exception e) {
            LOGGER.error("导出广告落地页到达率报警数据失败" + e.getMessage(), e);
            list = new ArrayList<TicketUrlVo>();
        }
        //导出数据
        ExcelUtil.exportExcel(list, null, "广告落地页到达率数据", TicketUrlVo.class, "广告落地页到达率.xls", response);
    }
    
    @RequestMapping(value = "/ticketUrlWarnCount", method = RequestMethod.GET)
    public ResultModel<Long> getTicketUrlWarnCount(HttpServletRequest request, TicketUrlDto param) {
        ResultModel<Long> resultModel = new ResultModel<Long>();
        if (null == param) {
            param = new TicketUrlDto();
        }
        Long count = 0L;
        try {
            //查询广告券落地页报警记录数
            count = ticketWarnConfigService.getTicketUrlWarnCount(param);
        } catch (Exception e) {
            LOGGER.error("查询广告券落地页到达率报警记录数失败" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        resultModel.setReturnValue(count);
        return resultModel;
    }
    
}
