package com.bxm.adsmanager.monitor.controller.warn;

import com.bxm.adsmanager.integration.datapark.service.DataparkAlarmIntegration;
import com.bxm.adsmanager.model.dao.monitor.AlarmConfig;
import com.bxm.adsmanager.service.monitor.AlarmConfigService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by wuwenquan on 2018/12/4.
 */
//报警系统参数配置
@RestController
@RequestMapping("/alarm")
public class AlarmConfigController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmConfigController.class);

    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private DataparkAlarmIntegration dataparkAlarmIntegration;
    @Autowired
    private AlarmConfigService alarmConfigService;

    //新增报警配置
    @RequestMapping(value = "/addConfig", method = RequestMethod.POST)
    public ResultModel addConfig(HttpServletRequest request, AlarmConfig alarmConfig) {

        ResultModel resultModel = new ResultModel();
        try {
            alarmConfigService.addConfig(alarmConfig);
        } catch (Exception e) {
            LOGGER.error("新增报警配置出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("新增报警配置出错");
        }
        return resultModel;
    }

    //更新报警配置
    @RequestMapping(value = "/updateConfig", method = RequestMethod.POST)
    public ResultModel updateConfig(HttpServletRequest request, AlarmConfig alarmConfig) {
        ResultModel resultModel = new ResultModel();
        try {
            alarmConfigService.updateConfig(alarmConfig);
        } catch (Exception e) {
            LOGGER.error("更新报警配置出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("更新报警配置出错");
        }
        return resultModel;
    }

    //获取报警配置
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ResultModel findAll(HttpServletRequest request, Byte dimension, Long alarmPlanId) {
        ResultModel resultModel = new ResultModel();
        try {
            List<AlarmConfig> list = alarmConfigService.findAll(dimension, alarmPlanId);
            resultModel.setReturnValue(list);
        } catch (Exception e) {
            LOGGER.error("获取报警配置出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("获取报警配置出错");
        }
        return resultModel;
    }
}
