package com.bxm.adsmanager.monitor.controller.warn;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.ro.AutoAlarmEditRo;
import com.bxm.adsmanager.model.ro.AutoAlarmRo;
import com.bxm.adsmanager.model.vo.AutoAlarmVo;
import com.bxm.adsmanager.monitor.controller.base.BaseController;
import com.bxm.adsmanager.service.alarm.AutoAlarmService;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author yirenjie
 * createDate:  2018/12/4
 */
@RestController
@RequestMapping("/autoAlarm")
@Slf4j
public class AutoAlarmController extends BaseController {

    @Resource
    private AutoAlarmService autoAlarmService;

    @RequestMapping("/queryList")
    public ResultModel<PageInfo<AutoAlarmVo>> queryList(HttpServletRequest request, HttpServletResponse response,
                                                        AutoAlarmRo autoAlarmRo) {
        ResultModel<PageInfo<AutoAlarmVo>> resultModel = new ResultModel<>();
        User user = getUser(request, response);
        List<String> roleCodes = user.getRoleCodes();
        if (!roleCodes.contains(RoleEnum.CHAN_PIN_LEADER.getCode()) && !roleCodes.contains(RoleEnum.MJLEADER.getCode())) {
            // 普通媒介只能查看自己的
            autoAlarmRo.setUsername(user.getUsername());
        }
        resultModel.setReturnValue(autoAlarmService.queryList(autoAlarmRo, user.getUsername()));
        return resultModel;
    }

    @RequestMapping("/modify")
    public ResultModel modify(HttpServletRequest request, HttpServletResponse response,
                              AutoAlarmEditRo autoAlarmEditRo) {
        ResultModel resultModel = new ResultModel();
        User user = getUser(request, response);
        resultModel.setSuccessed(autoAlarmService.modify(autoAlarmEditRo, user));
        return resultModel;
    }

    @RequestMapping("/batchModify")
    public ResultModel batchModify(HttpServletRequest request, HttpServletResponse response,
                                   AutoAlarmEditRo autoAlarmEditRo) {
        ResultModel resultModel = new ResultModel();
        User user = getUser(request, response);
        resultModel.setSuccessed(autoAlarmService.batchModify(autoAlarmEditRo, user));
        return resultModel;
    }

    @RequestMapping("/read")
    public ResultModel read(HttpServletRequest request, HttpServletResponse response,
                            Long id) {
        ResultModel resultModel = new ResultModel();
        User user = getUser(request, response);
        autoAlarmService.read(id, user.getUsername());
        return resultModel;
    }

}
