package com.bxm.adsmanager.monitor.controller.warn;


import com.bxm.adsmanager.integration.datapark.service.DataparkTicketPullerIntegration;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.monitor.controller.base.BaseController;
import com.bxm.adsmanager.service.adprofit.AdProfitMediaPositionService;
import com.bxm.adsmanager.service.datapark.DataparkTicketService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.SendTicketDetailDto;
import com.bxm.datapark.facade.ticket.model.dto.SendTicketDto;
import com.bxm.datapark.facade.ticket.model.vo.SendTicketDetailVo;
import com.bxm.datapark.facade.ticket.model.vo.SendTicketVo;
import com.bxm.util.dto.ResultModel;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * Created by wuwenquan on 2018/8/22.
 */
@RestController
@RequestMapping("/report")
public class SendTicketController extends BaseController{

    private static final Logger LOGGER = LoggerFactory.getLogger(SendTicketController.class);

    @Autowired
    private DataparkTicketPullerIntegration dataparkTicketPullerIntegration;
    @Autowired
    private DataparkTicketService dataparkTicketService;
    @Autowired
    private AdProfitMediaPositionService  adProfitMediaPositionService;


    @RequestMapping(value = "/sendticket/compare", method = RequestMethod.GET)
    public ResultModel<Page<SendTicketVo>> getTicketCompare(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse,  SendTicketDto sendTicketDto) {
        ResultModel<Page<SendTicketVo>> rs = new ResultModel<>();
        try {
            User user = getUser(httpServletRequest, httpServletResponse);
            //媒介过滤
            List<String> onlyAppkeys = null;
            //如果用户只为普通媒介角色CODE 则加上限制
            if (user.getRoleCodes() != null && !user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) &&
                    user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
                onlyAppkeys = adProfitMediaPositionService.findOnlyAppkeys(user.getUsername());
                if (CollectionUtils.isEmpty(onlyAppkeys)){
                    rs.setReturnValue(new Page<SendTicketVo>());
                    return rs;
                }
                sendTicketDto.setAppkeys(onlyAppkeys);
                rs=dataparkTicketPullerIntegration.getTicketCompare(sendTicketDto);
            }else {
                //如果用户是媒介经理或者其他
                rs=dataparkTicketPullerIntegration.getTicketCompare(sendTicketDto);
            }
        //封装发券对比外层媒体广告位信息
       dataparkTicketService.pullSendTicket(rs);
      }catch (Exception e){
          LOGGER.error("查询发券波动错误"+e.getMessage(), e);
          return ResultModelFactory.FAIL500("查询发券波动错误");
      }
        return rs;
    }

    @RequestMapping(value = "/sendticket/compareticket", method = RequestMethod.GET)
    public ResultModel<Page<SendTicketDetailVo>> getTicketCompareDetail(SendTicketDetailDto sendTicketDetailDto){
        ResultModel<Page<SendTicketDetailVo>> rs = new ResultModel<>();
        try {
            rs  = dataparkTicketPullerIntegration.getTicketCompareDetail(sendTicketDetailDto);
            dataparkTicketService.pullSendTicketDetail(rs);
        }catch (Exception e){
            LOGGER.error("查询波动组成错误"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("查询波动组成错误");
        }

        return rs;
    }
}
