package com.bxm.adsmanager.monitor.controller.warn;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.monitor.WarnConfig;
import com.bxm.adsmanager.model.dto.monitor.WarnConfigDto;
import com.bxm.adsmanager.service.monitor.WarnConfigService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
* @Title:WarnConfigController.java
* @Package:com.bxm.adsmanager.monitor.controller.warn
* @Description: 全局预警配置类
* @date:2018年8月8日 下午3:00:39
 */
@RequestMapping("/monitor")
@RestController
public class WarnConfigController {

	private static final Logger LOGGER = LoggerFactory.getLogger(WarnConfigController.class);
    
	@Autowired
	private WarnConfigService warnConfigService;
	
	@RequestMapping(value = "/findWarnConfig", method = RequestMethod.GET)
	public ResultModel<WarnConfig> findWarnConfigByConfigKey(HttpServletRequest request,@RequestParam(name = "saveFlag",required = true) String configKey) {
		ResultModel<WarnConfig> rs = new ResultModel<WarnConfig>();
		WarnConfig warnConfig = null;
		try {
		    warnConfig = warnConfigService.selectByConfigKey(configKey);
		}catch (Exception e){
			LOGGER.error("阈值配置信息查询错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("阀值配置信息查询错误");
		}
		rs.setReturnValue(warnConfig);
		return  rs;
	}
	
    @RequestMapping(value = "/addWarnConfig",method = RequestMethod.POST)
    public ResultModel<Boolean> addWarnConfig(HttpServletRequest request ,
            @RequestParam(name = "data",required = true) String data,
            @RequestParam(name = "saveFlag",required = true) String saveFlag,
            @RequestParam(name = "value",required = true) String value){
        ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
        WarnConfigDto warnConfigDto = new WarnConfigDto();
        warnConfigDto.setSaveFlag(saveFlag);
        warnConfigDto.setValue(value);
            try {
                //ID集合
                List<Object> parseArray = JSON.parseArray(data, Object.class);
                if(!CollectionUtils.isEmpty(parseArray)){
                    warnConfigDto.setDataConfigList(parseArray);
                }
                warnConfigService.addWarnConfig(warnConfigDto);
           } catch (Exception e) {
               LOGGER.error("新增预警阈值配置信息出错"+ e.getMessage(), e);
               return ResultModelFactory.FAIL500("新增预警阈值配置信息出错");
           }
        return resultModel;
    }
	
    @RequestMapping(value = "/updateWarnConfig",method = RequestMethod.POST)
    public ResultModel<Boolean> updateWarnConfig(HttpServletRequest request ,
            @RequestParam(name = "data",required = true) String data,
            @RequestParam(name = "saveFlag",required = true) String saveFlag,
            @RequestParam(name = "value",required = true) String value){
        ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
        WarnConfigDto warnConfigDto = new WarnConfigDto();
        warnConfigDto.setSaveFlag(saveFlag);
        warnConfigDto.setValue(value);
            try {
                //ID集合
                List<Object> parseArray = JSON.parseArray(data, Object.class);
                if(!CollectionUtils.isEmpty(parseArray)){
                    warnConfigDto.setDataConfigList(parseArray);
                }
                warnConfigService.updateByConfigKey(warnConfigDto);
           } catch (Exception e) {
               LOGGER.error("修改预警阈值配置信息出错"+ e.getMessage(), e);
               return ResultModelFactory.FAIL500("修改预警阈值配置信息出错");
           }
        return resultModel;
    }
	
}
