/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsmanager.monitor.interceptor;

import com.bxm.acl.facade.AclAuthInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * <h3>权限拦截</h3>
 * <p></p>
 * @author hcmony
 * @since V1.0.0, 2017/12/15 18:13
 */
@Configuration
public class InterceptorConfigurer extends WebMvcConfigurerAdapter {

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        // 多个拦截器组成一个拦截器链
       //  addPathPatterns 用于添加拦截规则   adsmanager是prod访问，没有拦截
        registry.addInterceptor(aclAuthInterceptor()).addPathPatterns("/*/**")
                .excludePathPatterns("/notLogin")
               .excludePathPatterns("/noAuth")
                .excludePathPatterns("/common/**")
                .excludePathPatterns("/error/**")
               .excludePathPatterns("/17ce/**");
    }

    @Bean
    public AclAuthInterceptor aclAuthInterceptor() {
        return new AclAuthInterceptor(7);
    }
}
