///*
// * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
// * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
// * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
// */
//package com.bxm.adsmanager.monitor.redis;
//
//import com.bxm.util.SerializableUtil;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.scheduling.annotation.Async;
//import org.springframework.stereotype.Component;
//import redis.clients.jedis.Jedis;
//import redis.clients.jedis.JedisPool;
//
//import java.util.HashMap;
//import java.util.HashSet;
//import java.util.Map;
//import java.util.Set;
//
///**
// * <h3>Shenjue.java基本描述</h3>
// * <p></p>
// *
// * @author hcmony
// * @since V1.0.0, 2018/03/16 11:46
// */
//@Component
//public class RedisClient {
//
//    @Autowired
//    private JedisPool jedisPool;
//
//    /**
//     * 方法描述:设置对象
//     * 
//     * @param dbIndex redis数据库
//     * @param key
//     * @param value
//     * @throws Exception
//     * @author leon 2017年5月3日 上午11:58:35
//     */
//    public void set(Integer dbIndex, String key, String value) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            jedis.set(key, value);
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:设置key过期时间
//     * 
//     * @author leon 2017年8月28日 上午10:30:34
//     * @param dbIndex redis数据库
//     * @param key
//     * @param seconds
//     */
//    public void setExpire(Integer dbIndex, String key, Integer seconds) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            if (seconds != null) {
//                jedis.expire(key, seconds);
//            }
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:Redis INCR命令用于将键的整数值递增1。如果键不存在，则在执行操作之前将其设置为0。 如果键包含错误类型的值或包含无法表示为整数的字符串，则会返回错误。此操作限于64位有符号整数
//     * 
//     * @author leon 2017年7月18日 下午2:28:42
//     * @param dbIndex redis数据库
//     * @param key
//     */
//    public void incr(Integer dbIndex, String key) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            jedis.incr(key);
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:查找所有匹配给定的模式的键
//     * 
//     * @author leon 2017年7月18日 下午2:32:52
//     * @param dbIndex redis数据库
//     * @param redisKey pattern 的表达式,*表示多个，？表示一个
//     * @return
//     */
//    public Map<String, Object> getByKeys(Integer dbIndex, String redisKey) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            Set<String> keys = jedis.keys(redisKey);
//            Map<String, Object> map = new HashMap<>();
//            if (keys != null && keys.size() > 0) {
//                for (String key : keys) {
//                    map.put(key, jedis.get(key));
//                }
//            }
//            return map;
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:删除所有匹配给定的模式的键
//     * 
//     * @author leon 2017年7月18日 下午2:32:52
//     * @param dbIndex redis数据库
//     * @param redisKey pattern 的表达式,*表示多个，？表示一个
//     * @return
//     */
//    public void delByKeys(Integer dbIndex, String redisKey) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            Set<String> keys = jedis.keys(redisKey);
//            if (keys != null && keys.size() > 0) {
//                for (String key : keys) {
//                    jedis.del(key);
//                }
//            }
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:设置key的有效期
//     * 
//     * @author leon 2017年7月18日 下午2:30:27
//     * @param dbIndex redis数据库
//     * @param key
//     * @param seconds
//     */
//    public void expire(Integer dbIndex, String key, int seconds) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            jedis.expire(key, seconds);
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:设置对象
//     * 
//     * @param dbIndex redis数据库
//     * @param key 键
//     * @param seconds 缓存秒数
//     * @param value 值
//     * @throws Exception
//     * @author leon 2017年5月3日 下午2:40:32
//     */
//    public void set(Integer dbIndex, String key, Integer seconds, String value) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            if (seconds == null) {
//                jedis.set(key, value);
//            } else {
//                jedis.setex(key, seconds, value);
//            }
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:获取对象
//     * 
//     * @param dbIndex redis数据库
//     * @param key 键
//     * @return
//     * @throws Exception
//     * @author leon 2017年5月3日 上午11:58:47
//     */
//    public String get(Integer dbIndex, String key) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            return jedis.get(key);
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:设置对象
//     * 
//     * @param dbIndex redis数据库
//     * @param key
//     * @param value
//     * @throws Exception
//     * @author leon 2017年5月3日 上午11:58:35
//     */
//    public void setObject(Integer dbIndex, String key, Object value) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            jedis.set(key.getBytes(), SerializableUtil.toByteArray(value));
//        } finally {
//            // 返还到连接池
//
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:设置对象
//     * 
//     * @param dbIndex redis数据库
//     * @param key 键
//     * @param seconds 缓存秒数
//     * @param value 值
//     * @throws Exception
//     * @author leon 2017年5月3日 下午2:40:32
//     */
//    public void setObject(Integer dbIndex, String key, int seconds, Object value) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            jedis.setex(key.getBytes(), seconds, SerializableUtil.toByteArray(value));
//        } finally {
//            // 返还到连接池
//
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:删除元素
//     * 
//     * @param dbIndex redis数据库
//     * @author leon 2017年6月10日 下午5:51:04
//     * @param key
//     * @throws Exception
//     */
//    @Async
//    public boolean delObject(Integer dbIndex, String key) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            if (jedis.exists(key)) {
//                return jedis.del(key) > 0;
//            }
//            return true;
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:redis HyperLogLog输入元素
//     * 
//     * @author leon 2017年8月28日 下午2:39:17
//     * @param dbIndex redis数据库
//     * @param key
//     * @param value
//     */
//    public void pfadd(Integer dbIndex, String key, String value) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            jedis.pfadd(key, value);
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:统计key在HyperLogLog中的基数 </br>
//     * 基数：集合中不同元素的数量。比如 {‘apple’, ‘banana’, ‘cherry’, ‘banana’, ‘apple’} 的基数就是 3</br>
//     * 估算值：算法给出的基数并不是精确的，可能会比实际稍微多一些或者稍微少一些，但会控制在合理的范围之内
//     * 
//     * @author leon 2017年8月28日 下午2:40:16
//     * @param dbIndex redis数据库
//     * @param key
//     * @return
//     */
//    public long pfcount(Integer dbIndex, String key) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            return jedis.pfcount(key);
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:模糊查询指定的键，返回键的集合
//     * 
//     * @author leon 2017年7月18日 下午2:32:52
//     * @param dbIndex redis数据库
//     * @param redisKey pattern 的表达式,*表示多个，？表示一个
//     * @return
//     */
//    public Set<String> getKeysByKeywords(Integer dbIndex, String redisKey) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            return jedis.keys(redisKey);
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 方法描述:查找所有匹配给定的模式的键并统计所有键的基数
//     * 
//     * @author leon 2017年8月28日 下午3:35:19
//     * @param dbIndex redis数据库
//     * @param redisKey
//     * @return
//     */
//    public Map<String, Object> getPfcountByKeys(Integer dbIndex, String redisKey) throws Exception {
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            Set<String> keys = jedis.keys(redisKey);
//            Map<String, Object> map = new HashMap<>();
//            if (keys != null && keys.size() > 0) {
//                for (String key : keys) {
//                    map.put(key, jedis.pfcount(key));
//                }
//            }
//            return map;
//        } finally {
//            // 返还到连接池
//            if (jedis != null) {
//                jedis.close();
//            }
//        }
//    }
//
//    /**
//     * 存入 set 集合
//     * @author 董朱旭
//     * @time 2017/11/22
//     * @CopyRight 杭州微财网络科技有限公司
//     * @param key
//     * @param value
//     * @param dbIndex
//     * @param seconds
//     * @return void
//     */
//    public void sAdd(String key,String value,Integer dbIndex,Long seconds){
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            jedis.sadd(key, value);
//            jedis.sadd(key,value,value,value);
//            if (seconds != null) {
//                jedis.expire(key, seconds.intValue());
//            }
//        } finally {
//            // 返还到连接池
//            jedis.close();
//        }
//    }
//    /**
//     * 获取 所有成员 set
//     * @author 董朱旭
//     * @time 2017/11/22
//     * @CopyRight 杭州微财网络科技有限公司
//     * @param key
//     * @param dbIndex
//     * @return java.util.Set<java.lang.String>
//     */
//    public Set<String> smembers(String key, Integer dbIndex) {
//        Jedis jedis = null;
//        Set<String> result = new HashSet<>();
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//
//            result = jedis.smembers(key);
//        } catch (Exception e) {
//            e.printStackTrace();
//        } finally {
//            jedis.close();
//        }
//        return result;
//    }
//
//    /**
//     * 删除集合中元素
//     * @author 董朱旭
//     * @time 2017/11/22
//     * @CopyRight 杭州微财网络科技有限公司
//     * @param key
//     * @param value
//     * @param dbIndex
//     * @return void
//     */
//    public void srem(String key,String value,Integer dbIndex){
//        Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            jedis.srem(key, value);
//        } finally {
//            // 返还到连接池
//            jedis.close();
//        }
//    }
//    
//    /**
//	 * 获取哈希里面的内容
//	 * @author 董朱旭
//	 * @time 2017/11/24
//	 * @CopyRight 杭州微财网络科技有限公司
//	 * @param key
//	 * @param dbIndex
//	 * @return java.lang.String
//	 */
//	public String hGet(String key,String field,Integer dbIndex){
//		Jedis jedis = null;
//		try {
//			 jedis = jedisPool.getResource();
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			return  jedis.hget(key,field);
//		} finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//	
//	/**
//	 * 删除哈希结构里面的某个域
//	 * @author 董朱旭
//	 * @time 2017/12/13
//	 * @CopyRight 杭州微财网络科技有限公司
//	 * @param key
//	 * @param filed
//	 * @param value
//	 * @param dbIndex
//	 * @return void
//	 */
//	public void hset(String key,String filed,String value,Integer dbIndex, Long seconds){
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			//选择数据库
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//
//			jedis.hset(key,filed,value);
//			//若是有时间限制
//			if(seconds!=null){
//				jedis.expire(key.toString(), seconds.intValue());
//			}
//		}catch (Exception e){
//		}finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//	
//	public String getRedisWhitDB(String key, Integer dbIndex) {
//		Jedis jedis = null;
//		String result = null;
//		try {
//			jedis = jedisPool.getResource();
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//
//			result = jedis.get(key);
//		} catch (Exception e) {
//		} finally {
//			jedis.close();
//		}
//		return result;
//	}
//
//
//	public Long remove(String key, Integer dbIndex){
//        Jedis jedis = null;
//        Long result = null;
//        try {
//            jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//
//            result = jedis.del(key);
//        } catch (Exception e) {
//        } finally {
//            jedis.close();
//        }
//        return result;
//    }
//	
//}
