package com.bxm.adsmanager.monitor.websocket;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.dal.mapper.alarm.ext.AlarmRecordMapperExt;
import com.bxm.adsmanager.model.dao.alarm.AlarmRecord;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.AlarmStatistic;
import com.bxm.adsmanager.service.alarm.SocketSessionRegistry;
import com.bxm.adsmanager.service.alarm.impl.AlarmNotifyServiceImpl;
import com.google.common.collect.Lists;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.messaging.SessionConnectEvent;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * STOMP监听类
 * 用于session注册 以及key值获取
 */
@Service
public class STOMPConnectEventListener  implements ApplicationListener<SessionConnectEvent> {

    @Resource
    private SocketSessionRegistry webAgentSessionRegistry;

    @Resource
    private AlarmRecordMapperExt alarmRecordMapperExt;

    @Resource
    private AlarmNotifyServiceImpl alarmNotifyService;

    @Resource
    private SimpMessagingTemplate template;

    @Resource
    private ThreadPoolExecutor threadPoolExecutor;

    @Override
    public void onApplicationEvent(SessionConnectEvent event) {
        StompHeaderAccessor sha = StompHeaderAccessor.wrap(event.getMessage());
        //login get from browser
        String username = sha.getNativeHeader("username").get(0);
        String sessionId = sha.getSessionId();
        webAgentSessionRegistry.registerSessionId(username,sessionId);

        List<String> roleHeader = sha.getNativeHeader("roleCodes");
        List<String> roleCodes = Lists.newArrayList();
        if (roleHeader != null && !roleHeader.isEmpty()) {
            roleCodes = JSONObject.parseArray(roleHeader.get(0), String.class);
        }
        username = roleCodes.contains(RoleEnum.MJLEADER.getCode()) || roleCodes.contains(RoleEnum.CHAN_PIN_LEADER.getCode()) ? null : username;
        AlarmStatistic alarmStatistic = alarmRecordMapperExt.statisticAlarm(username);
        AlarmRecord alarmRecord = alarmRecordMapperExt.selectLatestUnprocessed(username);
        if (alarmRecord != null) {
            alarmStatistic.setLatestAlarm(alarmNotifyService.genAlarmDesc(alarmRecord));
        }

        threadPoolExecutor.execute(() -> {
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            template.convertAndSendToUser(sessionId, "/topic/alarm"
                    , JSONObject.toJSONString(alarmStatistic == null ? new AlarmStatistic() : alarmStatistic)
                    , AlarmNotifyServiceImpl.createHeaders(sessionId));
        });
    }
}
