/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.redis;

import com.bxm.util.SerializableUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class RedisClient {
    private static final String SUCCESS_STR = "OK";
    @Autowired
    @Qualifier(value="redisPoolFactory")
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Integer dbIndex, String key, String value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpire(Integer dbIndex, String key, Integer seconds) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incr(Integer dbIndex, String key) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.incr(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getByKeys(Integer dbIndex, String redisKey) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            Set keys = jedis.keys(redisKey);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    map.put(key, jedis.get(key));
                }
            }
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delByKeys(Integer dbIndex, String redisKey) throws Exception {
        try (Jedis jedis = null;){
            Set keys;
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            if ((keys = jedis.keys(redisKey)) != null && keys.size() > 0) {
                for (String key : keys) {
                    jedis.del(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(Integer dbIndex, String key, int seconds) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.expire(key, seconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Integer dbIndex, String key, Integer seconds, String value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            if (seconds == null) {
                jedis.set(key, value);
            } else {
                jedis.setex(key, seconds.intValue(), value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Integer dbIndex, String key) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            String string = jedis.get(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(Integer dbIndex, String key, Object value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.set(key.getBytes(), SerializableUtil.toByteArray((Object)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(Integer dbIndex, String key, int seconds, Object value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.setex(key.getBytes(), seconds, SerializableUtil.toByteArray((Object)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public boolean delObject(Integer dbIndex, String key) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            if (jedis.exists(key).booleanValue()) {
                boolean bl = jedis.del(key) > 0L;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pfadd(Integer dbIndex, String key, String value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.pfadd(key, new String[]{value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pfcount(Integer dbIndex, String key) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            long l = jedis.pfcount(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeysByKeywords(Integer dbIndex, String redisKey) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            Set set = jedis.keys(redisKey);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getPfcountByKeys(Integer dbIndex, String redisKey) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            Set keys = jedis.keys(redisKey);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    map.put(key, jedis.pfcount(key));
                }
            }
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sAdd(String key, String value, Integer dbIndex, Long seconds) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.sadd(key, new String[]{value});
            jedis.sadd(key, new String[]{value, value, value});
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smembers(String key, Integer dbIndex) {
        Set<String> result = new HashSet<String>();
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            result = jedis.smembers(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void srem(String key, String value, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.srem(key, new String[]{value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hGet(String key, String field, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            String string = jedis.hget(key, field);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hset(String key, String filed, String value, Integer dbIndex, Long seconds) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.hset(key, filed, value);
            if (seconds != null) {
                jedis.expire(key.toString(), seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedisWhitDB(String key, Integer dbIndex) {
        String result = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            result = jedis.get(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long remove(String key, Integer dbIndex) {
        Long result = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            result = jedis.del(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hdel(String key, String filed, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.hdel(key, new String[]{filed});
        }
    }

    public List<String> hmget(String key, String ... fields) {
        try (Jedis jedis = this.jedisPool.getResource();){
            List list = jedis.hmget(key, fields);
            return list;
        }
    }

    public boolean hmset(String key, Map<String, String> target) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = SUCCESS_STR.equals(jedis.hmset(key, target));
            return bl;
        }
    }

    public Map<String, String> hGetAll(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Map map = jedis.hgetAll(key);
            return map;
        }
    }
}

