/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.scheduler;

import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.facade.service.AppEntranceFacadeService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.zk.ZkClientHolder;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class PositionSynchronizingPushable
implements ApplicationListener<ApplicationReadyEvent>,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PositionSynchronizingPushable.class);
    private final ScheduledThreadPoolExecutor threadPool = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("pos-sync"));
    private final AppEntranceFacadeService appEntranceFacadeService;
    private final ProdPusherIntegration prodPusher;
    private final Fetcher fetcher;
    private final Updater updater;
    private final LeaderLatch leaderLatch;

    public PositionSynchronizingPushable(AppEntranceFacadeService appEntranceFacadeService, ProdPusherIntegration prodPusher, Fetcher fetcher, Updater updater, ZkClientHolder zkClientHolder) {
        this.appEntranceFacadeService = appEntranceFacadeService;
        this.prodPusher = prodPusher;
        this.fetcher = fetcher;
        this.updater = updater;
        this.leaderLatch = new LeaderLatch(zkClientHolder.get(), "/adsmanager/position_sync_execution_leader");
    }

    public void destroy() {
        try {
            this.leaderLatch.close();
        }
        catch (Exception e) {
            log.error("shutdown: ", (Throwable)e);
        }
        this.threadPool.shutdownNow();
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.leaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                PositionSynchronizingPushable.this.startSyncData();
            }

            public void notLeader() {
            }
        });
        try {
            this.leaderLatch.start();
        }
        catch (Exception e) {
            log.error("start: ", (Throwable)e);
            System.exit(-1);
        }
    }

    private void startSyncData() {
        this.threadPool.scheduleWithFixedDelay(() -> {
            try {
                if (log.isInfoEnabled()) {
                    log.info("Starting sync positions.");
                }
                long start = System.currentTimeMillis();
                QueryAppEntranceParamDTO query = new QueryAppEntranceParamDTO();
                query.setPageSize(Integer.valueOf(500));
                query.setPageNum(Integer.valueOf(1));
                query.setSortField("ae.modified_time");
                query.setOrderType("asc");
                String lastSyncTime = this.getLastSyncTime();
                if (StringUtils.isNotBlank((CharSequence)lastSyncTime)) {
                    query.setModifyTime(LocalDateTime.parse(lastSyncTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                }
                long pages = 0L;
                do {
                    List list;
                    long oneStart = System.currentTimeMillis();
                    ResultModel pageList = this.appEntranceFacadeService.pageList(query);
                    if (!pageList.isSuccessed()) continue;
                    PageInfo pageInfo = (PageInfo)pageList.getReturnValue();
                    if (Objects.isNull(pageInfo) || CollectionUtils.isEmpty((Collection)(list = pageInfo.getList()))) break;
                    pages = pageInfo.getPages();
                    String now = null;
                    for (AppEntranceAdRO position : list) {
                        if (log.isDebugEnabled()) {
                            log.debug("Post position data: {}", (Object)JsonHelper.convert((Object)position));
                        }
                        byte[] data = JsonHelper.convert2bytes((Object)position);
                        this.prodPusher.pushToProd(ProdServiceNameEnum.MEDIA_POSITION.getServiceName(), new HashMap(), data);
                        now = DateHelper.format((Date)position.getModifiedTime(), (String)"yyyy-MM-dd HH:mm:ss");
                    }
                    if (log.isInfoEnabled()) {
                        BigDecimal cost = BigDecimal.valueOf(System.currentTimeMillis() - start).divide(BigDecimal.valueOf(1000L), 2, 4);
                        BigDecimal oneCost = BigDecimal.valueOf(System.currentTimeMillis() - oneStart).divide(BigDecimal.valueOf(1000L), 2, 4);
                        int size = list.size();
                        log.info("Synchronizing position: {}/{} (page) | Offset {} | pageSize {} | cost {} sec | Total cost {} sec", new Object[]{query.getPageNum(), pages, now, size, oneCost, cost});
                    }
                    query.setPageNum(Integer.valueOf(query.getPageNum() + 1));
                    this.setLastSyncTime(now);
                } while ((long)query.getPageNum().intValue() <= pages);
            }
            catch (Exception e) {
                log.error("schedule: ", (Throwable)e);
            }
        }, 0L, 5L, TimeUnit.MINUTES);
    }

    private void setLastSyncTime(String now) {
        this.updater.update(PositionSynchronizingPushable.stringLastSyncTime(), (Object)now);
    }

    private String getLastSyncTime() {
        return (String)this.fetcher.fetch(PositionSynchronizingPushable.stringLastSyncTime(), String.class);
    }

    private static KeyGenerator stringLastSyncTime() {
        return () -> KeyBuilder.build((Object[])new Object[]{"position", "sync", "last", "time"});
    }
}

