/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.abtest.impl;

import com.bxm.adsmanager.dal.mapper.abtest.AbtestDictionariesMapper;
import com.bxm.adsmanager.dal.mapper.abtest.AbtestSceneMapper;
import com.bxm.adsmanager.dal.mapper.abtest.AbtestSceneTestMapper;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.abtest.AbtestDictionaries;
import com.bxm.adsmanager.model.dao.abtest.AbtestScene;
import com.bxm.adsmanager.model.test.AbTestAlgorithmFlow;
import com.bxm.adsmanager.model.vo.abtest.AbTestSceneVo;
import com.bxm.adsmanager.service.abtest.AbTestSceneService;
import com.bxm.warcar.cache.Updater;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AbTestSceneServiceImpl
implements AbTestSceneService {
    @Resource
    AbtestSceneMapper abtestBusinessSceneMapper;
    @Autowired
    AbtestDictionariesMapper abtestDictionariesMapper;
    @Resource
    AbtestSceneTestMapper abtestSceneTestMapper;
    @Autowired
    @Qualifier(value="jedisUpdaterForABtest")
    private Updater updater;

    @Override
    public void add(String senceName, String defaultAlgorithmCode, String userName) throws Exception {
        AbtestScene oldAbtestBusinessScene = this.abtestBusinessSceneMapper.selectByPrimaryParams(senceName, null);
        if (oldAbtestBusinessScene != null) {
            throw new Exception("\u8be5\u573a\u666f\u540d\u79f0\u4ee5\u53ca\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540d\u79f0");
        }
        AbtestDictionaries abtestDictionaries = this.abtestDictionariesMapper.selectByPrimaryKey(Integer.valueOf(defaultAlgorithmCode));
        if (abtestDictionaries == null) {
            throw new Exception("\u8be5\u7b97\u6cd5code\u6ca1\u6709\u5bf9\u5e94\u7684\u7b97\u6cd5\u540d\u79f0\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7b97\u6cd5code");
        }
        AbtestScene abtestBusinessScene = new AbtestScene();
        abtestBusinessScene.setSceneName(senceName);
        abtestBusinessScene.setDefaultAlgorithmCode(defaultAlgorithmCode);
        abtestBusinessScene.setCreateUser(userName);
        abtestBusinessScene.setCreateTime(new Date());
        this.abtestBusinessSceneMapper.insert(abtestBusinessScene);
        AbtestScene finalAbtestBusinessScene = this.abtestBusinessSceneMapper.selectByPrimaryParams(senceName, null);
        this.saveRedis(finalAbtestBusinessScene.getSceneCode().toString(), finalAbtestBusinessScene.getDefaultAlgorithmCode(), abtestDictionaries.getAlgorithmName());
    }

    public void saveRedis(String sceneCode, String defaultCode, String defaultName) {
        AbTestAlgorithmFlow abTestAlgorithmFlow = new AbTestAlgorithmFlow();
        abTestAlgorithmFlow.setAlgorithmCode(defaultCode);
        abTestAlgorithmFlow.setStart(Integer.valueOf(0));
        abTestAlgorithmFlow.setEnd(Integer.valueOf(99));
        abTestAlgorithmFlow.setAlgorithmName(defaultName);
        this.updater.hupdateWithSelector(RedisKeys.keyGeneratorBySenceCode((String)sceneCode), "default", (Object)abTestAlgorithmFlow, 2);
    }

    @Override
    public void update(String senceName, String sceneCode, String defaultAlgorithmCode, String userName) throws Exception {
        AbtestScene seachAbtestBusinessScene = this.abtestBusinessSceneMapper.selectByPrimaryParams(null, sceneCode);
        if (seachAbtestBusinessScene == null) {
            throw new Exception("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        AbtestScene oldAbtestBusinessScene = this.abtestBusinessSceneMapper.selectByPrimaryParams(senceName, null);
        if (oldAbtestBusinessScene != null && !StringUtils.endsWithIgnoreCase((String)oldAbtestBusinessScene.getSceneCode().toString(), (String)sceneCode)) {
            throw new Exception("\u8be5\u573a\u666f\u540d\u79f0\u4ee5\u53ca\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u4e3a\u522b\u7684\u540d\u79f0");
        }
        AbtestDictionaries abtestDictionaries = this.abtestDictionariesMapper.selectByPrimaryKey(Integer.valueOf(defaultAlgorithmCode));
        if (abtestDictionaries == null) {
            throw new Exception("\u8be5\u7b97\u6cd5code\u6ca1\u6709\u5bf9\u5e94\u7684\u7b97\u6cd5\u540d\u79f0\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7b97\u6cd5code");
        }
        AbtestScene abtestBusinessScene = new AbtestScene();
        abtestBusinessScene.setSceneName(senceName);
        abtestBusinessScene.setDefaultAlgorithmCode(defaultAlgorithmCode);
        abtestBusinessScene.setModifyUser(userName);
        abtestBusinessScene.setModifyTime(new Date());
        abtestBusinessScene.setSceneCode(Integer.valueOf(sceneCode));
        this.abtestBusinessSceneMapper.updateByPrimaryKeySelective(abtestBusinessScene);
        this.saveRedis(sceneCode, defaultAlgorithmCode, abtestDictionaries.getAlgorithmName());
    }

    @Override
    public PageInfo<AbTestSceneVo> getPageList(String sceneKeywords, Integer pageNum, Integer pageSize) throws Exception {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.abtestBusinessSceneMapper.selectByParams(sceneKeywords);
        for (AbTestSceneVo abTestSceneVo : list) {
            int open = this.abtestSceneTestMapper.selectCountByStatusAndSceneCode(abTestSceneVo.getSceneCode(), Integer.valueOf(1));
            int all = this.abtestSceneTestMapper.selectCountByStatusAndSceneCode(abTestSceneVo.getSceneCode(), null);
            abTestSceneVo.setSceneTestCount(open + "/" + all);
        }
        return new PageInfo(list);
    }

    @Override
    public List<AbTestSceneVo> getList(String sceneKeywords) throws Exception {
        return this.abtestBusinessSceneMapper.selectByParams(sceneKeywords);
    }
}

