/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adarpu.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdDomainArpuMapper;
import com.bxm.adsmanager.model.dao.adarpu.AdDomainArpu;
import com.bxm.adsmanager.model.dto.adarpu.AdDoMainArpuDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adarpu.AdDomainArpuVo;
import com.bxm.adsmanager.redis.RedisClient;
import com.bxm.adsmanager.service.adarpu.AdArpuService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdArpuServiceImpl
implements AdArpuService {
    private static final String CPA_DEFAULLT_ARPU = "0.02";
    private static final String CPC_DEFAULLT_ARPU = "0.1";
    private static final String OCPC_DEFAULLT_ARPU = "0.1";
    private static final String AD_WEIGHT_ARPU_DOMAIN = "AD:WEIGHT:ARPU:DOMAIN:";
    public static final int POSTIONARPUDB = 14;
    private static final String SETTLE_TYPE_CPCARPU = "1";
    private static final String SETTLE_TYPE_CPAARPU = "2";
    private static final String SETTLE_TYPE_OCPCARPU = "3";
    @Autowired
    AdDomainArpuMapper adDomainArpuMapper;
    @Autowired
    private RedisClient redisClient;

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.adDomainArpuMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int insert(AdDoMainArpuDto recordDto) {
        AdDomainArpu adDomainArpu = new AdDomainArpu();
        BeanUtils.copyProperties((Object)recordDto, (Object)adDomainArpu);
        this.adDomainArpuMapper.insert(adDomainArpu);
        this.syncData2Redis(adDomainArpu);
        return 1;
    }

    @Override
    public AdDomainArpuVo selectByPrimaryKey(long id) {
        AdDomainArpuVo adDomainArpuVo = new AdDomainArpuVo();
        AdDomainArpu adDomainArpu = this.adDomainArpuMapper.selectByPrimaryKey(Long.valueOf(id));
        if (adDomainArpu == null) {
            return adDomainArpuVo;
        }
        BeanUtils.copyProperties((Object)adDomainArpu, (Object)adDomainArpuVo);
        return adDomainArpuVo;
    }

    @Override
    public int updateByPrimaryKey(AdDoMainArpuDto recordDto) {
        AdDomainArpu adDomainArpu = new AdDomainArpu();
        BeanUtils.copyProperties((Object)recordDto, (Object)adDomainArpu);
        this.adDomainArpuMapper.updateByPrimaryKey(adDomainArpu);
        this.syncData2Redis(adDomainArpu);
        return 1;
    }

    private void syncData2Redis(AdDomainArpu adDomainArpu) {
        this.pushData2Redis(adDomainArpu.getTypeCode(), SETTLE_TYPE_CPCARPU, adDomainArpu.getCpcArpu());
        this.pushData2Redis(adDomainArpu.getTypeCode(), SETTLE_TYPE_CPAARPU, adDomainArpu.getCpaArpu());
        this.pushData2Redis(adDomainArpu.getTypeCode(), SETTLE_TYPE_OCPCARPU, adDomainArpu.getOcpcArpu());
    }

    @Override
    public Pagination findArpuPage(AdDoMainArpuDto adDoMainArpuDto) {
        Pagination pagination = new Pagination();
        if (adDoMainArpuDto == null) {
            adDoMainArpuDto = new AdDoMainArpuDto();
        }
        List adDomainArpuList = this.adDomainArpuMapper.findArpuPage(adDoMainArpuDto);
        List<AdDomainArpu> nullIdAdDomainArpuList = adDomainArpuList.stream().filter(adDomainArpuVo -> adDomainArpuVo.getId() == null).collect(Collectors.toList());
        this.dealNullIdList(nullIdAdDomainArpuList);
        List<AdDomainArpu> haveIdAdDomainArpuList = adDomainArpuList.stream().filter(adDomainArpuVo -> adDomainArpuVo.getId() != null).collect(Collectors.toList());
        int count = this.adDomainArpuMapper.getTotalCount(adDoMainArpuDto);
        haveIdAdDomainArpuList.addAll(nullIdAdDomainArpuList);
        List<AdDomainArpuVo> adDomainArpuVoList = this.adDomainArpu2adDomainArpuVo(haveIdAdDomainArpuList);
        this.adDomainArpu2adDomainArpuVo(haveIdAdDomainArpuList);
        pagination.setPageSize(adDoMainArpuDto.getPageSize());
        pagination.setPageNo(adDoMainArpuDto.getPageNum());
        pagination.setList(adDomainArpuVoList);
        pagination.setTotalCount(count);
        return pagination;
    }

    private List<AdDomainArpuVo> adDomainArpu2adDomainArpuVo(List<AdDomainArpu> haveIdAdDomainArpuList) {
        ArrayList<AdDomainArpuVo> result = new ArrayList<AdDomainArpuVo>();
        haveIdAdDomainArpuList.forEach(adDomainArpu -> {
            AdDomainArpuVo adDomainArpuVo = new AdDomainArpuVo();
            BeanUtils.copyProperties((Object)adDomainArpu, (Object)adDomainArpuVo);
            result.add(adDomainArpuVo);
        });
        return result;
    }

    private void dealNullIdList(List<AdDomainArpu> nullIdAdDomainArpuList) {
        for (AdDomainArpu adDomainArpu : nullIdAdDomainArpuList) {
            adDomainArpu.setCpaArpu(CPA_DEFAULLT_ARPU);
            adDomainArpu.setCpcArpu("0.1");
            adDomainArpu.setOcpcArpu("0.1");
            adDomainArpu.setTypeCode(adDomainArpu.getTypeCodetstype());
            this.adDomainArpuMapper.insert(adDomainArpu);
            this.syncData2Redis(adDomainArpu);
        }
    }

    private void pushData2Redis(String key, String settleType, String arpu) {
        this.redisClient.hset(AD_WEIGHT_ARPU_DOMAIN + key, settleType, arpu, 14, null);
    }
}

