/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adflowpackage.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdFlowPackageMapper;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdTicketFlowPackageMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPositonGroupIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adflowpackage.AdFlowPackage;
import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageConf;
import com.bxm.adsmanager.model.dto.AdFlowPackageNewDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.vo.AdFlowPackageNewVo;
import com.bxm.adsmanager.model.vo.PackagePushVo;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowNewService;
import com.bxm.commons.currency.Money;
import com.bxm.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AdTicketFlowNewServiceImpl
implements AdTicketFlowNewService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketFlowNewServiceImpl.class);
    @Autowired
    private AdTicketFlowPackageMapper adTicketFlowPackageMapper;
    @Autowired
    private ProdPositonGroupIntegration prodPositonGroupIntegration;
    @Autowired
    private AdFlowPackageMapper adFlowPackageMapper;
    @Autowired
    private ProdPusherIntegration prodPusher;

    @Override
    public List<AdFlowPackageNewVo> findFlowPageIdByTicket(Long ticketId) {
        ArrayList<Long> packageIds = new ArrayList<Long>();
        List<AdFlowPackageNewVo> rs = new ArrayList<AdFlowPackageNewVo>();
        if (ticketId == null) {
            return rs;
        }
        List adFlows = this.adTicketFlowPackageMapper.findByAdFlowByConditionTwo(ticketId, Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)adFlows)) {
            return rs;
        }
        for (AdFlowPackageNewVo adFlow : adFlows) {
            packageIds.add(adFlow.getFlowPackageId());
        }
        rs = this.findPackageByCondition(packageIds);
        return rs;
    }

    @Override
    public List<AdFlowPackageNewVo> findPackageByCondition(Long ticketId, String type) {
        List<Object> adFlows = new ArrayList<AdFlowPackageNewVo>();
        if (ticketId == null) {
            return adFlows;
        }
        adFlows = this.adTicketFlowPackageMapper.findByAdFlowByConditionTwo(ticketId, Integer.valueOf(2));
        Map map = new HashMap();
        try {
            map = this.prodPositonGroupIntegration.getBudgetOfToday(ticketId);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4eca\u65e5\u6d88\u8017\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        for (AdFlowPackageNewVo adFlowPackageNewVo : adFlows) {
            String quota;
            Money money;
            Long consume;
            if (("cpc".equalsIgnoreCase(type) || "1".equalsIgnoreCase(type)) && null != (consume = (Long)map.get(adFlowPackageNewVo.getFlowPackageId().toString()))) {
                money = Money.ofLi((long)consume);
                adFlowPackageNewVo.setConsume(String.valueOf(money.getYuan()));
            }
            if ("infinity".equalsIgnoreCase(quota = adFlowPackageNewVo.getQuota()) || !StringUtil.isNotEmpty((CharSequence)quota)) continue;
            money = Money.ofLi((long)Long.valueOf(quota));
            adFlowPackageNewVo.setQuota(String.valueOf(money.getYuan()));
        }
        return adFlows;
    }

    private List<AdFlowPackageNewVo> findPackageByCondition(List<Long> packageIds) {
        List<Object> adFlows = new ArrayList<AdFlowPackageNewVo>();
        if (CollectionUtils.isEmpty(packageIds)) {
            return adFlows;
        }
        adFlows = this.adTicketFlowPackageMapper.findByAdFlowByConditionOne(packageIds);
        for (AdFlowPackageNewVo adFlowPackageNewVo : adFlows) {
            adFlowPackageNewVo.setQuota(null);
            adFlowPackageNewVo.setConsume(null);
            adFlowPackageNewVo.setPrice(null);
            adFlowPackageNewVo.setPriceYuan(null);
        }
        return adFlows;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void dealPackage(List<Long> flowPackageIds, Long ticketId, List<AdFlowPackageNewDto> adFlows, String username) {
        AdTicketFlowPackageConf adFlow;
        ArrayList<AdTicketFlowPackageConf> list = new ArrayList<AdTicketFlowPackageConf>();
        if (!CollectionUtils.isEmpty(flowPackageIds)) {
            for (Long flowPackageId : flowPackageIds) {
                adFlow = new AdTicketFlowPackageConf();
                adFlow.setTicketId(ticketId);
                adFlow.setFlowPackageId(flowPackageId);
                adFlow.setPrice(Long.valueOf(0L));
                adFlow.setCpaPrice(Long.valueOf(0L));
                adFlow.setDeepCpaPrice(Long.valueOf(0L));
                adFlow.setQuota("0");
                adFlow.setType(Integer.valueOf(1));
                adFlow.setCreateUser(username);
                adFlow.setModifyUser(username);
                list.add(adFlow);
            }
        }
        if (!CollectionUtils.isEmpty(adFlows)) {
            for (AdFlowPackageNewDto adFlowDto : adFlows) {
                Money money;
                adFlow = new AdTicketFlowPackageConf();
                adFlow.setTicketId(ticketId);
                adFlow.setFlowPackageId(adFlowDto.getFlowPackageId());
                String price = adFlowDto.getPrice();
                if (StringUtil.isNotEmpty((CharSequence)price)) {
                    Double priceTemp = Double.valueOf(price);
                    if (99999.0 < priceTemp) {
                        throw new RuntimeException("\u6700\u9ad8\u652f\u6301\u51fa\u4ef710.00\u5143");
                    }
                    if (0.001 > priceTemp) {
                        throw new RuntimeException("\u51fa\u4ef7\u5fc5\u987b\u5927\u4e8e0.00\u5143");
                    }
                    money = Money.ofYuan((double)Double.valueOf(price));
                    adFlow.setPrice(Long.valueOf(money.getLi()));
                } else {
                    adFlow.setPrice(Long.valueOf(0L));
                }
                String quota = adFlowDto.getQuota();
                if (StringUtil.isNotEmpty((CharSequence)quota)) {
                    if ("infinity".equalsIgnoreCase(quota)) {
                        adFlow.setQuota("infinity");
                    } else {
                        money = Money.ofYuan((double)Double.valueOf(quota));
                        adFlow.setQuota(String.valueOf(money.getLi()));
                    }
                } else {
                    adFlow.setQuota("0");
                }
                String cpaPrice = adFlowDto.getCpaPrice();
                if (StringUtil.isNotEmpty((CharSequence)cpaPrice)) {
                    Double priceTemp = Double.valueOf(cpaPrice);
                    Money money2 = Money.ofYuan((double)Double.valueOf(cpaPrice));
                    adFlow.setCpaPrice(Long.valueOf(money2.getLi()));
                } else {
                    adFlow.setCpaPrice(Long.valueOf(0L));
                }
                String deepCpaPrice = adFlowDto.getDeepCpaPrice();
                if (StringUtil.isNotEmpty((CharSequence)deepCpaPrice)) {
                    Double priceTemp = Double.valueOf(deepCpaPrice);
                    Money money3 = Money.ofYuan((double)Double.valueOf(deepCpaPrice));
                    adFlow.setDeepCpaPrice(Long.valueOf(money3.getLi()));
                } else {
                    adFlow.setDeepCpaPrice(Long.valueOf(0L));
                }
                adFlow.setType(Integer.valueOf(2));
                adFlow.setCreateUser(username);
                adFlow.setModifyUser(username);
                list.add(adFlow);
            }
        }
        this.adTicketFlowPackageMapper.deleteByTicketId(ticketId);
        if (!CollectionUtils.isEmpty(list)) {
            this.adTicketFlowPackageMapper.insert(list);
        }
    }

    @Override
    public void oldToNew(String username) throws Exception {
        List ticketPrices;
        List adFlows = this.adTicketFlowPackageMapper.findAdFlowAll();
        HashSet<Long> ticketIds = new HashSet<Long>();
        HashSet<Long> packageIds = new HashSet<Long>();
        for (AdFlowPackageNewVo adFlow : adFlows) {
            ticketIds.add(adFlow.getTicketId());
            packageIds.add(adFlow.getFlowPackageId());
        }
        HashMap<Long, Long> mapPrice = new HashMap<Long, Long>();
        if (!CollectionUtils.isEmpty(ticketIds) && !CollectionUtils.isEmpty((Collection)(ticketPrices = this.adTicketFlowPackageMapper.findTicketPrice(new ArrayList(ticketIds))))) {
            for (AdFlowPackageNewVo ticketPrice : ticketPrices) {
                mapPrice.put(ticketPrice.getTicketId(), ticketPrice.getPrice());
            }
        }
        HashMap<Long, String> mapPositionIds = new HashMap<Long, String>();
        if (!CollectionUtils.isEmpty(packageIds)) {
            List positionIds = this.adFlowPackageMapper.getPosition(new ArrayList(packageIds));
            for (AdFlowPackage adFlowPackage : positionIds) {
                mapPositionIds.put(adFlowPackage.getId(), adFlowPackage.getPositionId());
            }
        }
        ArrayList<AdTicketFlowPackageConf> list = new ArrayList<AdTicketFlowPackageConf>();
        ArrayList<PackagePushVo> pushVos = new ArrayList<PackagePushVo>();
        for (AdFlowPackageNewVo adFlowVo : adFlows) {
            AdTicketFlowPackageConf adFlow = new AdTicketFlowPackageConf();
            PackagePushVo pushVo = new PackagePushVo();
            Long ticketId = adFlowVo.getTicketId();
            adFlow.setTicketId(ticketId);
            pushVo.setTicketId(ticketId);
            Long flowPackageId = adFlowVo.getFlowPackageId();
            adFlow.setFlowPackageId(flowPackageId);
            pushVo.setGroupId(flowPackageId);
            pushVo.setPositionIds((String)mapPositionIds.getOrDefault(flowPackageId, null));
            Long price = mapPrice.getOrDefault(adFlowVo.getTicketId(), 0L);
            adFlow.setPrice(price);
            pushVo.setPrice(price);
            String quota = adFlowVo.getQuota();
            adFlow.setQuota(quota);
            if (StringUtil.isNotEmpty((CharSequence)quota)) {
                if (!"infinity".equalsIgnoreCase(quota)) {
                    Money money = Money.ofLi((long)Long.valueOf(quota));
                    pushVo.setLimit(Long.valueOf(money.getLi()));
                } else {
                    pushVo.setLimit(Long.valueOf(0L));
                }
            }
            adFlow.setType(Integer.valueOf(2));
            adFlow.setCreateUser(username);
            adFlow.setModifyUser(username);
            list.add(adFlow);
            pushVos.add(pushVo);
            if (list.size() != 1000) continue;
            this.adTicketFlowPackageMapper.insert(list);
            this.prodPusher.pushToProd(ProdServiceNameEnum.POSITION_GROUP_OLDTONEW.getServiceName(), null, JSONArray.toJSONBytes(pushVos, (SerializerFeature[])new SerializerFeature[0]));
            list.clear();
            pushVos.clear();
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.adTicketFlowPackageMapper.insert(list);
            this.prodPusher.pushToProd(ProdServiceNameEnum.POSITION_GROUP_OLDTONEW.getServiceName(), null, JSONArray.toJSONBytes(pushVos, (SerializerFeature[])new SerializerFeature[0]));
        }
    }
}

