/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adflowpackage.impl;

import com.bxm.adsmanager.dal.mapper.adflowpackage.AdTicketFlowPackageOfferConfMapper;
import com.bxm.adsmanager.dal.mapper.adflowpackage.AdTicketFlowPackageOfferRelationMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPositonGroupIntegration;
import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageOfferConf;
import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageOfferRelation;
import com.bxm.adsmanager.model.dto.AdTicketFlowPackageOfferConfDto;
import com.bxm.adsmanager.model.dto.AdTicketFlowPackageOfferRelationDto;
import com.bxm.adsmanager.model.vo.AdTicketFlowPackageOfferConfVo;
import com.bxm.adsmanager.model.vo.AdTicketFlowPackageOfferRelationVo;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowPackageOfferConfService;
import com.bxm.commons.currency.Money;
import com.bxm.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketFlowPackageOfferConfServiceImpl
implements AdTicketFlowPackageOfferConfService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketFlowPackageOfferConfServiceImpl.class);
    @Autowired
    private AdTicketFlowPackageOfferConfMapper adTicketFlowPackageOfferConfMapper;
    @Autowired
    private AdTicketFlowPackageOfferRelationMapper adTicketFlowPackageOfferRelationMapper;
    @Autowired
    private ProdPositonGroupIntegration prodPositonGroupIntegration;

    @Override
    @Transactional
    public Long save(List<AdTicketFlowPackageOfferConfDto> confs, Long ticketId, boolean is_new_ticket, String userName) {
        if (CollectionUtils.isEmpty(confs)) {
            return null;
        }
        Long flowPackageOfferConfId = null;
        AdTicketFlowPackageOfferConf conf = null;
        boolean is_new_conf = Boolean.FALSE;
        List flowPackageConfList = this.adTicketFlowPackageOfferConfMapper.findByTicketId(ticketId);
        if (CollectionUtils.isNotEmpty((Collection)flowPackageConfList)) {
            Set oldIds = flowPackageConfList.stream().map(AdTicketFlowPackageOfferConf::getId).collect(Collectors.toSet());
            Set newIds = confs.stream().filter(t -> t.getId() != null).map(AdTicketFlowPackageOfferConfDto::getId).collect(Collectors.toSet());
            oldIds.removeAll(newIds);
            if (CollectionUtils.isNotEmpty(oldIds)) {
                for (Long oldId : oldIds) {
                    this.adTicketFlowPackageOfferConfMapper.deleteByPrimaryKey(oldId);
                    this.adTicketFlowPackageOfferRelationMapper.deleteByFlowPackageOfferConfId(oldId);
                }
            }
        }
        for (AdTicketFlowPackageOfferConfDto confDto : confs) {
            List flowPackages;
            if (Boolean.TRUE == is_new_ticket || null == confDto.getId()) {
                conf = new AdTicketFlowPackageOfferConf();
                conf.setCreateUser(userName);
                this.fillAdFlowPackageConf(ticketId, userName, conf, confDto);
                this.adTicketFlowPackageOfferConfMapper.insert(conf);
                is_new_conf = Boolean.TRUE;
            } else {
                conf = this.adTicketFlowPackageOfferConfMapper.selectByPrimaryKey(confDto.getId());
                this.fillAdFlowPackageConf(ticketId, userName, conf, confDto);
                this.adTicketFlowPackageOfferConfMapper.updateByPrimaryKey(conf);
                is_new_conf = Boolean.FALSE;
            }
            if (Boolean.TRUE == confDto.getChecked()) {
                flowPackageOfferConfId = conf.getId();
            }
            if (CollectionUtils.isEmpty((Collection)(flowPackages = confDto.getFlowPackages()))) {
                if (Boolean.FALSE != is_new_conf) continue;
                this.adTicketFlowPackageOfferRelationMapper.deleteByFlowPackageOfferConfId(confDto.getId());
                continue;
            }
            this.saveAdFlowPackage(flowPackages, conf, is_new_conf, userName);
        }
        return flowPackageOfferConfId;
    }

    private void fillAdFlowPackageConf(Long ticketId, String userName, AdTicketFlowPackageOfferConf conf, AdTicketFlowPackageOfferConfDto confDto) {
        conf.setTicketId(ticketId);
        conf.setConfigName(confDto.getConfigName());
        conf.setConfigType(confDto.getConfigType());
        conf.setModifyUser(userName);
    }

    private void saveAdFlowPackage(List<AdTicketFlowPackageOfferRelationDto> flowPackages, AdTicketFlowPackageOfferConf conf, boolean is_new_conf, String userName) {
        ArrayList<AdTicketFlowPackageOfferRelation> addList = new ArrayList<AdTicketFlowPackageOfferRelation>();
        ArrayList<AdTicketFlowPackageOfferRelation> editList = new ArrayList<AdTicketFlowPackageOfferRelation>();
        ArrayList<Long> delList = new ArrayList<Long>();
        HashMap<Long, AdTicketFlowPackageOfferRelation> oldMap = new HashMap<Long, AdTicketFlowPackageOfferRelation>();
        AdTicketFlowPackageOfferRelation flowPackage = null;
        if (is_new_conf) {
            this.handerNewConfAdFlowPackage(flowPackages, conf, userName, addList);
            this.saveAdFlowPackage(addList, editList, delList);
            return;
        }
        List oldList = this.adTicketFlowPackageOfferRelationMapper.findByFlowPackageOfferConfId(conf.getId());
        if (CollectionUtils.isEmpty((Collection)oldList)) {
            this.handerNewConfAdFlowPackage(flowPackages, conf, userName, addList);
            this.saveAdFlowPackage(addList, editList, delList);
            return;
        }
        for (AdTicketFlowPackageOfferRelation old2 : oldList) {
            oldMap.put(old2.getFlowPackageId(), old2);
        }
        for (AdTicketFlowPackageOfferRelationDto flowPackageDto : flowPackages) {
            flowPackage = (AdTicketFlowPackageOfferRelation)oldMap.get(flowPackageDto.getFlowPackageId());
            if (flowPackage != null) {
                this.fillAdFlowPackage(conf, userName, flowPackage, flowPackageDto);
                editList.add(flowPackage);
                oldMap.remove(flowPackageDto.getFlowPackageId());
                continue;
            }
            flowPackage = new AdTicketFlowPackageOfferRelation();
            this.fillAdFlowPackage(conf, userName, flowPackage, flowPackageDto);
            flowPackage.setCreateUser(userName);
            addList.add(flowPackage);
        }
        oldMap.values().stream().forEach(old -> delList.add(old.getId()));
        this.saveAdFlowPackage(addList, editList, delList);
    }

    private void handerNewConfAdFlowPackage(List<AdTicketFlowPackageOfferRelationDto> flowPackages, AdTicketFlowPackageOfferConf conf, String userName, List<AdTicketFlowPackageOfferRelation> addList) {
        AdTicketFlowPackageOfferRelation flowPackage = null;
        for (AdTicketFlowPackageOfferRelationDto flowPackageDto : flowPackages) {
            flowPackage = new AdTicketFlowPackageOfferRelation();
            this.fillAdFlowPackage(conf, userName, flowPackage, flowPackageDto);
            flowPackage.setCreateUser(userName);
            addList.add(flowPackage);
        }
    }

    private void fillAdFlowPackage(AdTicketFlowPackageOfferConf conf, String userName, AdTicketFlowPackageOfferRelation flowPackage, AdTicketFlowPackageOfferRelationDto flowPackageDto) {
        Money money;
        flowPackage.setTicketId(conf.getTicketId());
        flowPackage.setFlowPackageOfferConfId(conf.getId());
        flowPackage.setFlowPackageId(flowPackageDto.getFlowPackageId());
        String price = flowPackageDto.getPrice();
        if (StringUtils.isNotEmpty((CharSequence)price)) {
            Double priceTemp = Double.valueOf(price);
            if (99999.0 < priceTemp) {
                throw new RuntimeException("\u6700\u9ad8\u652f\u6301\u51fa\u4ef710.00\u5143");
            }
            if (0.001 > priceTemp) {
                throw new RuntimeException("\u51fa\u4ef7\u5fc5\u987b\u5927\u4e8e0.00\u5143");
            }
            money = Money.ofYuan((double)Double.valueOf(price));
            flowPackage.setPrice(Long.valueOf(money.getLi()));
        } else {
            flowPackage.setPrice(Long.valueOf(0L));
        }
        String quota = flowPackageDto.getQuota();
        if (StringUtil.isNotEmpty((CharSequence)quota)) {
            if ("infinity".equalsIgnoreCase(quota)) {
                flowPackage.setQuota("infinity");
            } else {
                money = Money.ofYuan((double)Double.valueOf(quota));
                flowPackage.setQuota(String.valueOf(money.getLi()));
            }
        } else {
            flowPackage.setQuota("0");
        }
        String cpaPrice = flowPackageDto.getCpaPrice();
        if (StringUtils.isNotEmpty((CharSequence)cpaPrice)) {
            Double priceTemp = Double.valueOf(cpaPrice);
            Money money2 = Money.ofYuan((double)Double.valueOf(cpaPrice));
            flowPackage.setCpaPrice(Long.valueOf(money2.getLi()));
        } else {
            flowPackage.setCpaPrice(Long.valueOf(0L));
        }
        String deepCpaPrice = flowPackageDto.getDeepCpaPrice();
        if (StringUtils.isNotEmpty((CharSequence)deepCpaPrice)) {
            Double priceTemp = Double.valueOf(deepCpaPrice);
            Money money3 = Money.ofYuan((double)Double.valueOf(deepCpaPrice));
            flowPackage.setDeepCpaPrice(Long.valueOf(money3.getLi()));
        } else {
            flowPackage.setDeepCpaPrice(Long.valueOf(0L));
        }
        flowPackage.setModifyUser(userName);
    }

    private void saveAdFlowPackage(List<AdTicketFlowPackageOfferRelation> addList, List<AdTicketFlowPackageOfferRelation> editList, List<Long> delList) {
        if (CollectionUtils.isNotEmpty(addList)) {
            this.adTicketFlowPackageOfferRelationMapper.insertBatch(addList);
        }
        if (CollectionUtils.isNotEmpty(editList)) {
            this.adTicketFlowPackageOfferRelationMapper.updateBatch(editList);
        }
        if (CollectionUtils.isNotEmpty(delList)) {
            this.adTicketFlowPackageOfferRelationMapper.deleteBatch(delList);
        }
    }

    @Override
    public List<AdTicketFlowPackageOfferConfVo> findFlowPackageConfs(Long ticketId, String type) {
        ArrayList<AdTicketFlowPackageOfferConfVo> result = new ArrayList<AdTicketFlowPackageOfferConfVo>();
        List flowPackageConfList = this.adTicketFlowPackageOfferConfMapper.findByTicketId(ticketId);
        if (CollectionUtils.isEmpty((Collection)flowPackageConfList)) {
            return result;
        }
        HashMap<Long, AdTicketFlowPackageOfferConfVo> confVoMap = new HashMap<Long, AdTicketFlowPackageOfferConfVo>();
        AdTicketFlowPackageOfferConfVo confVo = null;
        for (AdTicketFlowPackageOfferConf flowPackageConf : flowPackageConfList) {
            confVo = new AdTicketFlowPackageOfferConfVo();
            confVo.setId(flowPackageConf.getId());
            confVo.setTicketId(flowPackageConf.getTicketId());
            confVo.setConfigName(flowPackageConf.getConfigName());
            confVo.setConfigType(flowPackageConf.getConfigType());
            confVo.setFlowPackages(new ArrayList());
            result.add(confVo);
            confVoMap.put(confVo.getId(), confVo);
        }
        Map map = new HashMap();
        try {
            map = this.prodPositonGroupIntegration.getBudgetOfToday(ticketId);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4eca\u65e5\u6d88\u8017\u5931\u8d25");
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        List flowPackageList = this.adTicketFlowPackageOfferRelationMapper.findFlowPackageByTicketId(ticketId);
        for (AdTicketFlowPackageOfferRelationVo packageVo : flowPackageList) {
            String quota;
            Money money;
            Long consume;
            confVo = (AdTicketFlowPackageOfferConfVo)confVoMap.get(packageVo.getFlowPackageOfferConfId());
            if (confVo == null) continue;
            if (("cpc".equalsIgnoreCase(type) || "1".equalsIgnoreCase(type)) && null != (consume = (Long)map.get(packageVo.getFlowPackageId().toString()))) {
                money = Money.ofLi((long)consume);
                packageVo.setConsume(String.valueOf(money.getYuan()));
            }
            if (!"infinity".equalsIgnoreCase(quota = packageVo.getQuota()) && StringUtil.isNotEmpty((CharSequence)quota)) {
                money = Money.ofLi((long)Long.valueOf(quota));
                packageVo.setQuota(String.valueOf(money.getYuan()));
            }
            confVo.getFlowPackages().add(packageVo);
        }
        return result;
    }
}

