/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adflowpackage.impl;

import com.bxm.adsmanager.dal.mapper.adflowpackage.AdTicketFlowPackageMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPositonGroupIntegration;
import com.bxm.adsmanager.model.dao.adflowpackage.AdTicketFlowPackageConf;
import com.bxm.adsmanager.model.dto.AdTicketFlowPackageDto;
import com.bxm.adsmanager.model.vo.AdFlowPackageVo;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowPackageService;
import com.bxm.commons.currency.Money;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketFlowPackageServiceImpl
implements AdTicketFlowPackageService {
    @Autowired
    private AdTicketFlowPackageMapper adTicketFlowPackageMapper;
    @Autowired
    private ProdPositonGroupIntegration prodPositonGroupIntegration;

    @Override
    @Transactional
    public void add(AdTicketFlowPackageDto adTicketFlowPackageDto, String userName, Short settleType) {
        String flowPackageIdsAndQuota = adTicketFlowPackageDto.getFlowPackageIdsAndQuota();
        String[] flowPackageIdsAndQuotaString = flowPackageIdsAndQuota.split(",");
        ArrayList<AdTicketFlowPackageConf> adTicketFlowPackageConfList = new ArrayList<AdTicketFlowPackageConf>();
        for (int i = 0; i < flowPackageIdsAndQuotaString.length; ++i) {
            String[] idAndQuota = flowPackageIdsAndQuotaString[i].split("-");
            AdTicketFlowPackageConf adTicketFlowPackageConf = new AdTicketFlowPackageConf();
            adTicketFlowPackageConf.setCreateUser(userName);
            adTicketFlowPackageConf.setFlowPackageId(Long.valueOf(Long.parseLong(idAndQuota[0])));
            if (!StringUtil.equals((String)"infinity", (String)idAndQuota[1])) {
                if (1 == settleType || 4 == settleType || 5 == settleType) {
                    Money money = Money.ofYuan((double)Double.valueOf(idAndQuota[1]));
                    adTicketFlowPackageConf.setQuota(money.getLi() + "");
                    this.prodPositonGroupIntegration.incrementIfNecessary(BigInteger.valueOf(Long.parseLong(adTicketFlowPackageDto.getTicketId())), idAndQuota[0], money.getLi());
                } else {
                    adTicketFlowPackageConf.setQuota(idAndQuota[1]);
                    this.prodPositonGroupIntegration.incrementIfNecessary(BigInteger.valueOf(Long.parseLong(adTicketFlowPackageDto.getTicketId())), idAndQuota[0], Long.parseLong(idAndQuota[1]));
                }
            } else {
                adTicketFlowPackageConf.setQuota("infinity");
                this.prodPositonGroupIntegration.incrementIfNecessary(BigInteger.valueOf(Long.parseLong(adTicketFlowPackageDto.getTicketId())), idAndQuota[0], 0L);
            }
            adTicketFlowPackageConf.setCreateTime(new Date());
            adTicketFlowPackageConf.setTicketId(Long.valueOf(Long.parseLong(adTicketFlowPackageDto.getTicketId())));
            adTicketFlowPackageConfList.add(adTicketFlowPackageConf);
        }
        this.adTicketFlowPackageMapper.deleteByTicketId(Long.valueOf(Long.parseLong(adTicketFlowPackageDto.getTicketId())));
        this.adTicketFlowPackageMapper.insert(adTicketFlowPackageConfList);
    }

    @Override
    public List<AdFlowPackageVo> findAll(String ticketId, String type) throws Exception {
        if (StringUtil.isBlank((CharSequence)ticketId)) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.adTicketFlowPackageMapper.findAll(ticketId);
        ArrayList<AdFlowPackageVo> afpvList = new ArrayList<AdFlowPackageVo>();
        Map map = this.prodPositonGroupIntegration.getBudgetOfToday(Long.valueOf(Long.parseLong(ticketId)));
        if (list != null && list.size() > 0) {
            for (AdTicketFlowPackageConf atfp : list) {
                AdFlowPackageVo vo = new AdFlowPackageVo();
                vo.setCount(Integer.valueOf(Integer.parseInt(atfp.getCount())));
                vo.setPositionId(atfp.getPositionId());
                vo.setPackageName(atfp.getPackageName());
                if (StringUtil.equals((String)"cpc", (String)type)) {
                    if (StringUtil.equals((String)"infinity", (String)atfp.getQuota())) {
                        vo.setQuota(atfp.getQuota());
                    } else {
                        vo.setQuota(Double.parseDouble(atfp.getQuota()) / 1000.0 + "");
                    }
                    if (null != map.get(atfp.getFlowPackageId() + "")) {
                        vo.setConsume(Double.parseDouble(map.get(atfp.getFlowPackageId() + "") + "") / 1000.0 + "");
                    } else {
                        vo.setConsume("");
                    }
                } else {
                    vo.setQuota(atfp.getQuota() + "");
                    vo.setConsume(map.get(atfp.getFlowPackageId() + "") + "");
                }
                vo.setTicketId(atfp.getTicketId() + "");
                vo.setId(atfp.getFlowPackageId());
                afpvList.add(vo);
            }
        }
        return afpvList;
    }
}

