/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsConfigUidMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsConfigUid;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsConfigUidExample;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsConfigUidDTO;
import com.bxm.adsmanager.model.dto.AdAssetsConfigUidSearchDTO;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.vo.AdAssetsConfigUidVo;
import com.bxm.adsmanager.service.adkeeper.AdAssetsConfigUidService;
import com.bxm.adsprod.facade.ticket.AssetsConfigUid;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdAssetsConfigUidServiceImpl
implements AdAssetsConfigUidService {
    private static final Logger log = LoggerFactory.getLogger(AdAssetsConfigUidServiceImpl.class);
    @Autowired
    private AdAssetsConfigUidMapperExt adAssetsConfigUidMapperExt;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;

    @Override
    public void add(AdAssetsConfigUidDTO dto, User user) throws Exception {
        AdAssetsConfigUidExample example = new AdAssetsConfigUidExample();
        example.createCriteria().andUidEqualTo(dto.getUid());
        List adAssetsConfigUids = this.adAssetsConfigUidMapperExt.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)adAssetsConfigUids)) {
            throw new BusinessException("\u8be5\u7528\u6237\u8bbe\u5907\u53f7\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        AdAssetsConfigUid adAssetsConfigUid = new AdAssetsConfigUid();
        BeanUtils.copyProperties((Object)dto, (Object)adAssetsConfigUid);
        adAssetsConfigUid.setStatus(Short.valueOf((short)1));
        adAssetsConfigUid.setCreateUser(user.getUsername());
        adAssetsConfigUid.setCreateTime(new Date());
        this.adAssetsConfigUidMapperExt.insertSelective(adAssetsConfigUid);
        this.pushToProd(adAssetsConfigUid);
    }

    @Override
    public void updateStatus(Long id, Short status, String username) throws Exception {
        AdAssetsConfigUid adAssetsUpdate = this.adAssetsConfigUidMapperExt.selectByPrimaryKey(id);
        if (adAssetsUpdate == null) {
            throw new BusinessException("\u6570\u636e\u672a\u627e\u5230");
        }
        adAssetsUpdate.setStatus(Short.valueOf(status));
        adAssetsUpdate.setModifyUser(username);
        adAssetsUpdate.setModifyTime(new Date());
        this.adAssetsConfigUidMapperExt.updateByPrimaryKey(adAssetsUpdate);
        this.pushToProd(adAssetsUpdate);
    }

    @Override
    public PageInfo<AdAssetsConfigUid> findPage(AdAssetsConfigUidSearchDTO searchDTO) throws Exception {
        PageHelper.startPage((int)searchDTO.getPageNum(), (int)searchDTO.getPageSize());
        return new PageInfo(this.adAssetsConfigUidMapperExt.findList(searchDTO));
    }

    @Override
    public AdAssetsConfigUidVo get(Long id) throws Exception {
        AdAssetsConfigUid adAssetsConfigUid = this.adAssetsConfigUidMapperExt.selectByPrimaryKey(id);
        if (adAssetsConfigUid == null) {
            throw new BusinessException("\u6570\u636e\u672a\u627e\u5230");
        }
        AdAssetsConfigUidVo adAssetsConfigUidVo = new AdAssetsConfigUidVo();
        BeanUtils.copyProperties((Object)adAssetsConfigUid, (Object)adAssetsConfigUidVo);
        return adAssetsConfigUidVo;
    }

    @Override
    public void update(AdAssetsConfigUidDTO dto, User user) throws Exception {
        AdAssetsConfigUid entity = this.adAssetsConfigUidMapperExt.selectByPrimaryKey(dto.getId());
        if (entity == null) {
            throw new BusinessException("\u6570\u636e\u672a\u627e\u5230");
        }
        if (!entity.getUid().equals(dto.getUid())) {
            AdAssetsConfigUidExample example = new AdAssetsConfigUidExample();
            example.createCriteria().andUidEqualTo(dto.getUid());
            List adAssetsConfigUids = this.adAssetsConfigUidMapperExt.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)adAssetsConfigUids)) {
                throw new BusinessException("\u8be5\u7528\u6237\u8bbe\u5907\u53f7\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
            }
        }
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setModifyUser(user.getUsername());
        entity.setModifyTime(new Date());
        this.adAssetsConfigUidMapperExt.updateByPrimaryKeySelective(entity);
        this.pushToProd(entity);
    }

    @Override
    public void delete(Long id, User user) throws Exception {
        AdAssetsConfigUid entity = this.adAssetsConfigUidMapperExt.selectByPrimaryKey(id);
        if (entity == null) {
            throw new BusinessException("\u6570\u636e\u672a\u627e\u5230");
        }
        entity.setStatus(Short.valueOf((short)0));
        this.pushToProd(entity);
        this.adAssetsConfigUidMapperExt.deleteByPrimaryKey(id);
    }

    private void pushToProd(AdAssetsConfigUid entity) throws Exception {
        if (entity != null) {
            AssetsConfigUid data = new AssetsConfigUid();
            BeanUtils.copyProperties((Object)entity, (Object)data);
            this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.ASSETS_CONFIG_UID.getServiceName(), null, JSONArray.toJSONBytes((Object)data, (SerializerFeature[])new SerializerFeature[0]));
        }
    }
}

