/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdPositionMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdRulesMapper;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.utils.DataParkUtils;
import com.bxm.adsmanager.model.dao.AdTicketPopup.ProvideAppDto;
import com.bxm.adsmanager.model.dao.adprofit.InfoActivityAppBusiness;
import com.bxm.adsmanager.model.dto.AdPositionSearchDto;
import com.bxm.adsmanager.model.enums.RuleTargetEnum;
import com.bxm.adsmanager.model.enums.RuleTypeEnum;
import com.bxm.adsmanager.model.vo.AdpositionVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.report.AppCountVo;
import com.bxm.adsmanager.redis.RedisClient;
import com.bxm.adsmanager.service.adkeeper.AdPositionService;
import com.bxm.adsmanager.utils.AppEntityConvertHelper;
import com.bxm.adsmanager.utils.ListUtil;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceCountByAppKeyVO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceMinOnlineTimeByAppKeyVO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdPositionServiceImpl
implements AdPositionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdPositionServiceImpl.class);
    private static final int TWO = 2;
    private static final String AAKT = "act:app:key:time";
    private static final Integer DB = 5;
    private static final String AR = "act:radom";
    private static final String AW = "act:weight";
    @Autowired
    private AdPositionMapper adPositionMapper;
    @Autowired
    private AdRulesMapper adRulesMapper;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @Override
    public Pagination findAll(AdPositionSearchDto condition) {
        String result;
        List<Object> queryResult = Lists.newArrayList();
        String appKeyOrNameKeywords = null;
        Long mediaClassId = null;
        Long mediaChildClassId = null;
        Long ticketId = null;
        String entranceName = null;
        if (null != condition) {
            if (StringUtils.isNotBlank((CharSequence)condition.getMediaName())) {
                appKeyOrNameKeywords = condition.getMediaName().trim();
            }
            if (StringUtil.isNotBlank((CharSequence)condition.getMediaClassId()) && StringUtils.isNumeric((CharSequence)condition.getMediaClassId())) {
                mediaClassId = Long.valueOf(condition.getMediaClassId());
            }
            if (StringUtil.isNotBlank((CharSequence)condition.getMediaChildClassId()) && StringUtils.isNumeric((CharSequence)condition.getMediaChildClassId())) {
                mediaChildClassId = Long.valueOf(condition.getMediaChildClassId());
            }
            if (StringUtil.isNotBlank((CharSequence)condition.getEntranceName())) {
                entranceName = condition.getEntranceName().trim();
            }
            ticketId = condition.getAdTicketId();
        }
        if (null != ticketId && StringUtil.isNotBlank((CharSequence)(result = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()), condition.getAdTicketId())))) {
            result = result.substring(2);
            String[] resultArray = result.split(",");
            List<String> appkeyList = Arrays.asList(resultArray);
            QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
            paramDTO.setPositionIds(appkeyList);
            paramDTO.setAppKeyOrProviderNameKeywords(appKeyOrNameKeywords);
            paramDTO.setMediaSysType(condition.getMediaType());
            paramDTO.setMediaClassId(mediaClassId);
            paramDTO.setMediaChildClassId(mediaChildClassId);
            paramDTO.setEntranceNameOrCode(entranceName);
            paramDTO.setCouponsPutinFlag(condition.getCouponsPutinFlag());
            paramDTO.setPutinType(condition.getPutinType());
            paramDTO.setAdType(condition.getAdType());
            paramDTO.setPositionType(condition.getPositionType());
            paramDTO.setPositionScene(condition.getPositionScene());
            paramDTO.setTicketType(condition.getTicketType());
            paramDTO.setDockingMethod(condition.getDockingMethod());
            paramDTO.setCountry(condition.getCountry());
            List appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
            paramDTO = new QueryAppEntranceParamDTO();
            paramDTO.setAppKeyOrProviderNameKeywords(appKeyOrNameKeywords);
            paramDTO.setMediaSysType(condition.getMediaType());
            paramDTO.setMediaClassId(mediaClassId);
            paramDTO.setMediaChildClassId(mediaChildClassId);
            paramDTO.setEntranceNameOrCode(entranceName);
            paramDTO.setCouponsPutinFlag(condition.getCouponsPutinFlag());
            paramDTO.setPutinType(condition.getPutinType());
            paramDTO.setAdType(condition.getAdType());
            paramDTO.setPositionType(condition.getPositionType());
            paramDTO.setNotInIds(appEntranceAdRos.stream().map(AppEntranceAdRO::getId).collect(Collectors.toList()));
            paramDTO.setPositionScene(condition.getPositionScene());
            paramDTO.setTicketType(condition.getTicketType());
            paramDTO.setDockingMethod(condition.getDockingMethod());
            paramDTO.setCountry(condition.getCountry());
            appEntranceAdRos.addAll(this.newAppEntranceFacadeIntegration.getAllList(paramDTO));
            queryResult = ListUtil.getTotalPage(appEntranceAdRos, appEntranceAdRos.size(), condition.getPageNum(), condition.getPageSize());
        }
        Pagination pagination = new Pagination();
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        if (CollectionUtils.isEmpty((Collection)queryResult)) {
            QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
            paramDTO.setAppKeyOrProviderNameKeywords(appKeyOrNameKeywords);
            paramDTO.setMediaSysType(condition.getMediaType());
            paramDTO.setMediaClassId(mediaClassId);
            paramDTO.setMediaChildClassId(mediaChildClassId);
            paramDTO.setEntranceNameOrCode(entranceName);
            paramDTO.setCouponsPutinFlag(condition.getCouponsPutinFlag());
            paramDTO.setPutinType(condition.getPutinType());
            paramDTO.setAdType(condition.getAdType());
            paramDTO.setPositionType(condition.getPositionType());
            paramDTO.setSortField(condition.getOrderParam());
            paramDTO.setOrderType(condition.getOrderType());
            paramDTO.setPageNum(condition.getPageNum());
            paramDTO.setPageSize(condition.getPageSize());
            paramDTO.setPositionScene(condition.getPositionScene());
            paramDTO.setTicketType(condition.getTicketType());
            paramDTO.setDockingMethod(condition.getDockingMethod());
            paramDTO.setCountry(condition.getCountry());
            PageInfo appEntranceAdRoPageInfo = this.newAppEntranceFacadeIntegration.getPage(paramDTO);
            if (CollectionUtils.isEmpty((Collection)appEntranceAdRoPageInfo.getList())) {
                return this.noDataPagination();
            }
            queryResult = appEntranceAdRoPageInfo.getList();
            pagination.setTotalCount((int)appEntranceAdRoPageInfo.getTotal());
        }
        List<AdpositionVo> adpositionVOList = AppEntityConvertHelper.convertAppEntranceToAdpositionVO(queryResult);
        pagination.setList(adpositionVOList);
        return pagination;
    }

    private Pagination noDataPagination() {
        Pagination pagination = new Pagination();
        pagination.setList((List)Lists.newArrayList());
        return pagination;
    }

    @Override
    public Pagination findByAdTicketId(AdPositionSearchDto condition) {
        if (condition == null || null == condition.getAdTicketId()) {
            throw new ValidateException("adTicketId is null");
        }
        String result = this.adRulesMapper.findByTicketId(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()), Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()), condition.getAdTicketId());
        if (StringUtils.isBlank((CharSequence)result)) {
            return this.noDataPagination();
        }
        String[] resultArray = (result = result.substring(2)).split(",");
        List<String> appkeyList = Arrays.asList(resultArray);
        if (CollectionUtils.isEmpty(appkeyList)) {
            return this.noDataPagination();
        }
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setPositionIds(appkeyList);
        paramDTO.setAppKeyOrProviderNameKeywords(condition.getMediaName());
        paramDTO.setPageNum(condition.getPageNum());
        paramDTO.setPageSize(condition.getPageSize());
        PageInfo appEntranceAdRoPageInfo = this.newAppEntranceFacadeIntegration.getPage(paramDTO);
        List appEntranceAdRos = appEntranceAdRoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return this.noDataPagination();
        }
        Pagination pagination = new Pagination();
        pagination.setList(AppEntityConvertHelper.convertAppEntranceToAdpositionVO(appEntranceAdRos));
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        pagination.setTotalCount((int)appEntranceAdRoPageInfo.getTotal());
        return pagination;
    }

    @Override
    public Pagination findByIdsStr(AdPositionSearchDto condition) {
        String[] resultArray;
        List<String> appkeyList;
        String idsStr = condition.getIdsStr();
        if (StringUtils.isBlank((CharSequence)idsStr)) {
            return this.noDataPagination();
        }
        String appKeyOrNameKeywords = null;
        String entranceName = null;
        if (StringUtils.isNotBlank((CharSequence)condition.getMediaName())) {
            appKeyOrNameKeywords = condition.getMediaName().trim();
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getEntranceName())) {
            entranceName = condition.getEntranceName().trim();
        }
        if (CollectionUtils.isEmpty(appkeyList = Arrays.asList(resultArray = idsStr.split(",")))) {
            return this.noDataPagination();
        }
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setPositionIds(appkeyList);
        paramDTO.setAppKeyOrProviderNameKeywords(appKeyOrNameKeywords);
        paramDTO.setMediaSysType(condition.getMediaType());
        if (StringUtil.isNotBlank((CharSequence)condition.getMediaClassId()) && StringUtils.isNumeric((CharSequence)condition.getMediaClassId())) {
            paramDTO.setMediaClassId(Long.valueOf(condition.getMediaClassId()));
        }
        if (StringUtil.isNotBlank((CharSequence)condition.getMediaChildClassId()) && StringUtils.isNumeric((CharSequence)condition.getMediaChildClassId())) {
            paramDTO.setMediaChildClassId(Long.valueOf(condition.getMediaChildClassId()));
        }
        paramDTO.setCouponsPutinFlag(condition.getCouponsPutinFlag());
        paramDTO.setAdType(condition.getAdType());
        paramDTO.setPositionType(condition.getPositionType());
        paramDTO.setEntranceNameOrCode(entranceName);
        paramDTO.setPositionScene(condition.getPositionScene());
        paramDTO.setTicketType(condition.getTicketType());
        paramDTO.setCountry(condition.getCountry());
        paramDTO.setPageNum(condition.getPageNum());
        paramDTO.setPageSize(condition.getPageSize());
        PageInfo appEntranceAdRoPageInfo = this.newAppEntranceFacadeIntegration.getPage(paramDTO);
        List appEntranceAdRos = appEntranceAdRoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return this.noDataPagination();
        }
        Pagination pagination = new Pagination();
        pagination.setList(AppEntityConvertHelper.convertAppEntranceToAdpositionVO(appEntranceAdRos));
        pagination.setPageSize(condition.getPageSize());
        pagination.setPageNo(condition.getPageNum());
        pagination.setTotalCount((int)appEntranceAdRoPageInfo.getTotal());
        return pagination;
    }

    @Override
    public List<ProvideAppDto> findAllByAppName(String appName) {
        List appEntranceAdRos = this.newAppEntranceFacadeIntegration.findByFuzzyProviderAlias(appName);
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return Collections.emptyList();
        }
        return AppEntityConvertHelper.convertAppEntranceToProvideAppDto(appEntranceAdRos);
    }

    @Override
    public List<ProvideAppDto> findAllByPositionId(String positionIdStr) {
        if (StringUtils.isBlank((CharSequence)positionIdStr)) {
            return Collections.emptyList();
        }
        String[] positionIds = positionIdStr.split(",");
        List<String> positionIdList = Arrays.asList(positionIds);
        if (CollectionUtils.isEmpty(positionIdList)) {
            return Collections.emptyList();
        }
        List appEntranceAdROS = this.newAppEntranceFacadeIntegration.findListByPositionIds(positionIdList);
        if (CollectionUtils.isEmpty((Collection)appEntranceAdROS)) {
            return Collections.emptyList();
        }
        return AppEntityConvertHelper.convertAppEntranceToProvideAppDto(appEntranceAdROS);
    }

    @Override
    public Boolean findAppBusinessIsExist(String appKey, String business) {
        Integer count = this.adPositionMapper.findAppBusinessIsExist(appKey, business);
        return count > 0;
    }

    @Override
    public int add(InfoActivityAppBusiness infoActivityAppBusiness) {
        Integer num = this.adPositionMapper.add(infoActivityAppBusiness);
        return num;
    }

    @Override
    public Map<String, AppEntranceAdRO> findByPositionIds(List<String> positionIds) {
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setPositionIds(positionIds);
        paramDTO.setPageNum(Integer.valueOf(1));
        paramDTO.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo appEntranceAdRoPageInfo = this.newAppEntranceFacadeIntegration.getPage(paramDTO);
        List appEntranceAdRos = appEntranceAdRoPageInfo.getList();
        HashMap<String, AppEntranceAdRO> map = new HashMap<String, AppEntranceAdRO>();
        if (CollectionUtils.isNotEmpty((Collection)appEntranceAdRos)) {
            for (AppEntranceAdRO adpositionVo : appEntranceAdRos) {
                map.put(adpositionVo.getPositionId(), adpositionVo);
            }
        }
        return map;
    }

    @Override
    public List<AdpositionVo> findBusinesses(String appKey, String keyword, String onlineStart, String onlineEnd) {
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setFuzzyAppKey(appKey);
        paramDTO.setFuzzyAppEntranceName(keyword);
        paramDTO.setOnlineTimeStart(onlineStart);
        paramDTO.setOnlineTimeEnd(onlineEnd);
        List appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return Collections.emptyList();
        }
        return AppEntityConvertHelper.convertAppEntranceToAdpositionVO(appEntranceAdRos);
    }

    @Override
    public List<AdpositionVo> findAllBusinesses() {
        List appEntranceAdRoPageInfo = this.newAppEntranceFacadeIntegration.getAllList(new QueryAppEntranceParamDTO());
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRoPageInfo)) {
            return Collections.emptyList();
        }
        return AppEntityConvertHelper.convertAppEntranceToAdpositionVO(appEntranceAdRoPageInfo);
    }

    @Override
    public Map<String, Integer> getBusinessNumberByAppKeys(List<String> appKeys) {
        List appEntranceCountByAppKeyVOS = this.newAppEntranceFacadeIntegration.getAppEntranceCountGroupByAppKeys(appKeys);
        if (CollectionUtils.isEmpty((Collection)appEntranceCountByAppKeyVOS)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)appEntranceCountByAppKeyVOS.size());
        for (AppEntranceCountByAppKeyVO vo : appEntranceCountByAppKeyVOS) {
            map.put(vo.getAppKey(), vo.getAppEntranceCount());
        }
        return map;
    }

    @Override
    public Map<String, String> findAppKeysByOnline(List<String> list, String onlineStart, String onlineEndTemp) {
        List appEntranceMinOnlineTimeByAppKeyVOS;
        HashMap<String, String> appCountMap = new HashMap<String, String>();
        String onlineEnd = "";
        if (StringUtils.isNotBlank((CharSequence)onlineEndTemp)) {
            onlineEnd = DataParkUtils.getNextDate((String)onlineEndTemp);
        }
        if (CollectionUtils.isEmpty((Collection)(appEntranceMinOnlineTimeByAppKeyVOS = this.newAppEntranceFacadeIntegration.getAppEntranceMinOnlineTimeGroupByAppKey(list, onlineStart, onlineEnd)))) {
            return Collections.emptyMap();
        }
        for (AppEntranceMinOnlineTimeByAppKeyVO vo : appEntranceMinOnlineTimeByAppKeyVOS) {
            appCountMap.put(vo.getAppKey(), vo.getOnlineTime());
        }
        return appCountMap;
    }

    @Override
    public List<AppCountVo> findBusinessByAppkeyTime(String appKey, String onlineStart, String onlineEndTemp) {
        List appEntranceAdRos;
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setAppKey(appKey);
        paramDTO.setOnlineTimeStart(onlineStart);
        if (StringUtils.isNotBlank((CharSequence)onlineEndTemp)) {
            paramDTO.setOnlineTimeEnd(DataParkUtils.getNextDate((String)onlineEndTemp));
        }
        if (CollectionUtils.isEmpty((Collection)(appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(paramDTO)))) {
            return Collections.emptyList();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList appCountVos = Lists.newArrayListWithCapacity((int)appEntranceAdRos.size());
        for (AppEntranceAdRO ro : appEntranceAdRos) {
            AppCountVo appCountVo = new AppCountVo();
            appCountVo.setBusiness(ro.getAppEntranceId().toString());
            appCountVo.setOnlineTime(simpleDateFormat.format(ro.getOnlineTime()));
            appCountVos.add(appCountVo);
        }
        return appCountVos;
    }

    @Override
    public List<AdpositionVo> findByBusinesses(String appKey, StringBuffer sbBusinesses) {
        ArrayList businesses = Lists.newArrayList();
        if (sbBusinesses != null && StringUtils.isNotEmpty((CharSequence)sbBusinesses.toString())) {
            for (String business : sbBusinesses.toString().split(",")) {
                try {
                    businesses.add(business.replaceAll("ad-", ""));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)businesses)) {
            return Collections.emptyList();
        }
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setAppEntranceIds((List)businesses);
        paramDTO.setAppKey(appKey);
        List appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return Collections.emptyList();
        }
        return AppEntityConvertHelper.convertAppEntranceToAdpositionVO(appEntranceAdRos);
    }

    public static void dealAppActivityRadom(String appkey, String business, List<Integer> activityids, RedisClient redisClient) {
        String time = redisClient.getRedisWhitDB(AAKT, DB);
        if (time == null) {
            return;
        }
        redisClient.hset(AdPositionServiceImpl.mergeKey(AR, time), appkey + ":" + business, JSON.toJSONString(activityids), DB, null);
        redisClient.hdel(AdPositionServiceImpl.mergeKey(AW, time), appkey + ":" + business, DB);
    }

    public static void dealAppActivityWeight(String appkey, String business, List<Integer> activityids, RedisClient redisClient) {
        String time = redisClient.getRedisWhitDB(AAKT, DB);
        if (time == null) {
            return;
        }
        redisClient.hset(AdPositionServiceImpl.mergeKey(AW, time), appkey + ":" + business, JSON.toJSONString(activityids), DB, null);
        redisClient.hdel(AdPositionServiceImpl.mergeKey(AR, time), appkey + ":" + business, DB);
    }

    public static String mergeKey(String firstKey, String time) {
        return firstKey + ":" + time;
    }
}

