/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.TicketArpuMapper;
import com.bxm.adsmanager.model.dao.adkeeper.TicketArpu;
import com.bxm.adsmanager.model.dto.TicketArpuDTO;
import com.bxm.adsmanager.model.vo.AdTicketAppEntranceVo;
import com.bxm.adsmanager.model.vo.AdTicketArpuVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketArpuService;
import com.bxm.adsmanager.service.adkeeper.AdTicketTagConfService;
import com.bxm.adsmanager.service.adkeeper.impl.AdTicketServiceImpl;
import com.bxm.util.StringUtil;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AdTicketArpuServiceImpl
implements AdTicketArpuService {
    @Autowired
    TicketArpuMapper ticketArpuMapper;
    @Autowired
    AdTicketMapper adTicketMapper;
    @Autowired
    AdTicketServiceImpl adTicketService;
    @Autowired
    private AdTicketTagConfService adTicketTagConfService;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    private static final String STR_TWO = "2-";
    private static final int TWO = 2;

    @Override
    public PageInfo<AdTicketArpuVo> findAll(TicketArpuDTO ticketArpuDTO) {
        String code = ticketArpuDTO.getStatusCode();
        if (StringUtil.isNotBlank((CharSequence)code)) {
            if (code.contains(STR_TWO)) {
                ticketArpuDTO.setPauseReason(Integer.valueOf(Integer.parseInt(code.substring(2))));
            } else {
                ticketArpuDTO.setStatus(Short.valueOf(code));
            }
        }
        List activityTicketList = this.adTicketMapper.getAdTicketAppEntrance(ticketArpuDTO.getActivityTicketIdOrName(), Arrays.asList("12"), null, null, null);
        List normalsTicketList = this.adTicketMapper.getAdTicketAppEntrance(ticketArpuDTO.getNormalsTicketIdOrName(), Arrays.asList("1"), ticketArpuDTO.getStatus(), null, ticketArpuDTO.getPauseReason());
        if (CollectionUtils.isEmpty((Collection)activityTicketList) || CollectionUtils.isEmpty((Collection)normalsTicketList)) {
            return new PageInfo();
        }
        ArrayList<String> activityTicketIds = new ArrayList<String>(activityTicketList.size());
        ArrayList<Long> normals = new ArrayList<Long>(normalsTicketList.size());
        HashMap<String, AdTicketAppEntranceVo> map = new HashMap<String, AdTicketAppEntranceVo>();
        for (Object adTicketAppEntranceVo : activityTicketList) {
            map.put(adTicketAppEntranceVo.getId(), (AdTicketAppEntranceVo)adTicketAppEntranceVo);
            activityTicketIds.add(adTicketAppEntranceVo.getId());
        }
        List<Object> ticketIds = new ArrayList();
        if (null != ticketArpuDTO.getTagCode()) {
            ticketIds = this.adTicketTagConfService.findTicketIds(ticketArpuDTO.getTagCode());
        }
        for (AdTicketAppEntranceVo adTicketAppEntranceVo : normalsTicketList) {
            map.put(adTicketAppEntranceVo.getId(), adTicketAppEntranceVo);
            normals.add(Long.valueOf(adTicketAppEntranceVo.getId()));
        }
        PageHelper.startPage((int)ticketArpuDTO.getPageNum(), (int)ticketArpuDTO.getPageSize());
        List list = this.ticketArpuMapper.selectByParams(activityTicketIds, normals);
        PageInfo adTicketArpuVoPageInfo = new PageInfo(list);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return adTicketArpuVoPageInfo;
        }
        Map<String, String> dictionariesMap = this.adTicketService.getDictionaries("adstatus");
        Map<Long, String> tagNameMap = this.adTicketTagConfService.findClassifyTagName(normals);
        ArrayList<AdTicketArpuVo> finalList = new ArrayList<AdTicketArpuVo>();
        for (AdTicketArpuVo adTicketArpuVo : list) {
            if (null != ticketArpuDTO.getTagCode() && !ticketIds.contains(Long.valueOf(adTicketArpuVo.getNormalsTicketId()))) continue;
            adTicketArpuVo.setActivityTicketName(((AdTicketAppEntranceVo)map.get(adTicketArpuVo.getActivityTicketId())).getName());
            AdTicketAppEntranceVo adTicketAppEntranceVo = (AdTicketAppEntranceVo)map.get(adTicketArpuVo.getNormalsTicketId());
            adTicketArpuVo.setStatus(adTicketAppEntranceVo.getStatus());
            adTicketArpuVo.setNormalsTicketName(adTicketAppEntranceVo.getName());
            if (adTicketAppEntranceVo.getStatus() == 2 && adTicketAppEntranceVo.getPauseReason() != null) {
                adTicketArpuVo.setPauseReason(dictionariesMap.get(STR_TWO + adTicketAppEntranceVo.getPauseReason()));
            } else {
                adTicketArpuVo.setPauseReason(dictionariesMap.get(adTicketAppEntranceVo.getStatus() + ""));
            }
            adTicketArpuVo.setTagName(tagNameMap.get(Long.valueOf(adTicketAppEntranceVo.getId())));
            adTicketArpuVo.setLastStatus(adTicketAppEntranceVo.getLastStatus());
            finalList.add(adTicketArpuVo);
        }
        adTicketArpuVoPageInfo.setList(finalList);
        return adTicketArpuVoPageInfo;
    }

    @Override
    public void add(TicketArpuDTO ticketArpuDTO) throws Exception {
        if (StringUtils.isEmpty((Object)ticketArpuDTO.getActivityTicketId()) || StringUtils.isEmpty((Object)ticketArpuDTO.getNormalsTicketId()) || StringUtils.isEmpty((Object)ticketArpuDTO.getArpu())) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.ticketArpuMapper.selectByParams(Arrays.asList(ticketArpuDTO.getActivityTicketId()), Arrays.asList(Long.valueOf(ticketArpuDTO.getNormalsTicketId())));
        if (list.size() > 0) {
            throw new Exception("\u8981\u6dfb\u52a0\u7684\u503c\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u5728\u539f\u6709\u7684\u57fa\u7840\u4e0a\u9762\u4fee\u6539");
        }
        TicketArpu ticketArpu = new TicketArpu();
        ticketArpu.setArpu(ticketArpuDTO.getArpu());
        ticketArpu.setActivityTicketId(Long.valueOf(ticketArpuDTO.getActivityTicketId()));
        ticketArpu.setNormalsTicketId(Long.valueOf(ticketArpuDTO.getNormalsTicketId()));
        ticketArpu.setCreated(new Date());
        this.ticketArpuMapper.insert(ticketArpu);
        this.updater.hupdate(AdTicketArpuServiceImpl.keyGenerator(ticketArpuDTO.getActivityTicketId()), ticketArpuDTO.getNormalsTicketId(), (Object)ticketArpuDTO.getArpu());
    }

    @Override
    public void update(TicketArpuDTO ticketArpuDTO) throws Exception {
        AdTicketArpuVo adTicketArpuVo;
        if (StringUtils.isEmpty((Object)ticketArpuDTO.getActivityTicketId()) || StringUtils.isEmpty((Object)ticketArpuDTO.getNormalsTicketId()) || StringUtils.isEmpty((Object)ticketArpuDTO.getArpu()) || ticketArpuDTO.getId() == null) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TicketArpu ticketArpu = this.ticketArpuMapper.selectByPrimaryKey(ticketArpuDTO.getId());
        if (ticketArpu == null) {
            throw new Exception("\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List list = this.ticketArpuMapper.selectByParams(Arrays.asList(ticketArpuDTO.getActivityTicketId()), Arrays.asList(Long.valueOf(ticketArpuDTO.getNormalsTicketId())));
        if (!CollectionUtils.isEmpty((Collection)list) && (adTicketArpuVo = (AdTicketArpuVo)list.get(0)).getId() != ticketArpu.getId()) {
            throw new Exception("\u4fee\u6539\u7684\u6570\u636e\u5df2\u7ecf\u5b58\u5728");
        }
        this.updater.hremove(AdTicketArpuServiceImpl.keyGenerator(ticketArpu.getActivityTicketId().toString()), new String[]{ticketArpu.getNormalsTicketId().toString()});
        ticketArpu.setArpu(ticketArpuDTO.getArpu());
        ticketArpu.setActivityTicketId(Long.valueOf(ticketArpuDTO.getActivityTicketId()));
        ticketArpu.setNormalsTicketId(Long.valueOf(ticketArpuDTO.getNormalsTicketId()));
        ticketArpu.setUpdated(new Date());
        this.ticketArpuMapper.updateByPrimaryKeySelective(ticketArpu);
        this.updater.hupdate(AdTicketArpuServiceImpl.keyGenerator(ticketArpuDTO.getActivityTicketId()), ticketArpuDTO.getNormalsTicketId(), (Object)ticketArpuDTO.getArpu());
    }

    @Override
    public void delete(Integer id) throws Exception {
        TicketArpu ticketArpu = this.ticketArpuMapper.selectByPrimaryKey(id);
        if (ticketArpu == null) {
            throw new Exception("\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.ticketArpuMapper.deleteByPrimaryKey(id);
        this.updater.hremove(AdTicketArpuServiceImpl.keyGenerator(ticketArpu.getActivityTicketId().toString()), new String[]{ticketArpu.getNormalsTicketId().toString()});
    }

    public static KeyGenerator keyGenerator(String activityId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ARPU", "ACTIVITY", "TICKET", activityId});
    }
}

