/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsAdxMapperExt;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdx;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdxExample;
import com.bxm.adsmanager.model.dto.AdAssetsAdxDto;
import com.bxm.adsmanager.model.vo.AdAssetsAdxVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsAdxService;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdTicketAssetsAdxServiceImpl
implements AdTicketAssetsAdxService {
    @Autowired
    private AdAssetsAdxMapperExt adAssetsAdxMapperExt;
    @Autowired
    private ProdPullerIntegration prodPullerIntegration;

    @Override
    public List<AdAssetsAdx> findByTicketId(Long ticketId) {
        AdAssetsAdxExample example = new AdAssetsAdxExample();
        example.createCriteria().andAdTicketIdEqualTo(ticketId);
        List list = this.adAssetsAdxMapperExt.selectByExample(example);
        return list;
    }

    @Override
    public List<AdAssetsAdx> findByIds(String ids) {
        if (StringUtil.isBlank((CharSequence)ids)) {
            return null;
        }
        String[] idsStr = ids.split(",");
        ArrayList<Long> assetsAdxIds = new ArrayList<Long>(idsStr.length);
        for (String id : idsStr) {
            assetsAdxIds.add(Long.valueOf(id));
        }
        return this.adAssetsAdxMapperExt.findByIds(assetsAdxIds);
    }

    @Override
    public Pagination findAllAssetsListByParams(AdAssetsAdxDto adAssetsAdxDto) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("keywords", adAssetsAdxDto.getKeywords());
        map.put("status", adAssetsAdxDto.getTypeStatus());
        map.put("ticketId", adAssetsAdxDto.getTicketId());
        map.put("pageStart", adAssetsAdxDto.getPageStart());
        map.put("pageSize", adAssetsAdxDto.getPageSize());
        Integer count = this.adAssetsAdxMapperExt.getTotalCount(map);
        List list = this.adAssetsAdxMapperExt.findAllAssetsListByParams(map);
        ArrayList<AdAssetsAdxVo> listVo = new ArrayList<AdAssetsAdxVo>();
        for (AdAssetsAdx ad : list) {
            AdAssetsAdxVo assetsVo = new AdAssetsAdxVo();
            BeanUtils.copyProperties((Object)ad, (Object)assetsVo);
            listVo.add(assetsVo);
        }
        Pagination pagination = new Pagination();
        pagination.setList(listVo);
        pagination.setPageSize(adAssetsAdxDto.getPageSize());
        pagination.setPageNo(adAssetsAdxDto.getPageNum());
        pagination.setTotalCount(count.intValue());
        return pagination;
    }

    private int getClickCount(Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchAssetAllClikePvCount(assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getViewCount(Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchAssetAllViewPvCount(assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getValidClickCount(Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchAssetValiedClikePvCount(assetsId.toString(), daily).intValue();
        }
        return count;
    }

    public static Set<String> getDailyBetweenDate(Date beginDate, Date endDate) {
        HashSet<String> lDate = new HashSet<String>();
        lDate.add(DateUtil.dateTo8String1((Date)beginDate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!endDate.after(cal.getTime())) break;
            lDate.add(DateUtil.dateTo8String1((Date)cal.getTime()));
        }
        lDate.add(DateUtil.dateTo8String1((Date)endDate));
        return lDate;
    }
}

