/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsCouponsMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.TblAdTicketModifyMapperExt;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsCoupons;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsCouponsExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketUrlTest;
import com.bxm.adsmanager.model.dao.adkeeper.TblAdTicketModify;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsCouponsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketAssetsCouponsServiceImpl
implements AdTicketAssetsCouponsService {
    @Autowired
    private AdAssetsCouponsMapperExt adAssetsCouponsMapperExt;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private TblAdTicketModifyMapperExt tblAdTicketModifyMapperExt;
    @Autowired
    private ProdService prodService;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private ProdPullerIntegration prodPullerIntegration;

    @Override
    public List<AdAssetsCoupons> findByTicketId(Long ticketId) {
        AdAssetsCouponsExample example = new AdAssetsCouponsExample();
        example.createCriteria().andTicketIdEqualTo(ticketId);
        List list = this.adAssetsCouponsMapperExt.selectByExample(example);
        return list;
    }

    @Override
    public void updateTicketIdByAssetsCouponsIds(Long ticketId, String assetsCouponsIds) {
        String[] assetsidsArray = assetsCouponsIds.split(",");
        ArrayList<Long> assetsCouponsIdList = new ArrayList<Long>(assetsidsArray.length);
        for (String a : assetsidsArray) {
            assetsCouponsIdList.add(Long.parseLong(a));
        }
        if (CollectionUtils.isNotEmpty(assetsCouponsIdList)) {
            this.adAssetsCouponsMapperExt.updateTicketIdByAssetsCouponsIds(ticketId, assetsCouponsIdList);
        }
    }

    @Override
    @Transactional
    public Long add(AdAssetsCoupons adAssetsCoupons) {
        adAssetsCoupons.setId(null);
        int result = this.adAssetsCouponsMapperExt.insert(adAssetsCoupons);
        if (result > 0) {
            return adAssetsCoupons.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public void add(List<AdAssetsCoupons> adAssetsCouponsList) {
        this.adAssetsCouponsMapperExt.insertBatch(adAssetsCouponsList);
    }

    @Override
    @Transactional
    public void addNew(AdAssetsCoupons adAssetsCoupons, Long ticketId) throws Exception {
        this.adAssetsCouponsMapperExt.insert(adAssetsCoupons);
        this.prodService.pushAdTicketToProdPre(ticketId);
    }

    @Override
    @Transactional
    public void addNew(List<AdAssetsCoupons> adAssetsCouponsList, Long ticketId) throws Exception {
        this.adAssetsCouponsMapperExt.insertBatch(adAssetsCouponsList);
        this.prodService.pushAdTicketToProdPre(ticketId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer update(AdAssetsCoupons adAssetsCoupons) throws Exception {
        AdAssetsCoupons ads = this.adAssetsCouponsMapperExt.selectByPrimaryKey(adAssetsCoupons.getId());
        if (ads.getStatus() == 1 && adAssetsCoupons.getStatus() == 2) {
            throw new ValidateException("\u542f\u7528\u7684\u5238\u4e0d\u80fd\u76f4\u63a5\u5220\u9664");
        }
        int result = this.adAssetsCouponsMapperExt.updateByPrimaryKeySelective(adAssetsCoupons);
        Long ticketId = ads.getTicketId();
        if (null != ticketId && ticketId > 0L) {
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateAndAudit(AdAssetsCoupons adAssetsCoupons, User user) throws Exception {
        Boolean checkFlag = this.checkAssetsUpdate(adAssetsCoupons);
        String log = "";
        Long ticketId = adAssetsCoupons.getTicketId();
        if (ticketId != null && ticketId != 0L) {
            AdTicket record = this.adTicketMapper.selectByPrimaryKey(ticketId);
            if (null != record) {
                Short ticketStatus = record.getStatus();
                if (checkFlag.booleanValue()) {
                    log = this.logAdd(adAssetsCoupons, user);
                    AdTicket adTicket = new AdTicket();
                    adTicket.setId(ticketId);
                    if (ticketStatus > 0 && record.getLastStatus() != 0) {
                        adTicket.setLastStatus(ticketStatus.shortValue());
                    }
                    adTicket.setStatus(Short.valueOf((short)-2));
                    int a = this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
                    if (null != ticketId) {
                        AdTicketUrlTest result = this.adTicketService.findTicketUrlTest(ticketId);
                        if (null == result) {
                            AdTicketUrlTest adTicketUrlTest = new AdTicketUrlTest();
                            adTicketUrlTest.setTicketId(ticketId);
                            adTicketUrlTest.setActionType(Short.valueOf((short)1));
                            adTicketUrlTest.setDealStatus(Short.valueOf((short)0));
                            adTicketUrlTest.setCreateTime(new Date());
                            adTicketUrlTest.setModifyTime(new Date());
                            this.adTicketService.addTicketUrlTest(adTicketUrlTest);
                        } else {
                            result.setModifyTime(new Date());
                            result.setActionType(Short.valueOf((short)1));
                            result.setDealStatus(Short.valueOf((short)0));
                            this.adTicketService.updateTicketUrlTest(result);
                        }
                    }
                }
            }
            this.adAssetsCouponsMapperExt.updateByPrimaryKeySelective(adAssetsCoupons);
            this.prodService.pushAdTicketToProdPre(ticketId);
        } else {
            this.adAssetsCouponsMapperExt.updateByPrimaryKeySelective(adAssetsCoupons);
        }
        return log;
    }

    public Boolean checkAssetsUpdate(AdAssetsCoupons assetsParam) {
        Boolean flag = false;
        AdAssetsCoupons adAssetsCoupons = this.adAssetsCouponsMapperExt.selectByPrimaryKey(assetsParam.getId());
        if (assetsParam != null && adAssetsCoupons != null) {
            if (!assetsParam.getPositionAssetSizeId().equals(adAssetsCoupons.getPositionAssetSizeId())) {
                flag = true;
                return flag;
            }
            if (!assetsParam.getType().equals(adAssetsCoupons.getType())) {
                flag = true;
                return flag;
            }
            if (!assetsParam.getStatus().equals(adAssetsCoupons.getStatus())) {
                flag = true;
                return flag;
            }
        }
        return flag;
    }

    public String logAdd(AdAssetsCoupons assetsParam, User user) {
        String log = "";
        AdAssetsCoupons adAssetsCoupons = this.adAssetsCouponsMapperExt.selectByPrimaryKey(assetsParam.getId());
        if (assetsParam != null && adAssetsCoupons != null) {
            if (!assetsParam.getPositionAssetSizeId().equals(adAssetsCoupons.getPositionAssetSizeId())) {
                log = log + "\u7d20\u6750\u5c3a\u5bf8ID\u4fee\u6539;";
            }
            if (!assetsParam.getType().equals(adAssetsCoupons.getType())) {
                log = log + "\u7d20\u6750\u7c7b\u578b\u4fee\u6539;";
            }
            if (!assetsParam.getStatus().equals(adAssetsCoupons.getStatus())) {
                log = log + "\u7d20\u6750\u72b6\u6001\u4fee\u6539;";
            }
            if ("".equals(log)) {
                log = "-";
            } else {
                log = "\u7d20\u6750ID:" + assetsParam.getId() + "\u53d8\u66f4;" + log;
                Long ticketId = assetsParam.getTicketId();
                TblAdTicketModify tblAdTicketModify = new TblAdTicketModify();
                tblAdTicketModify.setCreateTime(new Date());
                tblAdTicketModify.setTicketId(ticketId);
                tblAdTicketModify.setLog(log);
                tblAdTicketModify.setCreateUser("AE");
                if (null == user) {
                    tblAdTicketModify.setCreateUser("\u5e7f\u544a\u4e3b");
                }
                this.tblAdTicketModifyMapperExt.insert(tblAdTicketModify);
                Long id = tblAdTicketModify.getId();
                log = id + "-" + log;
            }
        }
        return log;
    }

    @Override
    public List<AdAssetsCoupons> findByIds(String ids) {
        if (StringUtil.isBlank((CharSequence)ids)) {
            return null;
        }
        String[] idsStr = ids.split(",");
        ArrayList<Long> assetsCouponsIds = new ArrayList<Long>(idsStr.length);
        for (String id : idsStr) {
            assetsCouponsIds.add(Long.valueOf(id));
        }
        return this.adAssetsCouponsMapperExt.findByIds(assetsCouponsIds);
    }

    private int getClickCount(Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchAssetAllClikePvCount(assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getViewCount(Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchAssetAllViewPvCount(assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getValidClickCount(Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchAssetValiedClikePvCount(assetsId.toString(), daily).intValue();
        }
        return count;
    }

    public static Set<String> getDailyBetweenDate(Date beginDate, Date endDate) {
        HashSet<String> lDate = new HashSet<String>();
        lDate.add(DateUtil.dateTo8String1((Date)beginDate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!endDate.after(cal.getTime())) break;
            lDate.add(DateUtil.dateTo8String1((Date)cal.getTime()));
        }
        lDate.add(DateUtil.dateTo8String1((Date)endDate));
        return lDate;
    }
}

