/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsInspireVideoMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkAssetsPullerIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsInspireVideo;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsInspireVideoExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dto.AdAssetsInspireVideoDto;
import com.bxm.adsmanager.model.dto.AdAssetsInspireVideoSearchDto;
import com.bxm.adsmanager.model.vo.AdAssetsInspireVideoVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsInspireVideoService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.DateUtils;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdTicketAssetsInspireVideoServiceImpl
implements AdTicketAssetsInspireVideoService {
    private static final Logger log = LoggerFactory.getLogger(AdTicketAssetsInspireVideoServiceImpl.class);
    @Autowired
    private AdAssetsInspireVideoMapperExt adAssetsInspireVideoMapperExt;
    @Autowired
    private ProdService prodService;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private DataparkAssetsPullerIntegration dataparkAssetsPullerIntegration;
    @Autowired
    private ProdPullerIntegration prodPullerIntegration;

    @Override
    public List<AdAssetsInspireVideo> findByTicketId(Long ticketId) {
        AdAssetsInspireVideoExample example = new AdAssetsInspireVideoExample();
        example.createCriteria().andTicketIdEqualTo(ticketId);
        List list = this.adAssetsInspireVideoMapperExt.selectByExample(example);
        return list;
    }

    @Override
    public List<AdAssetsInspireVideo> findByIds(String ids) {
        if (StringUtil.isBlank((CharSequence)ids)) {
            return null;
        }
        String[] idsStr = ids.split(",");
        ArrayList<Long> assetsInspireVideoIds = new ArrayList<Long>(idsStr.length);
        for (String id : idsStr) {
            assetsInspireVideoIds.add(Long.valueOf(id));
        }
        return this.adAssetsInspireVideoMapperExt.findByIds(assetsInspireVideoIds);
    }

    @Override
    public Pagination findAllAssetsListByParams(AdAssetsInspireVideoSearchDto adAssetsInspireVideoSearchDto) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("keywords", adAssetsInspireVideoSearchDto.getKeywords());
        map.put("status", adAssetsInspireVideoSearchDto.getStatus());
        map.put("ticketId", adAssetsInspireVideoSearchDto.getTicketId());
        map.put("pageStart", adAssetsInspireVideoSearchDto.getPageStart());
        map.put("pageSize", adAssetsInspireVideoSearchDto.getPageSize());
        Integer count = this.adAssetsInspireVideoMapperExt.getTotalCount(map);
        List list = this.adAssetsInspireVideoMapperExt.findAllAssetsListByParams(map);
        ArrayList<AdAssetsInspireVideoVo> listVo = new ArrayList<AdAssetsInspireVideoVo>();
        Integer allClick = 0;
        Integer allView = 0;
        Integer validClick = 0;
        Set<String> dailys = DateUtils.getDailyBetweenDate(DateUtil.convertStr2Date((String)adAssetsInspireVideoSearchDto.getPvStartTime()), DateUtil.convertStr2Date((String)adAssetsInspireVideoSearchDto.getPvEndTime()));
        DecimalFormat df = new DecimalFormat("######0");
        for (AdAssetsInspireVideo ad : list) {
            if (ad.getTicketId() == null) continue;
            allClick = this.getClickCount(ad.getTicketId().toString(), dailys, ad.getId());
            allView = this.getViewCount(ad.getTicketId().toString(), dailys, ad.getId());
            validClick = this.getValidClickCount(ad.getTicketId().toString(), dailys, ad.getId());
            AdAssetsInspireVideoVo aav = new AdAssetsInspireVideoVo();
            BeanUtils.copyProperties((Object)ad, (Object)aav);
            aav.setClickPv(allClick);
            if (allView == 0) {
                aav.setClickRate("0.00%");
            } else {
                BigDecimal clickRate = new BigDecimal(allClick * 100).divide(new BigDecimal(allView), 2, 4);
                aav.setClickRate(clickRate + "%");
            }
            aav.setValidClick(validClick);
            aav.setOpenPv(allView);
            listVo.add(aav);
        }
        Pagination pagination = new Pagination();
        pagination.setList(listVo);
        pagination.setPageSize(adAssetsInspireVideoSearchDto.getPageSize());
        pagination.setPageNo(adAssetsInspireVideoSearchDto.getPageNum());
        pagination.setTotalCount(count.intValue());
        return pagination;
    }

    @Override
    public void add(AdAssetsInspireVideoDto dto) {
        AdAssetsInspireVideo adAssetsInspireVideo = new AdAssetsInspireVideo();
        BeanUtils.copyProperties((Object)dto, (Object)adAssetsInspireVideo);
        adAssetsInspireVideo.setModifyTime(new Date());
        adAssetsInspireVideo.setAuditStatus(AdAssetsInspireVideo.AUDIT_STATUS_WAIT);
        this.adAssetsInspireVideoMapperExt.insertSelective(adAssetsInspireVideo);
        try {
            this.prodService.pushAdTicketToProdPre(dto.getTicketId());
        }
        catch (Exception e) {
            log.error("adsprod exception!", (Throwable)e);
        }
    }

    @Override
    public void update(AdAssetsInspireVideoDto dto) {
        AdAssetsInspireVideo adAssetsInspireVideo = new AdAssetsInspireVideo();
        BeanUtils.copyProperties((Object)dto, (Object)adAssetsInspireVideo);
        if (this.checkAssetsUpdate(dto).booleanValue()) {
            adAssetsInspireVideo.setAuditStatus(AdAssetsInspireVideo.AUDIT_STATUS_WAIT);
        }
        this.adAssetsInspireVideoMapperExt.updateByPrimaryKeySelective(adAssetsInspireVideo);
        try {
            this.prodService.pushAdTicketToProdPre(dto.getTicketId());
        }
        catch (Exception e) {
            log.error("adsprod exception!", (Throwable)e);
        }
    }

    @Override
    public void updateStatus(Long id, Integer status, String username) throws Exception {
        AdAssetsInspireVideo adAssets = this.adAssetsInspireVideoMapperExt.selectByPrimaryKey(id);
        if (adAssets.getAuditStatus() != 2) {
            throw new BusinessException("\u4ec5\u5ba1\u6838\u901a\u8fc7\u72b6\u6001\u4e0b\u7d20\u6750\u5141\u8bb8\u5f00\u542f");
        }
        AdAssetsInspireVideo adAssetsInspireVideo = this.adAssetsInspireVideoMapperExt.selectByPrimaryKey(adAssets.getId());
        Long ticketId = adAssetsInspireVideo.getTicketId();
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        if (3 != adTicket.getStatus() && adAssets.getStatus() == 1 && status != 1) {
            List adAssetsList = this.adAssetsInspireVideoMapperExt.findAllByTicketId(ticketId);
            Iterator iterator = adAssetsList.iterator();
            while (iterator.hasNext()) {
                AdAssetsInspireVideo adAssets1 = (AdAssetsInspireVideo)iterator.next();
                if (adAssets1.getStatus() != 0) continue;
                iterator.remove();
            }
            if (adAssetsList.size() <= 1) {
                throw new BusinessException("\u4ec5\u6709\u4e00\u4e2a\u7d20\u6750\u5f00\u542f\u7684\u65f6\u5019\uff0c\u8be5\u7d20\u6750\u4e0d\u5141\u8bb8\u5173\u95ed\u6216\u8005\u5220\u9664");
            }
        }
        AdAssetsInspireVideo adAssetsUpdate = new AdAssetsInspireVideo();
        adAssetsUpdate.setId(id);
        adAssetsUpdate.setStatus(Short.valueOf(status.shortValue()));
        this.adAssetsInspireVideoMapperExt.updateByPrimaryKeySelective(adAssetsUpdate);
        this.adTicketMapper.updateDateTimeById(ticketId);
        if (null != ticketId) {
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
    }

    @Override
    public void delete(Long id, String username) {
        AdAssetsInspireVideo adAssets = this.adAssetsInspireVideoMapperExt.selectByPrimaryKey(id);
        if (adAssets.getStatus() == 1) {
            throw new BusinessException("\u5f00\u542f\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        AdAssetsInspireVideo adAssetsInspireVideo = this.adAssetsInspireVideoMapperExt.selectByPrimaryKey(adAssets.getId());
        Long ticketId = adAssetsInspireVideo.getTicketId();
        AdAssetsInspireVideo adAssetsUpdate = new AdAssetsInspireVideo();
        adAssetsUpdate.setId(id);
        adAssetsUpdate.setStatus(Short.valueOf((short)2));
        this.adAssetsInspireVideoMapperExt.updateByPrimaryKeySelective(adAssetsUpdate);
        this.adTicketMapper.updateDateTimeById(ticketId);
        if (null != ticketId) {
            try {
                this.prodService.pushAdTicketToProdPre(ticketId);
            }
            catch (Exception e) {
                log.error("adsprod exception!", (Throwable)e);
            }
        }
    }

    public Boolean checkAssetsUpdate(AdAssetsInspireVideoDto dto) {
        AdAssetsInspireVideo adAssets = this.adAssetsInspireVideoMapperExt.selectByPrimaryKey(dto.getId());
        if (dto != null && adAssets != null) {
            if (StringUtils.isNotBlank((CharSequence)dto.getContent()) && !dto.getContent().equalsIgnoreCase(adAssets.getContent())) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getIconUrl()) && !dto.getIconUrl().equalsIgnoreCase(adAssets.getIconUrl())) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getTitle()) && !dto.getTitle().equalsIgnoreCase(adAssets.getTitle())) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getButtonContent()) && !dto.getButtonContent().equalsIgnoreCase(adAssets.getButtonContent())) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getVideoUrl()) && !dto.getVideoUrl().equalsIgnoreCase(adAssets.getVideoUrl())) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getCoverUrl()) && !dto.getCoverUrl().equalsIgnoreCase(adAssets.getCoverUrl())) {
                return true;
            }
        }
        return false;
    }

    private int getClickCount(String ticketId, Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchTicketDailyCreativeClick(ticketId, assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getViewCount(String ticketId, Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchTicketDailyCreativeView(ticketId, assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getValidClickCount(String ticketId, Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchTicketDailyCreativeValidClick(ticketId, assetsId.toString(), daily).intValue();
        }
        return count;
    }
}

