/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsStatisticsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketAssetsRefMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateAssetsMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.TblAdTicketModifyMapperExt;
import com.bxm.adsmanager.facade.model.base.Money;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkAssetsPullerIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketUrlTest;
import com.bxm.adsmanager.model.dao.adkeeper.TblAdTicketModify;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsDto;
import com.bxm.adsmanager.model.dto.AdAssetsStatisticsDto;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.vo.AdAssetsStatisticsVo;
import com.bxm.adsmanager.model.vo.AdAssetsVo;
import com.bxm.adsmanager.model.vo.AssetsPopupVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.TicketAssetsCopyListVo;
import com.bxm.adsmanager.redis.RedisNewClient;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsRefService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.adsmanager.utils.ListOrderUtils;
import com.bxm.adsmanager.utils.ListUtil;
import com.bxm.datapark.web.model.AssetsAnalysisData;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketAssetsServiceImpl
implements AdTicketAssetsService {
    @Autowired
    private AdAssetsMapper adAssetsMapper;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private ProdService prodService;
    @Autowired
    private ProdPullerIntegration prodPullerIntegration;
    @Autowired
    private DataparkAssetsPullerIntegration dataparkAssetsPullerIntegration;
    @Autowired
    private AdTicketAssetsRefMapper adTicketAssetsRefMapper;
    @Autowired
    private AdTicketAssetsRefService AdTicketAssetsRefServiceImpl;
    @Autowired
    private TblAdTicketModifyMapperExt tblAdTicketModifyMapperExt;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdAssetsStatisticsMapper adAssetsStatisticsMapper;
    @Autowired
    private RedisNewClient redisNewClient;
    @Autowired
    private AdAssetsTemplateAssetsMapperExt adAssetsTemplateAssetsMapperExt;

    @Override
    @Transactional
    public Long add(AdAssets adAssets) {
        adAssets.setAuditStatus(Integer.valueOf(1));
        adAssets.setFlowRate(Double.valueOf(0.0));
        int result = this.adAssetsMapper.insert(adAssets);
        if (result > 0) {
            return adAssets.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public void addNew(AdAssets adAssets, Long ticketId) throws Exception {
        adAssets.setAuditStatus(Integer.valueOf(1));
        adAssets.setFlowRate(Double.valueOf(adAssets.getFlowRate() == null ? 0.0 : adAssets.getFlowRate()));
        this.adAssetsMapper.insert(adAssets);
        this.AdTicketAssetsRefServiceImpl.addBatch(adAssets.getId() + "", ticketId);
        this.adTicketMapper.updateDateTimeById(ticketId);
        this.prodService.pushAdTicketToProdPre(ticketId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer update(AdAssets adAssets) throws Exception {
        AdAssets ads = this.adAssetsMapper.selectByPrimaryKey(adAssets.getId());
        if (ads.getStatus() == 1) {
            throw new ValidateException("\u7d20\u6750\u53ea\u6709\u5728\u5173\u95ed\u72b6\u6001\u4e0b\u624d\u80fd\u7f16\u8f91\u7d20\u6750");
        }
        if (this.checkNewAssetsUpdate(adAssets).booleanValue()) {
            adAssets.setAuditStatus(Integer.valueOf(1));
        }
        ads.setModifyTime(new Date());
        int result = this.adAssetsMapper.updateByPrimaryKeySelective(adAssets);
        Long ticketId = this.adAssetsMapper.findAdTicketById(adAssets.getId());
        this.adTicketMapper.updateDateTimeById(ticketId);
        if (null != ticketId) {
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
        return result;
    }

    @Override
    public void updateStatus(Long id, Integer status) throws Exception {
        AdAssets adAssets = this.adAssetsMapper.selectByPrimaryKey(id);
        if (adAssets.getAuditStatus() != 2) {
            throw new Exception("\u4ec5\u5ba1\u6838\u901a\u8fc7\u72b6\u6001\u4e0b\u7d20\u6750\u5141\u8bb8\u5f00\u542f");
        }
        Long ticketId = this.adAssetsMapper.findAdTicketById(adAssets.getId());
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        if (3 != adTicket.getStatus() && (-2 != adTicket.getStatus() || 3 != adTicket.getLastStatus() && 0 != adTicket.getLastStatus()) && adAssets.getStatus() == 1 && status != 1) {
            List adAssetsList = this.adAssetsMapper.findAllByTicketId(ticketId);
            Iterator iterator = adAssetsList.iterator();
            while (iterator.hasNext()) {
                AdAssets adAssets1 = (AdAssets)iterator.next();
                if (adAssets1.getStatus() != 0) continue;
                iterator.remove();
            }
            if (adAssetsList.size() <= 1) {
                throw new Exception("\u4ec5\u6709\u4e00\u4e2a\u7d20\u6750\u5f00\u542f\u7684\u65f6\u5019\uff0c\u8be5\u7d20\u6750\u4e0d\u5141\u8bb8\u5173\u95ed\u6216\u8005\u5220\u9664");
            }
        }
        adAssets.setStatus(Short.valueOf(status.shortValue()));
        adAssets.setModifyTime(new Date());
        this.adAssetsMapper.updateByPrimaryKeySelective(adAssets);
        this.adTicketMapper.updateDateTimeById(ticketId);
        if (null != ticketId) {
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateAndAudit(AdAssets adAssets, User user) throws Exception {
        Boolean checkFlag = this.checkAssetsUpdate(adAssets);
        String log = "";
        Long ticketId = this.adAssetsMapper.findAdTicketById(adAssets.getId());
        if (ticketId != null && ticketId != 0L) {
            AdTicket record = this.adTicketMapper.selectByPrimaryKey(ticketId);
            if (null != record) {
                Short ticketStatus = record.getStatus();
                if (checkFlag.booleanValue()) {
                    log = this.logAdd(adAssets, user);
                    AdTicket adTicket = new AdTicket();
                    adTicket.setId(ticketId);
                    if (ticketStatus > 0 && record.getLastStatus() != 0) {
                        adTicket.setLastStatus(ticketStatus.shortValue());
                    }
                    adTicket.setStatus(Short.valueOf((short)-2));
                    int a = this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
                    if (null != ticketId) {
                        AdTicketUrlTest result = this.adTicketService.findTicketUrlTest(ticketId);
                        if (null == result) {
                            AdTicketUrlTest adTicketUrlTest = new AdTicketUrlTest();
                            adTicketUrlTest.setTicketId(ticketId);
                            adTicketUrlTest.setActionType(Short.valueOf((short)1));
                            adTicketUrlTest.setDealStatus(Short.valueOf((short)0));
                            adTicketUrlTest.setCreateTime(new Date());
                            adTicketUrlTest.setModifyTime(new Date());
                            this.adTicketService.addTicketUrlTest(adTicketUrlTest);
                        } else {
                            result.setModifyTime(new Date());
                            result.setActionType(Short.valueOf((short)1));
                            result.setDealStatus(Short.valueOf((short)0));
                            this.adTicketService.updateTicketUrlTest(result);
                        }
                    }
                }
            }
            adAssets.setStatus(Short.valueOf((short)0));
            adAssets.setAuditStatus(Integer.valueOf(1));
            this.adAssetsMapper.updateByPrimaryKeySelective(adAssets);
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
        return log;
    }

    public Boolean checkNewAssetsUpdate(AdAssets assetsParam) {
        Boolean flag = false;
        AdAssets adAssets = this.adAssetsMapper.selectByPrimaryKey(assetsParam.getId());
        Long ticketId = this.adAssetsMapper.findAdTicketById(adAssets.getId());
        AdTicket ticket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        if (assetsParam != null && adAssets != null) {
            if (11 == ticket.getType()) {
                if (StringUtils.isNotBlank((CharSequence)assetsParam.getIcon()) && !assetsParam.getIcon().equalsIgnoreCase(adAssets.getIcon())) {
                    flag = true;
                    return flag;
                }
                if (StringUtils.isNotBlank((CharSequence)assetsParam.getTitle()) && !assetsParam.getTitle().equalsIgnoreCase(adAssets.getTitle())) {
                    flag = true;
                    return flag;
                }
                if (StringUtils.isNotBlank((CharSequence)assetsParam.getIntro()) && !assetsParam.getIntro().equalsIgnoreCase(adAssets.getIntro())) {
                    flag = true;
                    return flag;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getImage()) && !assetsParam.getImage().equalsIgnoreCase(adAssets.getImage())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getName()) && !assetsParam.getName().equalsIgnoreCase(adAssets.getName())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getButtonTxt()) && !assetsParam.getButtonTxt().equalsIgnoreCase(adAssets.getButtonTxt())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getIsPopup()) && !assetsParam.getIsPopup().equalsIgnoreCase(adAssets.getIsPopup())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getDynamicPopupParam()) && !assetsParam.getDynamicPopupParam().equalsIgnoreCase(adAssets.getDynamicPopupParam())) {
                flag = true;
                return flag;
            }
            if (null != assetsParam.getAssetPopupId() && !assetsParam.getAssetPopupId().equals(adAssets.getAssetPopupId())) {
                flag = true;
                return flag;
            }
        }
        return flag;
    }

    public Boolean checkAssetsUpdate(AdAssets assetsParam) {
        Boolean flag = false;
        AdAssets adAssets = this.adAssetsMapper.selectByPrimaryKey(assetsParam.getId());
        if (assetsParam != null && adAssets != null) {
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getName()) && !assetsParam.getName().equalsIgnoreCase(adAssets.getName())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getName()) && StringUtils.isBlank((CharSequence)adAssets.getName())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isBlank((CharSequence)assetsParam.getName()) && StringUtils.isNotBlank((CharSequence)adAssets.getName())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getContent()) && !assetsParam.getContent().equalsIgnoreCase(adAssets.getContent())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getContent()) && StringUtils.isBlank((CharSequence)adAssets.getContent())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isBlank((CharSequence)assetsParam.getContent()) && StringUtils.isNotBlank((CharSequence)adAssets.getContent())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getImage()) && !assetsParam.getImage().equalsIgnoreCase(adAssets.getImage())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getIntro()) && !assetsParam.getIntro().equalsIgnoreCase(adAssets.getIntro())) {
                flag = true;
                return flag;
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getButtonTxt()) && !assetsParam.getButtonTxt().equalsIgnoreCase(adAssets.getButtonTxt())) {
                flag = true;
                return flag;
            }
        }
        return flag;
    }

    public String logAdd(AdAssets assetsParam, User user) {
        String log = "";
        AdAssets adAssets = this.adAssetsMapper.selectByPrimaryKey(assetsParam.getId());
        if (assetsParam != null && adAssets != null) {
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getName()) && !assetsParam.getName().equalsIgnoreCase(adAssets.getName())) {
                log = log + "\u7d20\u6750\u540d\u79f0\u4fee\u6539;";
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getName()) && StringUtils.isBlank((CharSequence)adAssets.getName())) {
                log = log + "\u7d20\u6750\u540d\u79f0\u4fee\u6539;";
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getContent()) && !assetsParam.getContent().equalsIgnoreCase(adAssets.getContent())) {
                log = log + "\u7d20\u6750\u5185\u5bb9\u4fee\u6539;";
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getContent()) && StringUtils.isNotBlank((CharSequence)adAssets.getContent())) {
                log = log + "\u7d20\u6750\u5185\u5bb9\u4fee\u6539;";
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getImage()) && !assetsParam.getImage().equalsIgnoreCase(adAssets.getImage())) {
                log = log + "\u5e7f\u544a\u5238\u56fe\u7247\u5730\u5740\u4fee\u6539;";
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getIntro()) && !assetsParam.getIntro().equalsIgnoreCase(adAssets.getIntro())) {
                log = log + "\u5e7f\u544a\u5238\u4ecb\u7ecd\u4fee\u6539;";
            }
            if (StringUtils.isNotBlank((CharSequence)assetsParam.getButtonTxt()) && !assetsParam.getButtonTxt().equalsIgnoreCase(adAssets.getButtonTxt())) {
                log = log + "\u6309\u94ae\u6587\u6848\u4fee\u6539;";
            }
            if ("".equals(log)) {
                log = "-";
            } else {
                log = "\u7d20\u6750ID:" + assetsParam.getId() + "\u53d8\u66f4;" + log;
                Long ticketId = this.adAssetsMapper.findAdTicketById(Long.valueOf(assetsParam.getId()));
                TblAdTicketModify tblAdTicketModify = new TblAdTicketModify();
                tblAdTicketModify.setCreateTime(new Date());
                tblAdTicketModify.setTicketId(ticketId);
                tblAdTicketModify.setLog(log);
                tblAdTicketModify.setCreateUser("AE");
                if (null == user) {
                    tblAdTicketModify.setCreateUser("\u5e7f\u544a\u4e3b");
                }
                this.tblAdTicketModifyMapperExt.insert(tblAdTicketModify);
                Long id = tblAdTicketModify.getId();
                log = id + "-" + log;
            }
        }
        return log;
    }

    @Override
    @Transactional
    public Long queryAdvertiserByParam(Long adAssetId, Long ticketId) throws Exception {
        AdTicket record;
        AdTicket record2;
        Long adId;
        Long advertiserId = null;
        if (null != adAssetId && ticketId == null && null != (adId = this.adAssetsMapper.findAdTicketById(adAssetId)) && (record2 = this.adTicketMapper.selectByPrimaryKey(adId)) != null) {
            advertiserId = record2.getAdvertiser();
        }
        if (null == adAssetId && ticketId != null && (record = this.adTicketMapper.selectByPrimaryKey(ticketId)) != null) {
            advertiserId = record.getAdvertiser();
        }
        return advertiserId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer delete(String ids) throws Exception {
        if (ids == null) {
            throw new ValidateException("ids must be not null ");
        }
        String[] idsStr = ids.split(",");
        ArrayList<Long> longList = new ArrayList<Long>(idsStr.length);
        for (String id : idsStr) {
            longList.add(Long.valueOf(id));
        }
        int result = this.adAssetsMapper.deleteByIds(longList);
        this.adTicketAssetsRefMapper.deleteByAssetsIds(longList);
        Long ticketId = this.adAssetsMapper.findAdTicketById((Long)longList.get(0));
        if (null != ticketId) {
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer deleteBatchAndAudit(String ids) throws Exception {
        String[] idsStr = ids.split(",");
        ArrayList<Long> longList = new ArrayList<Long>(idsStr.length);
        for (String id : idsStr) {
            longList.add(Long.valueOf(id));
        }
        Long ticketId = this.adAssetsMapper.findAdTicketById((Long)longList.get(0));
        this.adAssetsMapper.deleteByIds(longList);
        int result = this.adTicketAssetsRefMapper.deleteByAssetsIds(longList);
        if (ticketId != null && ticketId != 0L) {
            AdTicket record = this.adTicketMapper.selectByPrimaryKey(ticketId);
            if (null != record) {
                Short ticketStatus = record.getStatus();
                AdTicket adTicket = new AdTicket();
                adTicket.setId(ticketId);
                if (ticketStatus > 0) {
                    adTicket.setLastStatus(ticketStatus.shortValue());
                }
                adTicket.setStatus(Short.valueOf((short)-2));
                this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
            }
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer deleteAndAudit(String id) throws Exception {
        Long ticketId = this.adAssetsMapper.findAdTicketById(Long.valueOf(id));
        ArrayList<Long> longList = new ArrayList<Long>();
        longList.add(Long.valueOf(id));
        this.adAssetsMapper.deleteByIds(longList);
        int result = this.adTicketAssetsRefMapper.deleteByAssetsIds(longList);
        if (ticketId != null && ticketId != 0L) {
            AdTicket record = this.adTicketMapper.selectByPrimaryKey(ticketId);
            if (null != record) {
                Short ticketStatus = record.getStatus();
                AdTicket adTicket = new AdTicket();
                adTicket.setId(ticketId);
                if (ticketStatus > 0) {
                    adTicket.setLastStatus(ticketStatus.shortValue());
                }
                adTicket.setStatus(Short.valueOf((short)-2));
                this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
            }
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
        return result;
    }

    @Override
    public List<AdAssets> findAll(String ids) {
        if (StringUtil.isBlank((CharSequence)ids)) {
            return null;
        }
        String[] idsStr = ids.split(",");
        ArrayList<Long> longList = new ArrayList<Long>(idsStr.length);
        for (String id : idsStr) {
            longList.add(Long.valueOf(id));
        }
        return this.adAssetsMapper.findAll(longList);
    }

    @Override
    public List<AdAssets> findAllAssetsById(Long ticketId) {
        return this.adAssetsMapper.findAllByTicketId(ticketId);
    }

    @Override
    public Pagination findAllAssetsListByParams(AdAssetsDto adAssetsDto) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("keywords", adAssetsDto.getKeywords());
        map.put("status", adAssetsDto.getTypeStatus());
        map.put("ticketId", adAssetsDto.getTicketId());
        map.put("pageStart", adAssetsDto.getPageStart());
        map.put("pageSize", adAssetsDto.getPageSize());
        Integer count = this.adAssetsMapper.getTotalCount(map);
        List list = this.adAssetsMapper.findAllAssetsListByParams(map);
        ArrayList<AdAssetsVo> listVo = new ArrayList<AdAssetsVo>();
        Integer allClick = 0;
        Integer allView = 0;
        Integer validClick = 0;
        Double consume = 0.0;
        DecimalFormat df = new DecimalFormat("######0");
        Set<String> dailys = AdTicketAssetsServiceImpl.getDailyBetweenDate(DateUtil.convertStr2Date((String)adAssetsDto.getPvStartTime()), DateUtil.convertStr2Date((String)adAssetsDto.getPvEndTime()));
        List<Long> assetsIds = list.stream().map(AdAssets::getId).collect(Collectors.toList());
        Map<Long, AssetsAnalysisData> dataMap = this.getAssetsAnalysis(adAssetsDto, assetsIds);
        String currentYmd = DateUtil.dateTo8String1((Date)new Date());
        List assetsPopupList = this.adAssetsMapper.getAssetsPopupList(null, null);
        Map<Long, AssetsPopupVo> assetsPopupVoMap = assetsPopupList.stream().collect(Collectors.toMap(a -> a.getId(), a -> a));
        for (AdAssets ad : list) {
            AssetsPopupVo assetsPopupVo;
            BigDecimal clickRate;
            allClick = this.getClickCount(adAssetsDto.getTicketId().toString(), dailys, ad.getId());
            allView = this.getViewCount(adAssetsDto.getTicketId().toString(), dailys, ad.getId());
            validClick = this.getValidClickCount(adAssetsDto.getTicketId().toString(), dailys, ad.getId());
            int consumeCountOfLi = this.getConsumeCount(adAssetsDto.getTicketId().toString(), dailys, ad.getId());
            consume = Money.ofLi((long)consumeCountOfLi).getYuan();
            AdAssetsVo aav = new AdAssetsVo();
            BeanUtils.copyProperties((Object)ad, (Object)aav);
            aav.setClickPv(allClick);
            if (allView == 0) {
                clickRate = BigDecimal.ZERO;
                aav.setClickRate("0.00%");
            } else {
                clickRate = new BigDecimal(allClick).divide(new BigDecimal(allView), 2, 4);
                aav.setClickRate(DoubleUtil.doubleToPercent(clickRate.doubleValue()));
            }
            if ("5".equals(ad.getIsPopup()) && null != (assetsPopupVo = assetsPopupVoMap.get(ad.getAssetPopupId()))) {
                aav.setAssetsPopupId(ad.getAssetPopupId());
                aav.setAssetsPopupStyleId(assetsPopupVo.getPopupStyleId());
            }
            Double cvr = allClick == 0 ? 0.0 : new BigDecimal(validClick).divide(new BigDecimal(allClick), 4, RoundingMode.HALF_UP).doubleValue();
            Double arpu = clickRate.multiply(new BigDecimal(cvr)).setScale(4, RoundingMode.HALF_UP).doubleValue();
            Double costEffect = validClick == 0 ? 0.0 : BigDecimal.valueOf(consume).divide(BigDecimal.valueOf(validClick.intValue()), 4, RoundingMode.HALF_UP).doubleValue();
            aav.setCvr(DoubleUtil.doubleToPercent(cvr));
            aav.setArpu(arpu);
            aav.setConsume(consume);
            aav.setCostEffect(costEffect);
            aav.setValidClick(validClick);
            aav.setOpenPv(allView);
            listVo.add(aav);
        }
        if (StringUtils.isNotBlank((CharSequence)adAssetsDto.getOrderParam())) {
            ListOrderUtils.sortList(listVo, adAssetsDto.getOrderParam(), adAssetsDto.getOrderType());
        }
        Pagination pagination = new Pagination();
        pagination.setList(listVo);
        pagination.setPageSize(adAssetsDto.getPageSize());
        pagination.setPageNo(adAssetsDto.getPageNum());
        pagination.setTotalCount(count.intValue());
        return pagination;
    }

    private Map<Long, AssetsAnalysisData> getAssetsAnalysis(AdAssetsDto adAssetsDto, List<Long> assetsIds) {
        HashMap<Long, AssetsAnalysisData> map = new HashMap<Long, AssetsAnalysisData>();
        List list = this.dataparkAssetsPullerIntegration.getAssetsAnalysis(adAssetsDto.getPvStartTime(), adAssetsDto.getPvEndTime(), assetsIds);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return map;
        }
        list.forEach(o -> map.put(o.getAssetId(), (AssetsAnalysisData)o));
        return map;
    }

    private int getClickCount(String ticketId, Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchTicketDailyCreativeClick(ticketId, assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getViewCount(String ticketId, Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchTicketDailyCreativeView(ticketId, assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getValidClickCount(String ticketId, Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchTicketDailyCreativeValidClick(ticketId, assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getConsumeCount(String ticketId, Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchAssetsBudgetOfDailyCount(assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getValidClickCount(Map<Long, AssetsAnalysisData> dataMap, String currentYmd, Set<String> dailys, Long assetsId) {
        AssetsAnalysisData data;
        int count = 0;
        if (dailys.size() == 0) {
            return count;
        }
        if (dailys.contains(currentYmd)) {
            count = this.prodPullerIntegration.fetchAssetValiedClikePvCount(assetsId.toString(), currentYmd);
        }
        if (null != (data = dataMap.get(assetsId)) && null != data.getValidClickPv()) {
            count += data.getValidClickPv().intValue();
        }
        return count;
    }

    public static Set<String> getDailyBetweenDate(Date beginDate, Date endDate) {
        HashSet<String> lDate = new HashSet<String>();
        lDate.add(DateUtil.dateTo8String1((Date)beginDate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!endDate.after(cal.getTime())) break;
            lDate.add(DateUtil.dateTo8String1((Date)cal.getTime()));
        }
        lDate.add(DateUtil.dateTo8String1((Date)endDate));
        return lDate;
    }

    @Override
    public PageInfo<AdAssetsStatisticsVo> findAdAssetsLowClickRateList(AdAssetsStatisticsDto param) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)param.getAssets()) && StringUtils.isNumeric((CharSequence)param.getAssets())) {
            param.setAssestsId(Long.valueOf(param.getAssets()));
            param.setAssets(null);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getAdticket()) && StringUtils.isNumeric((CharSequence)param.getAdticket())) {
            param.setTicketId(Long.valueOf(param.getAdticket()));
            param.setAdticket(null);
        }
        int pageSize = param.getPageSize();
        int pageNum = param.getPageNum();
        param.setPageNum(null);
        param.setPageSize(null);
        param.setPageStart(null);
        List<AdAssetsStatisticsVo> list = this.adAssetsStatisticsMapper.selectAdAssetslowClickRateList(param);
        int allTotal = list.size();
        Integer allClickPv = 0;
        Integer allOpenPv = 0;
        DecimalFormat df = new DecimalFormat("######0");
        Set<String> dailys = AdTicketAssetsServiceImpl.getDailyBetweenDate(DateUtil.convertStr2Date((String)param.getPvStartTime()), DateUtil.convertStr2Date((String)param.getPvEndTime()));
        if (null != list && !list.isEmpty()) {
            for (AdAssetsStatisticsVo assets : list) {
                allClickPv = this.getClickCount(assets.getTicketId().toString(), dailys, assets.getAssetsId());
                allOpenPv = this.getViewCount(assets.getTicketId().toString(), dailys, assets.getAssetsId());
                assets.setOpenPv(String.valueOf(allOpenPv));
                assets.setClickPv(String.valueOf(allClickPv));
                if (allOpenPv == 0) {
                    assets.setClickRate("0%");
                    continue;
                }
                assets.setClickRate(df.format(Math.round(Double.parseDouble(String.valueOf(allClickPv)) * 100.0 / Double.parseDouble(String.valueOf(allOpenPv)))) + "%");
            }
            if (StringUtil.isNotBlank((CharSequence)param.getOrderParam()) && StringUtil.isNotBlank((CharSequence)param.getOrderType())) {
                this.adAssetsSort(list, param);
                list = ListUtil.getTotalPage(list, list.size(), pageNum, pageSize);
            } else {
                list = ListUtil.getTotalPage(list, list.size(), pageNum, pageSize);
            }
        }
        PageInfo pageInfo = new PageInfo((List)list);
        pageInfo.setTotal((long)allTotal);
        pageInfo.setPageNum(pageNum);
        pageInfo.setPageSize(pageSize);
        return pageInfo;
    }

    @Override
    public List<AdAssetsStatisticsVo> exportAdAssetsLowClickRateList(AdAssetsStatisticsDto param) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)param.getAssets()) && StringUtils.isNumeric((CharSequence)param.getAssets())) {
            param.setAssestsId(Long.valueOf(param.getAssets()));
            param.setAssets(null);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getAdticket()) && StringUtils.isNumeric((CharSequence)param.getAdticket())) {
            param.setTicketId(Long.valueOf(param.getAdticket()));
            param.setAdticket(null);
        }
        param.setPageNum(null);
        param.setPageSize(null);
        param.setPageStart(null);
        List<Object> list = this.adAssetsStatisticsMapper.exportAdAssetslowClickRateList(param);
        Integer allClickPv = 0;
        Integer allOpenPv = 0;
        DecimalFormat df = new DecimalFormat("######0");
        Set<String> dailys = AdTicketAssetsServiceImpl.getDailyBetweenDate(DateUtil.convertStr2Date((String)param.getPvStartTime()), DateUtil.convertStr2Date((String)param.getPvEndTime()));
        if (null != list && !list.isEmpty()) {
            for (AdAssetsStatisticsVo assets : list) {
                allClickPv = this.getClickCount(assets.getTicketId().toString(), dailys, assets.getId());
                allOpenPv = this.getViewCount(assets.getTicketId().toString(), dailys, assets.getId());
                assets.setOpenPv(String.valueOf(allOpenPv));
                assets.setClickPv(String.valueOf(allClickPv));
                if (allOpenPv == 0) {
                    assets.setClickRate("0%");
                    continue;
                }
                assets.setClickRate(df.format(Math.round(Double.parseDouble(String.valueOf(allClickPv)) * 100.0 / Double.parseDouble(String.valueOf(allOpenPv)))) + "%");
            }
            if (list.size() > 1000) {
                list = list.subList(0, 1000);
            }
            if (StringUtil.isNotBlank((CharSequence)param.getOrderParam()) && StringUtil.isNotBlank((CharSequence)param.getOrderType())) {
                this.adAssetsSort(list, param);
            }
        } else {
            list = new ArrayList<AdAssetsStatisticsVo>();
        }
        return list;
    }

    @Override
    public List<AdAssets> findAllAssetsByIdAndStatus(Long ticketId, short status) {
        HashMap map = Maps.newHashMap();
        map.put("ticketId", ticketId);
        map.put("status", status);
        List list = this.adAssetsMapper.findAllAssetsByIdAndStatus((Map)map);
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList() : list;
    }

    private void adAssetsSort(List<AdAssetsStatisticsVo> list, AdAssetsStatisticsDto param) {
        String orderType;
        if ("clickPv".equals(param.getOrderParam())) {
            orderType = param.getOrderType();
            Collections.sort(list, new Comparator<AdAssetsStatisticsVo>(){

                @Override
                public int compare(AdAssetsStatisticsVo a1, AdAssetsStatisticsVo a2) {
                    if (Double.valueOf(a1.getClickPv()) > Double.valueOf(a2.getClickPv())) {
                        if ("asc".equals(orderType)) {
                            return 1;
                        }
                        return -1;
                    }
                    if (Double.valueOf(a1.getClickPv()).doubleValue() == Double.valueOf(a2.getClickPv()).doubleValue()) {
                        return 0;
                    }
                    if ("asc".equals(orderType)) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        if ("openPv".equals(param.getOrderParam())) {
            orderType = param.getOrderType();
            Collections.sort(list, new Comparator<AdAssetsStatisticsVo>(){

                @Override
                public int compare(AdAssetsStatisticsVo a1, AdAssetsStatisticsVo a2) {
                    if (Double.valueOf(a1.getOpenPv()) > Double.valueOf(a2.getOpenPv())) {
                        if ("asc".equals(orderType)) {
                            return 1;
                        }
                        return -1;
                    }
                    if (Double.valueOf(a1.getOpenPv()).doubleValue() == Double.valueOf(a2.getOpenPv()).doubleValue()) {
                        return 0;
                    }
                    if ("asc".equals(orderType)) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        if ("clickRate".equals(param.getOrderParam())) {
            orderType = param.getOrderType();
            Collections.sort(list, new Comparator<AdAssetsStatisticsVo>(){

                @Override
                public int compare(AdAssetsStatisticsVo a1, AdAssetsStatisticsVo a2) {
                    String vo1 = a1.getClickRate().replace("%", "");
                    String vo2 = a2.getClickRate().replace("%", "");
                    if (Double.valueOf(vo1) > Double.valueOf(vo2)) {
                        if ("asc".equals(orderType)) {
                            return 1;
                        }
                        return -1;
                    }
                    if (Double.valueOf(vo1).doubleValue() == Double.valueOf(vo2).doubleValue()) {
                        return 0;
                    }
                    if ("asc".equals(orderType)) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
    }

    @Override
    public Boolean findAssetsByTicket(Long ticketId, AdAssets adAssets) {
        List assetList = this.adAssetsMapper.findAllByTicketId(ticketId);
        AdTicket ticket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        if (ticket != null && ticket.getType() == 3) {
            return false;
        }
        Boolean b = true;
        if (assetList.size() > 0) {
            for (AdAssets assets : assetList) {
                if (adAssets.getId() != null && assets.getId().longValue() == adAssets.getId().longValue()) {
                    assets.setIsPopup(adAssets.getIsPopup());
                    assets.setStatus(adAssets.getStatus());
                }
                if (assets.getStatus() != 1 || StringUtils.equals((CharSequence)"1", (CharSequence)assets.getIsPopup())) continue;
                b = false;
            }
        } else if (adAssets.getStatus() == 1 && !StringUtils.equals((CharSequence)"1", (CharSequence)adAssets.getIsPopup())) {
            b = false;
        }
        return b;
    }

    @Override
    public Boolean findAssetsByAssetIds(String ids) {
        List<AdAssets> assetList = this.findAll(ids);
        Boolean b = true;
        for (AdAssets assets : assetList) {
            if (assets.getStatus() != 1 || StringUtils.equals((CharSequence)"1", (CharSequence)assets.getIsPopup())) continue;
            b = false;
        }
        return b;
    }

    @Override
    public Integer findTicketByAssetIds(String ids) {
        String[] idsStr = ids.split(",");
        ArrayList<Long> longList = new ArrayList<Long>(idsStr.length);
        for (String id : idsStr) {
            longList.add(Long.valueOf(id));
        }
        Long ticketId = this.adAssetsMapper.findAdTicketById((Long)longList.get(0));
        return ticketId.intValue();
    }

    @Override
    public List<AdAssetsVo> getAdAssetsVoByKeywords(String keywords, List<Long> ticketIds, String assetsStatus) {
        return this.adAssetsMapper.getAdAssetsVoByKeywords(keywords, ticketIds, assetsStatus);
    }

    @Override
    public List<AssetsPopupVo> getAssetsPopupList(String popupKeyWord) {
        return this.adAssetsMapper.getAssetsPopupList(popupKeyWord, Integer.valueOf(1));
    }

    @Override
    public void updateFlowRate(Long assetsId, Double rate) throws Exception {
        Long ticketId = this.adAssetsMapper.findAdTicketById(assetsId);
        if (ticketId == null) {
            throw new RuntimeException("\u7d20\u6750\u7684\u5238\u4e0d\u5b58\u5728");
        }
        AdAssets assets = new AdAssets();
        assets.setId(assetsId);
        assets.setFlowRate(rate);
        this.adAssetsMapper.updateByPrimaryKeySelective(assets);
        this.prodService.pushAdTicketToProdPre(ticketId);
    }

    @Override
    public void updateAssetsSelectType(Long ticketId, Short assetsSelectType) throws Exception {
        AdTicket adTicket = new AdTicket();
        adTicket.setId(ticketId);
        adTicket.setAssetsSelectType(assetsSelectType);
        this.adTicketMapper.updateByPrimaryKeySelective(adTicket);
        this.prodService.pushAdTicketToProdPre(ticketId);
    }

    @Override
    public Short getAssetsSelectType(Long ticketId) {
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        if (adTicket == null) {
            throw new RuntimeException("\u5238id\u4e0d\u5b58\u5728");
        }
        return adTicket.getAssetsSelectType();
    }

    @Override
    public List<TicketAssetsCopyListVo> getTicketAssetsCopyList(String ticketKeyword, Short ticketType, String userName) {
        AdTicketSearchDto condition = new AdTicketSearchDto();
        condition.setKeywords(ticketKeyword);
        condition.setAe(userName);
        condition.setType(ticketType);
        condition.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        List adTickets = this.adTicketMapper.findAll(condition);
        if (CollectionUtils.isEmpty((Collection)adTickets)) {
            return Collections.EMPTY_LIST;
        }
        List ticketIds = adTickets.stream().map(t -> t.getId()).collect(Collectors.toList());
        List adAssetsVoByKeywords = this.adAssetsMapper.getAdAssetsVoByKeywords(null, ticketIds, null);
        Map<Long, Long> ticketAssetsCountMap = adAssetsVoByKeywords.stream().collect(Collectors.groupingBy(AdAssetsVo::getTicketId, Collectors.counting()));
        ArrayList vos = Lists.newArrayList();
        adTickets.forEach(adTicket -> {
            TicketAssetsCopyListVo vo = new TicketAssetsCopyListVo();
            vo.setTicketId(adTicket.getId());
            vo.setTicketName(adTicket.getName());
            vo.setAssetsNum(Integer.valueOf(ticketAssetsCountMap.getOrDefault(adTicket.getId(), 0L).intValue()));
            if (vo.getAssetsNum() > 0) {
                vos.add(vo);
            }
        });
        return vos;
    }

    @Override
    public boolean checkTicketExistAssets(Long ticketId) {
        AdTicket ticket = this.adTicketMapper.selectByPrimaryKey(ticketId);
        if (ticket == null) {
            return false;
        }
        if (ticket.getType().shortValue() == AdTicket.AdTicketType.TYPE_NORMALS.getType()) {
            int count = this.adAssetsMapper.countAssetsByTicketId(ticketId);
            return count > 0;
        }
        if (ticket.getType().shortValue() == AdTicket.AdTicketType.TYPE_DIRECT.getType() || ticket.getType().shortValue() == AdTicket.AdTicketType.TYPE_ACTIVITY.getType()) {
            int count = this.adAssetsTemplateAssetsMapperExt.countEnableAssetsByTicketId(ticketId);
            return count > 0;
        }
        return false;
    }
}

