/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketAppExtendMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateAssetsMapperExt;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateMapperExt;
import com.bxm.adsmanager.ecxeption.AssetsDuplicateException;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkAssetsPullerIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssetsExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAppExtend;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAppExtendExample;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsDto;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsJsonConfig;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsSearchDTO;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsUpdateStatusDTO;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.enums.PanguAdxEnum;
import com.bxm.adsmanager.model.enums.RuleTargetEnum;
import com.bxm.adsmanager.model.enums.RuleTypeEnum;
import com.bxm.adsmanager.model.vo.AdAssetsTemplateAssetsVO;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.TicketAssetsCopyListVo;
import com.bxm.adsmanager.service.adkeeper.AdRulesService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsTemplateAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.adxadvertiserinfo.AdxAdvertiserInfoService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.service.review.QueryRequest;
import com.bxm.adsmanager.service.review.QueryResult;
import com.bxm.adsmanager.service.review.ReviewRequest;
import com.bxm.adsmanager.service.review.ReviewResult;
import com.bxm.adsmanager.service.review.meituan.MeiTuanCreative;
import com.bxm.adsmanager.service.review.oppo.OppoCreativeService;
import com.bxm.adsmanager.utils.DateUtils;
import com.bxm.adsmanager.utils.ListOrderUtils;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.MapHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketAssetsTemplateAssetsServiceImpl
implements AdTicketAssetsTemplateAssetsService {
    private static final Logger log = LoggerFactory.getLogger(AdTicketAssetsTemplateAssetsServiceImpl.class);
    @Autowired
    private AdAssetsTemplateAssetsMapperExt adAssetsTemplateAssetsMapperExt;
    @Autowired
    private AdAssetsTemplateMapperExt adAssetsTemplateMapperExt;
    @Autowired
    private AdTicketAppExtendMapper adTicketAppExtendMapper;
    @Autowired
    private ProdService prodService;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdRulesService adRulesService;
    @Autowired
    private AdxAdvertiserInfoService adxAdvertiserInfoService;
    @Autowired
    private OppoCreativeService oppoCreativeService;
    @Autowired
    private MeiTuanCreative meiTuanCreative;
    @Autowired
    private DataparkAssetsPullerIntegration dataparkAssetsPullerIntegration;
    @Autowired
    private ProdPullerIntegration prodPullerIntegration;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private Environment environment;

    @Override
    public AdAssetsTemplateAssets get(Long id) {
        return this.adAssetsTemplateAssetsMapperExt.selectByPrimaryKey(id);
    }

    @Override
    public List<AdAssetsTemplateAssets> findByTicketId(Long ticketId) {
        AdAssetsTemplateAssetsExample example = new AdAssetsTemplateAssetsExample();
        example.createCriteria().andTicketIdEqualTo(ticketId);
        List list = this.adAssetsTemplateAssetsMapperExt.selectByExample(example);
        return list;
    }

    @Override
    public List<AdAssetsTemplateAssets> findByIds(String ids) {
        if (StringUtil.isBlank((CharSequence)ids)) {
            return null;
        }
        String[] idsStr = ids.split(",");
        ArrayList<Long> assetsTemplateAssetsIds = new ArrayList<Long>(idsStr.length);
        for (String id : idsStr) {
            assetsTemplateAssetsIds.add(Long.valueOf(id));
        }
        return this.adAssetsTemplateAssetsMapperExt.findByIds(assetsTemplateAssetsIds);
    }

    @Override
    public List<AdAssetsTemplateAssets> findByIds(List<Long> ids) {
        return this.adAssetsTemplateAssetsMapperExt.findByIds(ids);
    }

    @Override
    public Pagination findAllAssetsListByParams(AdAssetsTemplateAssetsSearchDTO adAssetsTemplateAssetsSearchDto) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("keywords", adAssetsTemplateAssetsSearchDto.getKeywords());
        map.put("status", adAssetsTemplateAssetsSearchDto.getStatus());
        map.put("auditStatus", adAssetsTemplateAssetsSearchDto.getAuditStatus());
        map.put("ticketId", adAssetsTemplateAssetsSearchDto.getTicketId());
        map.put("pageStart", adAssetsTemplateAssetsSearchDto.getPageStart());
        map.put("pageSize", adAssetsTemplateAssetsSearchDto.getPageSize());
        map.put("panguCreativeId", adAssetsTemplateAssetsSearchDto.getPanguCreativeId());
        map.put("hasPanguCreativeId", adAssetsTemplateAssetsSearchDto.getHasPanguCreativeId());
        Integer count = this.adAssetsTemplateAssetsMapperExt.getTotalCount(map);
        List list = this.adAssetsTemplateAssetsMapperExt.findAllAssetsListByParams(map);
        ArrayList<AdAssetsTemplateAssetsVO> listVo = new ArrayList<AdAssetsTemplateAssetsVO>();
        Integer allClick = 0;
        Integer allView = 0;
        Integer validClick = 0;
        Set<String> dailys = DateUtils.getDailyBetweenDate(DateUtil.convertStr2Date((String)adAssetsTemplateAssetsSearchDto.getPvStartTime()), DateUtil.convertStr2Date((String)adAssetsTemplateAssetsSearchDto.getPvEndTime()));
        DecimalFormat df = new DecimalFormat("######0");
        for (AdAssetsTemplateAssets ad : list) {
            if (ad.getTicketId() == null) continue;
            allClick = this.getClickCount(ad.getTicketId().toString(), dailys, ad.getId());
            allView = this.getViewCount(ad.getTicketId().toString(), dailys, ad.getId());
            validClick = this.getValidClickCount(ad.getTicketId().toString(), dailys, ad.getId());
            AdAssetsTemplateAssetsVO aav = new AdAssetsTemplateAssetsVO();
            BeanUtils.copyProperties((Object)ad, (Object)aav);
            aav.setClickPv(allClick);
            aav.setValidClick(validClick);
            aav.setOpenPv(allView);
            if (allView == 0) {
                aav.setClickRate("0.00%");
            } else {
                BigDecimal clickRate = new BigDecimal(allClick * 100).divide(new BigDecimal(allView), 2, 4);
                aav.setClickRate(clickRate + "%");
            }
            if (allClick == 0) {
                aav.setClickConversionRate("0.00%");
            } else {
                BigDecimal clickConversionRate = new BigDecimal(validClick * 100).divide(new BigDecimal(allClick), 2, 4);
                aav.setClickConversionRate(clickConversionRate + "%");
            }
            if (allView == 0) {
                aav.setOpenConversionRate("0.00%");
            } else {
                BigDecimal openConversionRate = new BigDecimal(validClick * 100).divide(new BigDecimal(allView), 2, 4);
                aav.setOpenConversionRate(openConversionRate + "%");
            }
            listVo.add(aav);
        }
        if (StringUtils.isNotBlank((CharSequence)adAssetsTemplateAssetsSearchDto.getOrderParam())) {
            ListOrderUtils.sortList(listVo, adAssetsTemplateAssetsSearchDto.getOrderParam(), adAssetsTemplateAssetsSearchDto.getOrderType());
        }
        Pagination pagination = new Pagination();
        pagination.setList(listVo);
        pagination.setPageSize(adAssetsTemplateAssetsSearchDto.getPageSize());
        pagination.setPageNo(adAssetsTemplateAssetsSearchDto.getPageNum());
        pagination.setTotalCount(count.intValue());
        return pagination;
    }

    @Override
    public Long add(AdAssetsTemplateAssetsDto dto) throws Exception {
        Long ticketId = dto.getTicketId();
        AdAssetsTemplateAssetsExample example = new AdAssetsTemplateAssetsExample();
        example.createCriteria().andTicketIdEqualTo(ticketId).andStatusNotEqualTo(Short.valueOf((short)2)).andConfigEqualTo(dto.getConfig());
        List existList = this.adAssetsTemplateAssetsMapperExt.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            Set ids = existList.stream().map(AdAssetsTemplateAssets::getId).collect(Collectors.toSet());
            throw new AssetsDuplicateException("\u4e0e\u521b\u610fID:" + ids + " \u91cd\u590d\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        AdAssetsTemplateAssets adAssetsTemplateAssets = new AdAssetsTemplateAssets();
        BeanUtils.copyProperties((Object)dto, (Object)adAssetsTemplateAssets);
        adAssetsTemplateAssets.setModifyTime(new Date());
        adAssetsTemplateAssets.setAuditStatus(Short.valueOf((short)1));
        adAssetsTemplateAssets.setCheckStatus(Short.valueOf((short)2));
        adAssetsTemplateAssets.setStatus(Short.valueOf((short)0));
        this.fillTemplateIdAndPanguCreativeIds(adAssetsTemplateAssets);
        this.adAssetsTemplateAssetsMapperExt.insertSelective(adAssetsTemplateAssets);
        return adAssetsTemplateAssets.getId();
    }

    @Override
    public Long update(AdAssetsTemplateAssetsDto dto) throws Exception {
        AdAssetsTemplateAssets adAssets = this.adAssetsTemplateAssetsMapperExt.selectByPrimaryKey(dto.getId());
        if (adAssets.getAdxAuditStatus() != null) {
            throw new BusinessException("ADX\u72b6\u6001\u6709\u503c\u7684\u60c5\u51b5\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u7d20\u6750\u5185\u5bb9\uff0c\u53ea\u80fd\u65b0\u5efa");
        }
        AdAssetsTemplateAssets adAssetsTemplateAssets = new AdAssetsTemplateAssets();
        BeanUtils.copyProperties((Object)dto, (Object)adAssetsTemplateAssets);
        if (this.checkAssetsUpdate(dto).booleanValue()) {
            adAssetsTemplateAssets.setAuditStatus(Short.valueOf((short)1));
            adAssetsTemplateAssets.setStatus(Short.valueOf((short)0));
        }
        adAssetsTemplateAssets.setCheckStatus(Short.valueOf((short)2));
        this.fillTemplateIdAndPanguCreativeIds(adAssetsTemplateAssets);
        this.adAssetsTemplateAssetsMapperExt.updateByPrimaryKeySelective(adAssetsTemplateAssets);
        return adAssetsTemplateAssets.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void updateStatus(AdAssetsTemplateAssetsUpdateStatusDTO dto) throws Exception {
        Integer status = dto.getStatus();
        for (Long id : dto.getIds()) {
            AdAssetsTemplateAssets adAssets = this.adAssetsTemplateAssetsMapperExt.selectByPrimaryKey(id);
            if (2 != adAssets.getAuditStatus()) {
                throw new BusinessException("\u4ec5\u5ba1\u6838\u901a\u8fc7\u72b6\u6001\u4e0b\u7d20\u6750\u5141\u8bb8\u5f00\u542f");
            }
            AdAssetsTemplateAssets adAssetsTemplateAssets = this.adAssetsTemplateAssetsMapperExt.selectByPrimaryKey(adAssets.getId());
            Long ticketId = adAssetsTemplateAssets.getTicketId();
            AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(ticketId);
            if (3 != adTicket.getStatus() && adAssets.getStatus() == 1 && status != 1) {
                List adAssetsList = this.adAssetsTemplateAssetsMapperExt.findAllByTicketId(ticketId);
                Iterator iterator = adAssetsList.iterator();
                while (iterator.hasNext()) {
                    AdAssetsTemplateAssets adAssets1 = (AdAssetsTemplateAssets)iterator.next();
                    if (adAssets1.getStatus() != 0) continue;
                    iterator.remove();
                }
                if (adAssetsList.size() <= 1) {
                    throw new BusinessException("\u4ec5\u6709\u4e00\u4e2a\u7d20\u6750\u5f00\u542f\u7684\u65f6\u5019\uff0c\u8be5\u7d20\u6750\u4e0d\u5141\u8bb8\u5173\u95ed\u6216\u8005\u5220\u9664");
                }
            }
            AdAssetsTemplateAssets adAssetsUpdate = new AdAssetsTemplateAssets();
            adAssetsUpdate.setId(id);
            adAssetsUpdate.setStatus(Short.valueOf(status.shortValue()));
            adAssetsUpdate.setModifyUser(dto.getModifyUser());
            this.adAssetsTemplateAssetsMapperExt.updateByPrimaryKeySelective(adAssetsUpdate);
            this.adTicketMapper.updateDateTimeById(ticketId);
        }
    }

    @Override
    public void delete(Long id, String username) {
        AdAssetsTemplateAssets adAssets = this.adAssetsTemplateAssetsMapperExt.selectByPrimaryKey(id);
        if (adAssets.getStatus() == 1) {
            throw new BusinessException("\u5f00\u542f\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        AdAssetsTemplateAssets adAssetsTemplateAssets = this.adAssetsTemplateAssetsMapperExt.selectByPrimaryKey(adAssets.getId());
        Long ticketId = adAssetsTemplateAssets.getTicketId();
        AdAssetsTemplateAssets adAssetsUpdate = new AdAssetsTemplateAssets();
        adAssetsUpdate.setId(id);
        adAssetsUpdate.setStatus(Short.valueOf((short)2));
        this.adAssetsTemplateAssetsMapperExt.updateByPrimaryKeySelective(adAssetsUpdate);
        this.adTicketMapper.updateDateTimeById(ticketId);
        if (null != ticketId) {
            try {
                this.prodService.pushAdTicketToProdPre(ticketId);
            }
            catch (Exception e) {
                log.error("adsprod exception!", (Throwable)e);
            }
        }
    }

    public Boolean checkAssetsUpdate(AdAssetsTemplateAssetsDto dto) {
        AdAssetsTemplateAssets adAssets = this.adAssetsTemplateAssetsMapperExt.selectByPrimaryKey(dto.getId());
        if (dto != null && adAssets != null && StringUtils.isNotBlank((CharSequence)dto.getConfig()) && !dto.getConfig().equalsIgnoreCase(adAssets.getConfig())) {
            return true;
        }
        return false;
    }

    private int getClickCount(String ticketId, Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchTicketDailyCreativeClick(ticketId, assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getViewCount(String ticketId, Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchTicketDailyCreativeView(ticketId, assetsId.toString(), daily).intValue();
        }
        return count;
    }

    private int getValidClickCount(String ticketId, Set<String> dailys, Long assetsId) {
        int count = 0;
        for (String daily : dailys) {
            count += this.prodPullerIntegration.fetchTicketActivityDailyCreativeValidClick(ticketId, assetsId.toString(), daily).intValue();
        }
        return count;
    }

    @Override
    public List<TicketAssetsCopyListVo> getTicketAssetsCopyList(String ticketKeyword) {
        AdTicketSearchDto condition = new AdTicketSearchDto();
        condition.setKeywords(ticketKeyword);
        condition.setTypeList(Arrays.asList(AdTicket.AdTicketType.TYPE_ACTIVITY.getType(), AdTicket.AdTicketType.TYPE_DIRECT.getType()));
        condition.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        List adTickets = this.adTicketMapper.findAll(condition);
        if (CollectionUtils.isEmpty((Collection)adTickets)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList vos = Lists.newArrayList();
        adTickets.forEach(adTicket -> {
            TicketAssetsCopyListVo vo = new TicketAssetsCopyListVo();
            vo.setTicketId(adTicket.getId());
            vo.setTicketName(adTicket.getName());
            int assetsCount = this.adAssetsTemplateAssetsMapperExt.countAssetsByTicketId(adTicket.getId());
            vo.setAssetsNum(Integer.valueOf(assetsCount));
            vos.add(vo);
        });
        return vos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public List<Long> copyTicketAssets(Long copyTicketId, Long targetTicketId, List<Long> ids, User user, List<String> tips, Map<String, HashSet<String>> existDuplicateTicketMap) throws Exception {
        AdTicket copyTicket = this.adTicketMapper.selectByPrimaryKey(copyTicketId);
        AdTicket targetTicket = this.adTicketMapper.selectByPrimaryKey(targetTicketId);
        if (copyTicket == null || targetTicket == null) {
            throw new BusinessException("\u590d\u5236\u7684\u5238\u4e0d\u5b58\u5728");
        }
        List<Short> ticketTypeList = Arrays.asList(AdTicket.AdTicketType.TYPE_ACTIVITY.getType(), AdTicket.AdTicketType.TYPE_DIRECT.getType());
        if (!ticketTypeList.contains(copyTicket.getType()) || !ticketTypeList.contains(targetTicket.getType())) {
            throw new BusinessException("\u53ea\u80fd\u590d\u5236\u76f4\u6295\u5238\u548c\u6d3b\u52a8\u5238\u7684\u7d20\u6750");
        }
        List allAssetsById = new ArrayList();
        allAssetsById = CollectionUtils.isNotEmpty(ids) ? this.adAssetsTemplateAssetsMapperExt.findByIds(ids) : this.adAssetsTemplateAssetsMapperExt.findAllByTicketId(copyTicketId);
        if (CollectionUtils.isEmpty(allAssetsById)) {
            throw new BusinessException("\u590d\u5236\u7684\u5238\u7d20\u6750\u6ca1\u6709\u627e\u5230");
        }
        ArrayList<Long> assetsIds = new ArrayList<Long>();
        for (AdAssetsTemplateAssets assets : allAssetsById) {
            AdAssetsTemplateAssetsDto adAssetsTemplateAssetsDto = new AdAssetsTemplateAssetsDto();
            BeanUtils.copyProperties((Object)assets, (Object)adAssetsTemplateAssetsDto);
            adAssetsTemplateAssetsDto.setId(null);
            adAssetsTemplateAssetsDto.setTicketId(targetTicketId);
            String assetsName = adAssetsTemplateAssetsDto.getAssetsName();
            int index = assetsName.lastIndexOf("-");
            if (index > -1) {
                String assetsNameSimple = assetsName.substring(0, index);
                String s = DateUtil.dateToFormat((Date)new Date(), (String)"-yyyyMMdd_HH:mm");
                assetsName = assetsNameSimple + s;
            }
            adAssetsTemplateAssetsDto.setAssetsName(assetsName);
            adAssetsTemplateAssetsDto.setCreateUser(user.getUsername());
            adAssetsTemplateAssetsDto.setModifyUser(user.getUsername());
            try {
                Long assetId = this.add(adAssetsTemplateAssetsDto);
                assetsIds.add(assetId);
            }
            catch (AssetsDuplicateException e) {
                String message = e.getMessage();
                tips.add("\u521b\u610fID\uff1a" + assets.getId() + message);
                if (null == existDuplicateTicketMap) continue;
                HashSet duplicateTicket = (HashSet)MapHelper.get(existDuplicateTicketMap, (Object)assets.getId().toString(), new HashSet(16));
                duplicateTicket.add(targetTicketId.toString());
            }
        }
        return assetsIds;
    }

    @Override
    public int batchUpdateStatus(Short status, String modifyUser, List<Long> ids) {
        return this.adAssetsTemplateAssetsMapperExt.batchUpdateStatus(status, modifyUser, ids);
    }

    @Override
    public String submitToAdxAudit(PanguAdxEnum panguAdxEnum, List<Long> ids, User user) throws Exception {
        String meiTuanAdxAdvertiserId;
        AdAssetsTemplateAssetsExample example = new AdAssetsTemplateAssetsExample();
        example.createCriteria().andIdEqualTo(ids.get(0));
        List list = this.adAssetsTemplateAssetsMapperExt.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u5238\u7d20\u6750\u6ca1\u6709\u627e\u5230");
        }
        Long ticketId = ((AdAssetsTemplateAssets)list.get(0)).getTicketId();
        AdTicketVo adTicketVo = this.adTicketService.findById(ticketId);
        PanguAdxEnum currentTicketPanguAdxEnum = PanguAdxEnum.getByAdxType((Short)adTicketVo.getTicketAppExtendVo().getAdxId());
        if (currentTicketPanguAdxEnum != currentTicketPanguAdxEnum) {
            throw new BusinessException("\u8be5\u7d20\u6750\u5bf9\u5e94\u7684\u5238\u7684ADX\u4e0e\u5f53\u524d\u8bf7\u6c42\u4e0d\u5339\u914d");
        }
        if (PanguAdxEnum.OPPO != currentTicketPanguAdxEnum && PanguAdxEnum.MEI_TUAN != currentTicketPanguAdxEnum) {
            throw new BusinessException("\u8be5\u7d20\u6750\u5bf9\u5e94\u7684\u5238\u5e76\u975eOPPO\u6216\u7f8e\u56e2ADX");
        }
        if (PanguAdxEnum.MEI_TUAN == currentTicketPanguAdxEnum && StringUtils.isBlank((CharSequence)(meiTuanAdxAdvertiserId = this.adxAdvertiserInfoService.getMeiTuanAdxAdvertiserId(adTicketVo.getAdvertiser().intValue())))) {
            throw new BusinessException("\u8be5\u5238\u6240\u5c5e\u7684\u5e7f\u544a\u4e3b\u6ca1\u6709\u901a\u8fc7\u7f8e\u56e2\u5e7f\u544a\u4e3b\u5ba1\u6838\uff0c\u8bf7\u5148\u63d0\u4ea4\u7f8e\u56e2\u5e7f\u544a\u4e3b\u5ba1\u6838\u3002");
        }
        String banners = adTicketVo.getControlVo().getBanners();
        if (StringUtils.isBlank((CharSequence)banners)) {
            throw new BusinessException("\u8be5\u5238\u6ca1\u6709\u5e7f\u544a\u4f4d\u5b9a\u5411");
        }
        if (!banners.contains(this.getAppKey(currentTicketPanguAdxEnum))) {
            throw new BusinessException("\u8be5\u5238\u7684\u5e7f\u544a\u4f4d\u5b9a\u5411\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        List adAssetsTemplateAssetsList = this.adAssetsTemplateAssetsMapperExt.findByIds(ids);
        ArrayList<Long> templateIds = new ArrayList<Long>();
        for (AdAssetsTemplateAssets adAssetsTemplateAssets : adAssetsTemplateAssetsList) {
            if (adAssetsTemplateAssets.getAdxAuditStatus() != null) {
                throw new BusinessException("ADX\u5ba1\u6838\u72b6\u6001\u6709\u503c\u7684\u60c5\u51b5\u4e0b\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u5ba1\u6838");
            }
            String config = adAssetsTemplateAssets.getConfig();
            HashMap configMap = (HashMap)JsonHelper.convert((String)config, HashMap.class);
            Object templateId = configMap.get("templateId");
            if (!Objects.nonNull(templateId)) continue;
            templateIds.add(Long.valueOf(templateId.toString()));
        }
        AdAssetsTemplateExample adAssetsTemplateExample = new AdAssetsTemplateExample();
        adAssetsTemplateExample.createCriteria().andIdIn(templateIds);
        List adAssetsTemplates = this.adAssetsTemplateMapperExt.selectByExample(adAssetsTemplateExample);
        ReviewRequest request = ReviewRequest.builder().adAssetsTemplates(adAssetsTemplates).adAssetsTemplateAssetsList(adAssetsTemplateAssetsList).adTicketVo(adTicketVo).build();
        ReviewResult reviewResult = null;
        if (PanguAdxEnum.OPPO == panguAdxEnum) {
            reviewResult = this.oppoCreativeService.submitCreative(request);
        } else if (PanguAdxEnum.MEI_TUAN == panguAdxEnum) {
            reviewResult = this.meiTuanCreative.submitCreative(request);
        }
        if (Objects.isNull(reviewResult)) {
            throw new BusinessException("ADX\u5ba1\u6838\u7ed3\u679c\u4e3a\u7a7a");
        }
        Map<String, Long> submitCreativeResultMap = reviewResult.getResult();
        for (AdAssetsTemplateAssets adAssetsTemplateAssets : adAssetsTemplateAssetsList) {
            Long adxCreativeId = submitCreativeResultMap.get(String.valueOf(adAssetsTemplateAssets.getId()));
            if (!Objects.nonNull(adxCreativeId)) continue;
            adAssetsTemplateAssets.setAdxCreativeId(String.valueOf(adxCreativeId));
            adAssetsTemplateAssets.setAdxAuditStatus(Short.valueOf((short)2));
            this.adAssetsTemplateAssetsMapperExt.updateByPrimaryKey(adAssetsTemplateAssets);
        }
        this.prodService.pushAdTicketToProdPre(ticketId);
        return reviewResult.getErrMsg();
    }

    @Override
    public void updateAdxAuditStatus(PanguAdxEnum panguAdxEnum) {
        AdTicketAppExtendExample adTicketAppExtendExample = new AdTicketAppExtendExample();
        adTicketAppExtendExample.createCriteria().andAdxIdEqualTo(Short.valueOf(panguAdxEnum.getAdxType()));
        List adTicketAppExtendList = this.adTicketAppExtendMapper.selectByExample(adTicketAppExtendExample);
        if (CollectionUtils.isEmpty((Collection)adTicketAppExtendList)) {
            return;
        }
        List ticketIds = adTicketAppExtendList.stream().map(AdTicketAppExtend::getTicketId).distinct().collect(Collectors.toList());
        AdAssetsTemplateAssetsExample example = new AdAssetsTemplateAssetsExample();
        example.createCriteria().andTicketIdIn(ticketIds).andStatusNotEqualTo(Short.valueOf((short)2)).andAdxCreativeIdIsNotNull().andAdxAuditStatusEqualTo(Short.valueOf((short)2));
        List adAssetsTemplateAssetsList = this.adAssetsTemplateAssetsMapperExt.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)adAssetsTemplateAssetsList)) {
            return;
        }
        Map adxCreativeIdMap = adAssetsTemplateAssetsList.stream().collect(HashMap::new, (k, v) -> k.put(v.getAdxCreativeId(), v.getId()), HashMap::putAll);
        ArrayList<AdAssetsTemplateAssets> updateAdAssetsTemplateAssetsList = new ArrayList<AdAssetsTemplateAssets>(adAssetsTemplateAssetsList.size());
        int size = adAssetsTemplateAssetsList.size();
        do {
            QueryRequest request = new QueryRequest();
            ArrayList<Long> list = new ArrayList<Long>();
            size = size >= 100 ? 100 : size;
            List adAssetsTemplateAssetsList1 = adAssetsTemplateAssetsList.subList(0, size);
            for (AdAssetsTemplateAssets adAssetsTemplateAssets : adAssetsTemplateAssetsList1) {
                String oppoCreativedIdtrim;
                String oppoCreativeId = adAssetsTemplateAssets.getAdxCreativeId();
                if (!StringUtils.isNotBlank((CharSequence)oppoCreativeId) || !StringUtils.isNotBlank((CharSequence)(oppoCreativedIdtrim = oppoCreativeId.trim()))) continue;
                try {
                    list.add(Long.valueOf(oppoCreativedIdtrim));
                }
                catch (Exception e) {
                    log.info("\u7d20\u6750ID:{} oppoCreativedId\u5f02\u5e38:{}", (Object)adAssetsTemplateAssets.getId(), (Object)oppoCreativedIdtrim);
                }
            }
            request.setList(list);
            QueryResult queryResult = null;
            if (PanguAdxEnum.OPPO == panguAdxEnum) {
                queryResult = this.oppoCreativeService.queryCreative(request);
            } else if (PanguAdxEnum.MEI_TUAN == panguAdxEnum) {
                queryResult = this.meiTuanCreative.queryCreative(request);
            }
            if (!Objects.nonNull(queryResult)) continue;
            Set<Long> success = queryResult.getSuccess();
            Map<Long, String> fail = queryResult.getFail();
            this.buildUpdateList(adxCreativeIdMap, updateAdAssetsTemplateAssetsList, success, null, (short)4);
            this.buildUpdateList(adxCreativeIdMap, updateAdAssetsTemplateAssetsList, fail.keySet(), fail, (short)3);
        } while ((size = adAssetsTemplateAssetsList.size()) >= 100);
        if (CollectionUtils.isNotEmpty(updateAdAssetsTemplateAssetsList)) {
            for (AdAssetsTemplateAssets adAssetsTemplateAssets : updateAdAssetsTemplateAssetsList) {
                this.adAssetsTemplateAssetsMapperExt.updateByPrimaryKeySelective(adAssetsTemplateAssets);
            }
            HashSet ticketIdSet = new HashSet(ticketIds);
            for (Long ticketId : ticketIdSet) {
                try {
                    this.prodService.pushAdTicketToProdPre(ticketId);
                }
                catch (Exception e) {
                    log.error("ADX\u7d20\u6750\u5ba1\u6838\u72b6\u6001\u53d8\u66f4\u540e\u7684\u7684\u5238\u63a8\u9001\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    private void buildUpdateList(Map<String, Long> adxCreativeIdMap, List<AdAssetsTemplateAssets> updateAdAssetsTemplateAssetsList, Set<Long> adxCreativeIdSet, Map<Long, String> messageMap, Short auditStatus) {
        if (Objects.isNull(adxCreativeIdSet)) {
            return;
        }
        for (Long adxCreativeId : adxCreativeIdSet) {
            AdAssetsTemplateAssets adAssetsTemplateAssets = new AdAssetsTemplateAssets();
            Long adAssetsTemplateAssetsId = adxCreativeIdMap.get(String.valueOf(adxCreativeId));
            if (Objects.isNull(adAssetsTemplateAssetsId)) continue;
            adAssetsTemplateAssets.setId(adAssetsTemplateAssetsId);
            adAssetsTemplateAssets.setAdxAuditStatus(auditStatus);
            if (Objects.nonNull(messageMap)) {
                adAssetsTemplateAssets.setAdxAuditMessage(messageMap.get(adxCreativeId));
            }
            updateAdAssetsTemplateAssetsList.add(adAssetsTemplateAssets);
        }
    }

    private String getAppKey(PanguAdxEnum currentTicketPanguAdxEnum) {
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        if (activeProfiles.contains("dev") || activeProfiles.contains("test")) {
            return "be232ad8e78b42829e26aefd0ec9b73f";
        }
        if (PanguAdxEnum.MEI_TUAN == currentTicketPanguAdxEnum) {
            return "f8bab6c9eaad45ba9d8e55ef9fa246fe";
        }
        if (PanguAdxEnum.OPPO == currentTicketPanguAdxEnum) {
            return "110134ffec8f4db4b23a865a238be083";
        }
        return "";
    }

    @Override
    public void updateOldData() {
        List adAssetsTemplateAssetsList = this.adAssetsTemplateAssetsMapperExt.selectByExample(null);
        if (CollectionUtils.isEmpty((Collection)adAssetsTemplateAssetsList)) {
            return;
        }
        if (((AdAssetsTemplateAssets)adAssetsTemplateAssetsList.get(0)).getTemplateId() != null) {
            return;
        }
        for (AdAssetsTemplateAssets adAssetsTemplateAssets : adAssetsTemplateAssetsList) {
            this.fillTemplateIdAndPanguCreativeIds(adAssetsTemplateAssets);
            this.adAssetsTemplateAssetsMapperExt.updateByPrimaryKey(adAssetsTemplateAssets);
        }
    }

    private void fillTemplateIdAndPanguCreativeIds(AdAssetsTemplateAssets adAssetsTemplateAssets) {
        String config = adAssetsTemplateAssets.getConfig();
        AdAssetsTemplateAssetsJsonConfig adAssetsTemplateAssetsJsonConfig = (AdAssetsTemplateAssetsJsonConfig)JsonHelper.convert((String)config, AdAssetsTemplateAssetsJsonConfig.class);
        String templateId = adAssetsTemplateAssetsJsonConfig.getTemplateId();
        if (StringUtils.isBlank((CharSequence)templateId)) {
            log.info("\u7d20\u6750ID:{} \u6ca1\u6709\u6a21\u677fID", (Object)adAssetsTemplateAssets.getId());
        } else {
            try {
                adAssetsTemplateAssets.setTemplateId(Long.valueOf(templateId));
            }
            catch (Exception e) {
                log.info("\u7d20\u6750ID:{} \u6a21\u677fID\u5f02\u5e38:{}", (Object)adAssetsTemplateAssets.getId(), (Object)templateId);
            }
        }
        ArrayList<String> imgUrlList = new ArrayList<String>(4);
        imgUrlList.add(adAssetsTemplateAssetsJsonConfig.getImage());
        imgUrlList.add(adAssetsTemplateAssetsJsonConfig.getIcon());
        imgUrlList.add(adAssetsTemplateAssetsJsonConfig.getCoverOrEndImage());
        imgUrlList.add(adAssetsTemplateAssetsJsonConfig.getBannerImage());
        ArrayList<String> nullList = new ArrayList<String>();
        nullList.add(null);
        nullList.add("");
        imgUrlList.removeAll(nullList);
        if (CollectionUtils.isNotEmpty(imgUrlList)) {
            String keyStr = "?id=";
            ArrayList<String> panguCreativeIdList = new ArrayList<String>(imgUrlList.size());
            for (String imgUrl : imgUrlList) {
                int lastIndexOf = imgUrl.lastIndexOf(keyStr);
                if (lastIndexOf <= 0) continue;
                String panguCreativeId = imgUrl.substring(lastIndexOf + keyStr.length());
                panguCreativeIdList.add(panguCreativeId);
            }
            String panguCreativeIds = Joiner.on((String)",").skipNulls().join(panguCreativeIdList);
            adAssetsTemplateAssets.setPanguCreativeIds(panguCreativeIds);
        }
    }

    @Override
    public Double findAssetsFillRate(Long ticketId) {
        Double defaultFillRate = 0.0;
        Double zeroFillRate = 0.0;
        String result = this.adRulesService.findByTicketId(RuleTargetEnum.GUANGGAO_QUAN.getValue(), RuleTypeEnum.GUANGGAOWEI.getValue(), ticketId);
        if (StringUtils.isBlank((CharSequence)result) || !result.startsWith("1")) {
            return defaultFillRate;
        }
        String positionIdsStr = result.substring(2);
        ArrayList positionIdList = Lists.newArrayList((Iterable)Splitter.on((String)",").splitToList((CharSequence)positionIdsStr));
        QueryAppEntranceParamDTO queryAppEntranceParamDTO = new QueryAppEntranceParamDTO();
        queryAppEntranceParamDTO.setPositionIds((List)positionIdList);
        List appEntranceAdROList = this.newAppEntranceFacadeIntegration.getAllList(queryAppEntranceParamDTO);
        if (CollectionUtils.isEmpty((Collection)appEntranceAdROList)) {
            return defaultFillRate;
        }
        String assetsTemplateIds = appEntranceAdROList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getAssetsTemplateId())).map(AppEntranceAdRO::getAssetsTemplateId).collect(Collectors.joining(","));
        if (StringUtils.isBlank((CharSequence)assetsTemplateIds)) {
            return defaultFillRate;
        }
        ArrayList<String> assetsTemplateIdStringList = new ArrayList<String>(Arrays.asList(assetsTemplateIds.split(",")));
        ArrayList<Long> assetsTemplateIdLongList = new ArrayList<Long>(assetsTemplateIdStringList.size());
        for (String s : assetsTemplateIdStringList) {
            try {
                assetsTemplateIdLongList.add(Long.valueOf(s));
            }
            catch (Exception e) {
                log.error("\u5e7f\u544a\u4f4d\uff08{}\uff09\u5bf9\u5e94\u7684\u7d20\u6750\u6a21\u677f\u5f02\u5e38\uff1a{}", (Object)positionIdsStr, (Object)s);
            }
        }
        HashSet<String> assetsTemplateIdSet = new HashSet<String>(Arrays.asList(assetsTemplateIds.split(",")));
        if (CollectionUtils.isEmpty(assetsTemplateIdSet)) {
            return zeroFillRate;
        }
        AdAssetsTemplateAssetsExample example = new AdAssetsTemplateAssetsExample();
        example.createCriteria().andStatusNotEqualTo(Short.valueOf((short)2)).andTicketIdEqualTo(ticketId).andTemplateIdIn(assetsTemplateIdLongList);
        List adAssetsTemplateAssetsList = this.adAssetsTemplateAssetsMapperExt.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)adAssetsTemplateAssetsList)) {
            return zeroFillRate;
        }
        Set adAssetsTemplateIdSet = adAssetsTemplateAssetsList.stream().map(p -> p.getTemplateId()).collect(Collectors.toSet());
        BigDecimal fillRate = new BigDecimal(adAssetsTemplateIdSet.size() * 100).divide(new BigDecimal(assetsTemplateIdSet.size()), 2, 4);
        return fillRate.doubleValue();
    }
}

