/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketCouponsCodeMapperExt;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsCode;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsCodeExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsInfo;
import com.bxm.adsmanager.model.dto.AdTicketCouponsCodeStatusNumDto;
import com.bxm.adsmanager.service.adkeeper.AdTicketCouponsCodeService;
import com.bxm.adsmanager.service.adkeeper.AdTicketCouponsInfoService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketCouponsCodeServiceImpl
implements AdTicketCouponsCodeService {
    @Autowired
    private AdTicketCouponsCodeMapperExt adTicketCouponsCodeMapperExt;
    @Autowired
    private AdTicketCouponsInfoService adTicketCouponsInfoService;

    @Override
    public List<AdTicketCouponsCode> findByTicketId(Long ticketId) {
        AdTicketCouponsCodeExample example = new AdTicketCouponsCodeExample();
        example.createCriteria().andTicketIdEqualTo(ticketId);
        List list = this.adTicketCouponsCodeMapperExt.selectByExample(example);
        return list;
    }

    @Override
    public Integer addBatch(Set<String> codes, Long ticketId, Short status, Date createTime, String createUser) {
        return this.adTicketCouponsCodeMapperExt.addBatch(codes, ticketId, status, createTime, createUser);
    }

    @Override
    public List<AdTicketCouponsCodeStatusNumDto> findStatusNumByTicketId(Long ticketId) {
        return this.adTicketCouponsCodeMapperExt.findStatusNumByTicketId(ticketId);
    }

    @Override
    public Integer deleteByTicketId(Long ticketId) {
        AdTicketCouponsCodeExample example = new AdTicketCouponsCodeExample();
        example.createCriteria().andTicketIdEqualTo(ticketId);
        return this.adTicketCouponsCodeMapperExt.deleteByExample(example);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public int facadeUpdateTicketCouponsCode(AdTicketCouponsCode adTicketCouponsCode) {
        AdTicketCouponsCodeExample example;
        List list = null;
        AdTicketCouponsInfo adTicketCouponsInfo = this.adTicketCouponsInfoService.findByTicketId(adTicketCouponsCode.getTicketId());
        if (AdTicketCouponsInfo.AdCouponsUseType.USETYPE_SINGLE.getType() == adTicketCouponsInfo.getUseType().shortValue() || AdTicketCouponsInfo.AdCouponsUseType.USETYPE_MULTIPLE.getType() == adTicketCouponsInfo.getUseType().shortValue()) {
            example = new AdTicketCouponsCodeExample();
            example.createCriteria().andTicketIdEqualTo(adTicketCouponsCode.getTicketId()).andCouponsCodeEqualTo(adTicketCouponsCode.getCouponsCode());
            list = this.adTicketCouponsCodeMapperExt.selectByExample(example);
        } else {
            example = new AdTicketCouponsCodeExample();
            example.createCriteria().andTicketIdEqualTo(adTicketCouponsCode.getTicketId()).andCouponsCodeEqualTo(adTicketCouponsCode.getCouponsCode()).andBindDeviceNoEqualTo(adTicketCouponsCode.getBindDeviceNo()).andUsePositionIdEqualTo(adTicketCouponsCode.getUsePositionId());
            list = this.adTicketCouponsCodeMapperExt.selectByExample(example);
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            adTicketCouponsCode.setCreateTime(new Date());
            return this.adTicketCouponsCodeMapperExt.insert(adTicketCouponsCode);
        }
        AdTicketCouponsCode adTicketCouponsCodeDao = (AdTicketCouponsCode)list.get(0);
        adTicketCouponsCodeDao.setStatus(adTicketCouponsCode.getStatus());
        if (adTicketCouponsCode.getFirstShowTime() != null) {
            adTicketCouponsCodeDao.setFirstShowTime(adTicketCouponsCode.getFirstShowTime());
        }
        if (adTicketCouponsCode.getUseTime() != null) {
            adTicketCouponsCodeDao.setUseTime(adTicketCouponsCode.getUseTime());
        }
        adTicketCouponsCodeDao.setUsePositionId(adTicketCouponsCode.getUsePositionId());
        adTicketCouponsCodeDao.setBindDeviceNo(adTicketCouponsCode.getBindDeviceNo());
        adTicketCouponsCodeDao.setModifyUser(adTicketCouponsCode.getModifyUser());
        adTicketCouponsCodeDao.setModifyTime(new Date());
        return this.adTicketCouponsCodeMapperExt.updateByPrimaryKey(adTicketCouponsCodeDao);
    }
}

