/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketAppExtendMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAppExtend;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAppExtendExample;
import com.bxm.adsmanager.model.enums.AdxPriceTypeEnum;
import com.bxm.adsmanager.service.adkeeper.AdTicketNewService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.adsmanager.utils.TicketUtil;
import com.bxm.commons.currency.Money;
import com.bxm.util.dto.ValidateException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketNewServiceImpl
implements AdTicketNewService {
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdTicketAppExtendMapper adTicketAppExtendMapper;

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=60)
    public Boolean updateBudget(Long id, Double budgetDaily, Double price, Double adxBudgetDaily, Double adxPrice, String userName) throws ValidateException {
        AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(id);
        if (adTicket == null) {
            throw new ValidateException("\u6839\u636e\u5e7f\u544a\u5238Id\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5238\uff0c\u6216\u8005\u8be5\u5238\u5df2\u7ecf\u5220\u9664, id\uff1a" + id);
        }
        if (budgetDaily != null || price != null) {
            AdTicket updateTicket = new AdTicket();
            updateTicket.setId(id);
            Short settleType = adTicket.getSettleType();
            if (budgetDaily != null) {
                Long budgetDailyLi;
                TicketUtil.checkBudgetDaily(budgetDaily, settleType);
                if (1 == settleType || 4 == settleType || 5 == settleType) {
                    Money money = Money.ofYuan((double)budgetDaily);
                    budgetDailyLi = money.getLi();
                } else {
                    budgetDailyLi = budgetDaily.longValue();
                }
                updateTicket.setBudgetDaily(budgetDailyLi);
            } else if (price != null) {
                if (2 != settleType && 4 != settleType) {
                    if (99999.0 < price) {
                        throw new ValidateException("\u6700\u9ad8\u652f\u6301\u51fa\u4ef710.00\u5143");
                    }
                    if (0.001 > price) {
                        throw new ValidateException("\u51fa\u4ef7\u5fc5\u987b\u5927\u4e8e0.001\u5143");
                    }
                }
                Money money = Money.ofYuan((double)price);
                updateTicket.setPrice(Integer.valueOf(Long.valueOf(money.getLi()).intValue()));
            }
            updateTicket.setModifyUser(userName);
            int result = this.adTicketMapper.updateByPrimaryKeySelective(updateTicket);
            if (result == 0) {
                return false;
            }
        }
        if (adxBudgetDaily != null || adxPrice != null) {
            AdTicket.AdTicketType adTicketType = AdTicket.AdTicketType.getByType((Short)adTicket.getType());
            if (AdTicket.AdTicketType.TYPE_ACTIVITY != adTicketType && AdTicket.AdTicketType.TYPE_DIRECT != adTicketType) {
                throw new ValidateException("\u76f4\u6295\u5238/\u6d3b\u52a8\u5238\u624d\u5141\u8bb8\u4fee\u6539\u6b64\u6570\u636e");
            }
            AdTicketAppExtendExample example = new AdTicketAppExtendExample();
            example.createCriteria().andTicketIdEqualTo(id);
            List adTicketAppExtends = this.adTicketAppExtendMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)adTicketAppExtends)) {
                AdTicketAppExtend adTicketAppExtend = (AdTicketAppExtend)adTicketAppExtends.get(0);
                if (adxBudgetDaily != null) {
                    Money money = Money.ofYuan((double)adxBudgetDaily);
                    Integer adxBudgetDailyLi = Long.valueOf(money.getLi()).intValue();
                    adTicketAppExtend.setAdxBudgetDaily(adxBudgetDailyLi);
                } else if (adxPrice != null) {
                    if (AdxPriceTypeEnum.CPC.getType() == adTicketAppExtend.getAdxPriceType().shortValue() && (adxPrice > 2.0 || adxPrice < 0.0)) {
                        throw new ValidateException("\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e2\u7684\u6570\u5b57\uff0c\u6700\u591a\u652f\u6301\u4e24\u4f4d\u5c0f\u6570");
                    }
                    if (Objects.equals(AdxPriceTypeEnum.CPC.getType(), adTicketAppExtend.getAdxPriceType())) {
                        if (RequestUtils.isAdxPriceLimitUserName()) {
                            if (adxPrice <= 0.0 || adxPrice > 0.5) {
                                throw new ValidateException("adx\u51fa\u4ef7\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u4e0d\u5927\u4e8e0.5\u7684\u6570\u5b57\uff0c\u6700\u591a\u652f\u6301\u4e24\u4f4d\u5c0f\u6570");
                            }
                        } else if (adxPrice <= 0.0 || adxPrice > 0.3) {
                            throw new ValidateException("adx\u51fa\u4ef7\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u4e0d\u5927\u4e8e0.3\u7684\u6570\u5b57\uff0c\u6700\u591a\u652f\u6301\u4e24\u4f4d\u5c0f\u6570");
                        }
                    }
                    Integer oldAdxPrice = adTicketAppExtend.getAdxPrice();
                    Money money = Money.ofYuan((double)adxPrice);
                    Integer adxPriceLi = Long.valueOf(money.getLi()).intValue();
                    adTicketAppExtend.setAdxPrice(adxPriceLi);
                    BigDecimal data1 = new BigDecimal(adxPriceLi.toString());
                    BigDecimal data2 = new BigDecimal(oldAdxPrice.toString());
                    if (data1.compareTo(data2) != 0) {
                        AdxPriceTypeEnum adxPriceTypeEnum = AdxPriceTypeEnum.getByType((short)adTicketAppExtend.getAdxPriceType());
                        this.adTicketService.addLogs(userName, "ADX\u51fa\u4ef7\u4ece" + adxPriceTypeEnum.getDesc() + Money.ofLi((long)oldAdxPrice.intValue()).getYuan() + "\u5143\u4fee\u6539\u6210" + adxPriceTypeEnum.getDesc() + adxPrice + "\u5143", adTicket.getId().toString());
                    }
                }
                int result = this.adTicketAppExtendMapper.updateByPrimaryKeySelective(adTicketAppExtend);
                if (result == 0) {
                    return false;
                }
            }
        }
        return true;
    }
}

