/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketPositionTimesLimitMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketPositionTimesLimitConfigMapperExt;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPositionTimesLimit;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPositionTimesLimitConfig;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPositionTimesLimitConfigExample;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPositionTimesLimitExample;
import com.bxm.adsmanager.model.vo.AdTicketPositionTimesLimitConfigVo;
import com.bxm.adsmanager.model.vo.AdTicketPositionTimesLimitVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketPositionTimesLimitConfigService;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketPositionTimesLimit;
import com.bxm.adsprod.facade.ticket.TicketPositionTimesLimitConfig;
import com.bxm.commons.currency.Money;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketPositionTimesLimitConfigServiceImpl
implements AdTicketPositionTimesLimitConfigService {
    @Autowired
    private AdTicketPositionTimesLimitMapper adTicketPositionTimesLimitMapper;
    @Autowired
    private AdTicketPositionTimesLimitConfigMapperExt adTicketPositionTimesLimitConfigMapperExt;
    @Qualifier(value="jedisCounter")
    @Autowired
    private JedisCounter counter;

    @Override
    public List<AdTicketPositionTimesLimitConfigVo> findByTicketId(Long ticketId) {
        AdTicketPositionTimesLimitConfigExample adTicketPositionTimesLimitConfigExample = new AdTicketPositionTimesLimitConfigExample();
        adTicketPositionTimesLimitConfigExample.createCriteria().andTicketIdEqualTo(ticketId);
        List adTicketPositionTimesLimitConfigs = this.adTicketPositionTimesLimitConfigMapperExt.selectByExample(adTicketPositionTimesLimitConfigExample);
        if (CollectionUtils.isEmpty((Collection)adTicketPositionTimesLimitConfigs)) {
            return Collections.emptyList();
        }
        List adTicketPositionTimesLimitConfigIds = adTicketPositionTimesLimitConfigs.stream().map(AdTicketPositionTimesLimitConfig::getId).collect(Collectors.toList());
        AdTicketPositionTimesLimitExample example = new AdTicketPositionTimesLimitExample();
        example.createCriteria().andPositionTimesLimitConfigIdIn(adTicketPositionTimesLimitConfigIds);
        List adTicketPositionTimesLimits = this.adTicketPositionTimesLimitMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)adTicketPositionTimesLimits)) {
            return Collections.emptyList();
        }
        Map<Long, List<AdTicketPositionTimesLimit>> groupByConfigId = adTicketPositionTimesLimits.stream().collect(Collectors.groupingBy(AdTicketPositionTimesLimit::getPositionTimesLimitConfigId));
        ArrayList<AdTicketPositionTimesLimitConfigVo> adTicketPositionTimesLimitConfigVos = new ArrayList<AdTicketPositionTimesLimitConfigVo>(adTicketPositionTimesLimitConfigs.size());
        for (AdTicketPositionTimesLimitConfig adTicketPositionTimesLimitConfig : adTicketPositionTimesLimitConfigs) {
            AdTicketPositionTimesLimitConfigVo ticketPositionTimesLimitConfig = new AdTicketPositionTimesLimitConfigVo();
            BeanUtils.copyProperties((Object)adTicketPositionTimesLimitConfig, (Object)ticketPositionTimesLimitConfig);
            List ticketPositionTimesLimits = groupByConfigId.getOrDefault(adTicketPositionTimesLimitConfig.getId(), null);
            if (CollectionUtils.isNotEmpty((Collection)ticketPositionTimesLimits)) {
                ArrayList<AdTicketPositionTimesLimitVo> adTicketPositionTimesLimitVos = new ArrayList<AdTicketPositionTimesLimitVo>();
                for (AdTicketPositionTimesLimit ticketPositionTimesLimit : ticketPositionTimesLimits) {
                    AdTicketPositionTimesLimitVo adTicketPositionTimesLimitVo = new AdTicketPositionTimesLimitVo();
                    BeanUtils.copyProperties((Object)ticketPositionTimesLimit, (Object)adTicketPositionTimesLimitVo);
                    Long currentConsume = this.counter.get(TicketKeyGenerator.ticketPositionTimesLimitConfigCount((BigInteger)BigInteger.valueOf(ticketId), (String)String.valueOf(ticketPositionTimesLimit.getPositionTimesLimitConfigId()), (String)ticketPositionTimesLimit.getPosition()));
                    String currentConsumeShow = null;
                    currentConsumeShow = currentConsume == null ? "0" : String.valueOf(Money.ofLi((long)currentConsume).getYuan());
                    adTicketPositionTimesLimitVo.setConsume(currentConsumeShow);
                    adTicketPositionTimesLimitVos.add(adTicketPositionTimesLimitVo);
                }
                ticketPositionTimesLimitConfig.setTicketPositionTimesLimitList(adTicketPositionTimesLimitVos);
            }
            adTicketPositionTimesLimitConfigVos.add(ticketPositionTimesLimitConfig);
        }
        return adTicketPositionTimesLimitConfigVos;
    }

    @Override
    public List<TicketPositionTimesLimitConfig> findPushByTicketId(Long ticketId) {
        List<AdTicketPositionTimesLimitConfigVo> adTicketPositionTimesLimitConfigVos = this.findByTicketId(ticketId);
        ArrayList<TicketPositionTimesLimitConfig> ticketPositionTimesLimitConfigs = new ArrayList<TicketPositionTimesLimitConfig>(adTicketPositionTimesLimitConfigVos.size());
        for (AdTicketPositionTimesLimitConfigVo adTicketPositionTimesLimitConfigVo : adTicketPositionTimesLimitConfigVos) {
            TicketPositionTimesLimitConfig ticketPositionTimesLimitConfig = TicketPositionTimesLimitConfig.builder().build();
            BeanUtils.copyProperties((Object)adTicketPositionTimesLimitConfigVo, (Object)ticketPositionTimesLimitConfig);
            ticketPositionTimesLimitConfig.setStartHour(adTicketPositionTimesLimitConfigVo.getStartHour().intValue());
            ticketPositionTimesLimitConfig.setEndHour(adTicketPositionTimesLimitConfigVo.getEndHour().intValue());
            List ticketPositionTimesLimitList = adTicketPositionTimesLimitConfigVo.getTicketPositionTimesLimitList();
            if (CollectionUtils.isNotEmpty((Collection)ticketPositionTimesLimitList)) {
                ArrayList<TicketPositionTimesLimit> ticketPositionTimesLimits = new ArrayList<TicketPositionTimesLimit>();
                for (AdTicketPositionTimesLimitVo ticketPositionTimesLimitVo : ticketPositionTimesLimitList) {
                    TicketPositionTimesLimit ticketPositionTimesLimit = TicketPositionTimesLimit.builder().build();
                    BeanUtils.copyProperties((Object)ticketPositionTimesLimitVo, (Object)ticketPositionTimesLimit);
                    ticketPositionTimesLimits.add(ticketPositionTimesLimit);
                }
                ticketPositionTimesLimitConfig.setTicketPositionTimesLimitList(ticketPositionTimesLimits);
            }
            ticketPositionTimesLimitConfigs.add(ticketPositionTimesLimitConfig);
        }
        return ticketPositionTimesLimitConfigs;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void save(CommonConstant.Opera.Platform platform, CommonConstant.Opera.Method method, List<AdTicketPositionTimesLimitConfigVo> confs, Long ticketId, String userName) {
        if (CommonConstant.Opera.Platform.ADVERTISER == platform) {
            if (CommonConstant.Opera.Method.EDIT == method) {
                // empty if block
            }
        } else if (CommonConstant.Opera.Platform.ADSMANAGER == platform) {
            this.edit(method, confs, ticketId, userName);
        }
    }

    private void edit(CommonConstant.Opera.Method method, List<AdTicketPositionTimesLimitConfigVo> confs, Long ticketId, String userName) {
        Date currentTime = new Date();
        if (CommonConstant.Opera.Method.ADD == method) {
            this.saveConfig(confs, ticketId, currentTime, userName);
            return;
        }
        if (CommonConstant.Opera.Method.EDIT == method) {
            if (CollectionUtils.isEmpty(confs)) {
                this.deleteByTicketId(ticketId);
                return;
            }
            List<AdTicketPositionTimesLimitConfig> oldList = this.findListByTicketId(ticketId);
            if (CollectionUtils.isEmpty(oldList)) {
                this.saveConfig(confs, ticketId, currentTime, userName);
                return;
            }
            ArrayList<AdTicketPositionTimesLimitConfigVo> addList = new ArrayList<AdTicketPositionTimesLimitConfigVo>();
            HashMap<AdTicketPositionTimesLimitConfig, List<AdTicketPositionTimesLimit>> editMap = new HashMap<AdTicketPositionTimesLimitConfig, List<AdTicketPositionTimesLimit>>(oldList.size());
            ArrayList<Long> delList = new ArrayList<Long>();
            Map oldMap = oldList.stream().collect(HashMap::new, (k, v) -> k.put(v.getId(), v), HashMap::putAll);
            for (AdTicketPositionTimesLimitConfigVo conf : confs) {
                AdTicketPositionTimesLimitConfig temp = (AdTicketPositionTimesLimitConfig)oldMap.get(conf.getId());
                if (temp != null) {
                    temp.setModifyTime(currentTime);
                    temp.setStartHour(conf.getStartHour());
                    temp.setEndHour(conf.getEndHour());
                    ArrayList<AdTicketPositionTimesLimit> adTicketPositionTimesLimits = new ArrayList<AdTicketPositionTimesLimit>();
                    List ticketPositionTimesLimitVoList = conf.getTicketPositionTimesLimitList();
                    for (AdTicketPositionTimesLimitVo adTicketPositionTimesLimitVo : ticketPositionTimesLimitVoList) {
                        AdTicketPositionTimesLimit adTicketPositionTimesLimit = new AdTicketPositionTimesLimit();
                        BeanUtils.copyProperties((Object)adTicketPositionTimesLimitVo, (Object)adTicketPositionTimesLimit);
                        adTicketPositionTimesLimit.setTicketId(ticketId);
                        adTicketPositionTimesLimit.setCpaPrice(Long.valueOf(Money.ofYuan((double)adTicketPositionTimesLimitVo.getCpaPriceYuan()).getLi()));
                        adTicketPositionTimesLimit.setCpcPrice(Long.valueOf(Money.ofYuan((double)adTicketPositionTimesLimitVo.getCpcPriceYuan()).getLi()));
                        adTicketPositionTimesLimit.setLimitPrice(Long.valueOf(Money.ofYuan((double)adTicketPositionTimesLimitVo.getLimitPriceYuan()).getLi()));
                        if (null != adTicketPositionTimesLimitVo.getDeepCpaPriceYuan()) {
                            adTicketPositionTimesLimit.setDeepCpaPrice(Long.valueOf(Money.ofYuan((double)adTicketPositionTimesLimitVo.getDeepCpaPriceYuan()).getLi()));
                        }
                        adTicketPositionTimesLimit.setPositionTimesLimitConfigId(temp.getId());
                        adTicketPositionTimesLimit.setCreateTime(currentTime);
                        adTicketPositionTimesLimit.setModifyTime(currentTime);
                        adTicketPositionTimesLimits.add(adTicketPositionTimesLimit);
                    }
                    editMap.put(temp, adTicketPositionTimesLimits);
                    oldMap.remove(conf.getId());
                    continue;
                }
                addList.add(conf);
            }
            oldMap.values().stream().forEach(old -> delList.add(old.getId()));
            if (CollectionUtils.isNotEmpty(addList)) {
                this.saveConfig(addList, ticketId, currentTime, userName);
            }
            if (!editMap.isEmpty()) {
                this.update(editMap);
            }
            if (CollectionUtils.isNotEmpty(delList)) {
                this.deleteByConfigId(delList);
            }
        }
    }

    private void saveConfig(List<AdTicketPositionTimesLimitConfigVo> positionTimesLimitConfig, Long ticketId, Date createTime, String createUser) {
        for (AdTicketPositionTimesLimitConfigVo adTicketPositionTimesLimitConfigVo : positionTimesLimitConfig) {
            AdTicketPositionTimesLimitConfig adTicketPositionTimesLimitConfig = new AdTicketPositionTimesLimitConfig();
            BeanUtils.copyProperties((Object)adTicketPositionTimesLimitConfigVo, (Object)adTicketPositionTimesLimitConfig);
            adTicketPositionTimesLimitConfig.setId(null);
            adTicketPositionTimesLimitConfig.setTicketId(ticketId);
            adTicketPositionTimesLimitConfig.setCreateTime(createTime);
            adTicketPositionTimesLimitConfig.setModifyTime(createTime);
            this.adTicketPositionTimesLimitConfigMapperExt.insert(adTicketPositionTimesLimitConfig);
            ArrayList adTicketPositionTimesLimits = new ArrayList();
            List ticketPositionTimesLimitVoList = adTicketPositionTimesLimitConfigVo.getTicketPositionTimesLimitList();
            for (AdTicketPositionTimesLimitVo adTicketPositionTimesLimitVo : ticketPositionTimesLimitVoList) {
                AdTicketPositionTimesLimit adTicketPositionTimesLimit = new AdTicketPositionTimesLimit();
                BeanUtils.copyProperties((Object)adTicketPositionTimesLimitVo, (Object)adTicketPositionTimesLimit);
                adTicketPositionTimesLimit.setId(null);
                adTicketPositionTimesLimit.setTicketId(ticketId);
                adTicketPositionTimesLimit.setCpaPrice(Long.valueOf(Money.ofYuan((double)adTicketPositionTimesLimitVo.getCpaPriceYuan()).getLi()));
                adTicketPositionTimesLimit.setCpcPrice(Long.valueOf(Money.ofYuan((double)adTicketPositionTimesLimitVo.getCpcPriceYuan()).getLi()));
                if (null != adTicketPositionTimesLimitVo.getDeepCpaPriceYuan()) {
                    adTicketPositionTimesLimit.setDeepCpaPrice(Long.valueOf(Money.ofYuan((double)adTicketPositionTimesLimitVo.getDeepCpaPriceYuan()).getLi()));
                }
                adTicketPositionTimesLimit.setLimitPrice(Long.valueOf(Money.ofYuan((double)adTicketPositionTimesLimitVo.getLimitPriceYuan()).getLi()));
                adTicketPositionTimesLimit.setPositionTimesLimitConfigId(adTicketPositionTimesLimitConfig.getId());
                adTicketPositionTimesLimit.setCreateTime(createTime);
                adTicketPositionTimesLimit.setModifyTime(createTime);
                this.adTicketPositionTimesLimitMapper.insert(adTicketPositionTimesLimit);
            }
        }
    }

    private List<AdTicketPositionTimesLimitConfig> findListByTicketId(Long ticketId) {
        AdTicketPositionTimesLimitConfigExample example = new AdTicketPositionTimesLimitConfigExample();
        example.createCriteria().andTicketIdEqualTo(ticketId);
        List list = this.adTicketPositionTimesLimitConfigMapperExt.selectByExample(example);
        return list;
    }

    private void update(Map<AdTicketPositionTimesLimitConfig, List<AdTicketPositionTimesLimit>> editMap) {
        Set<Map.Entry<AdTicketPositionTimesLimitConfig, List<AdTicketPositionTimesLimit>>> entries = editMap.entrySet();
        for (Map.Entry<AdTicketPositionTimesLimitConfig, List<AdTicketPositionTimesLimit>> entry : entries) {
            AdTicketPositionTimesLimitConfig adTicketPositionTimesLimitConfig = entry.getKey();
            List<AdTicketPositionTimesLimit> adTicketPositionTimesLimitList = entry.getValue();
            this.adTicketPositionTimesLimitConfigMapperExt.updateByPrimaryKeySelective(adTicketPositionTimesLimitConfig);
            AdTicketPositionTimesLimitExample adTicketPositionTimesLimitExample = new AdTicketPositionTimesLimitExample();
            adTicketPositionTimesLimitExample.createCriteria().andPositionTimesLimitConfigIdEqualTo(adTicketPositionTimesLimitConfig.getId());
            this.adTicketPositionTimesLimitMapper.deleteByExample(adTicketPositionTimesLimitExample);
            for (AdTicketPositionTimesLimit adTicketPositionTimesLimit : adTicketPositionTimesLimitList) {
                this.adTicketPositionTimesLimitMapper.insert(adTicketPositionTimesLimit);
            }
        }
    }

    private void deleteByTicketId(Long ticketId) {
        AdTicketPositionTimesLimitConfigExample adTicketPositionTimesLimitConfigExample = new AdTicketPositionTimesLimitConfigExample();
        adTicketPositionTimesLimitConfigExample.createCriteria().andTicketIdEqualTo(ticketId);
        this.adTicketPositionTimesLimitConfigMapperExt.deleteByExample(adTicketPositionTimesLimitConfigExample);
        AdTicketPositionTimesLimitExample adTicketPositionTimesLimitExample = new AdTicketPositionTimesLimitExample();
        adTicketPositionTimesLimitExample.createCriteria().andTicketIdEqualTo(ticketId);
        this.adTicketPositionTimesLimitMapper.deleteByExample(adTicketPositionTimesLimitExample);
    }

    private void deleteByConfigId(List<Long> configIdList) {
        for (Long configId : configIdList) {
            AdTicketPositionTimesLimitConfigExample adTicketPositionTimesLimitConfigExample = new AdTicketPositionTimesLimitConfigExample();
            adTicketPositionTimesLimitConfigExample.createCriteria().andIdEqualTo(configId);
            this.adTicketPositionTimesLimitConfigMapperExt.deleteByExample(adTicketPositionTimesLimitConfigExample);
            AdTicketPositionTimesLimitExample adTicketPositionTimesLimitExample = new AdTicketPositionTimesLimitExample();
            adTicketPositionTimesLimitExample.createCriteria().andPositionTimesLimitConfigIdEqualTo(configId);
            this.adTicketPositionTimesLimitMapper.deleteByExample(adTicketPositionTimesLimitExample);
        }
    }
}

