/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsStatisticsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsTmpStatisticsMapper;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTmpStatistics;
import com.bxm.adsmanager.model.dto.AdAssetsStatisticsDto;
import com.bxm.adsmanager.redis.RedisNewClient;
import com.bxm.adsmanager.service.adkeeper.AdTicketStatService;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdTicketStatServiceImpl
implements AdTicketStatService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketStatServiceImpl.class);
    private static final String AD_COUNTER_ASSETS_24H = "AD:COUNTER:ASSETS:24H";
    public static final int AD_COUNTER_ASSETS_DB = 0;
    @Autowired
    private AdAssetsStatisticsMapper adAssetsStatisticsMapper;
    @Autowired
    private AdAssetsTmpStatisticsMapper adAssetsTmpStatisticsMapper;
    @Autowired
    private RedisNewClient redisClient;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addAdTicketStatData() throws Exception {
        ArrayList<AdAssetsTmpStatistics> assetsTmpStatisticsList = new ArrayList<AdAssetsTmpStatistics>();
        Map<String, String> adAssets24HourData = this.redisClient.hGetAll(AD_COUNTER_ASSETS_24H, 0);
        DecimalFormat df = new DecimalFormat("######0");
        for (Map.Entry<String, String> entry : adAssets24HourData.entrySet()) {
            AdAssetsTmpStatistics tmpRecord = null;
            String allOpenPv = null;
            String allClickpv = null;
            String openAndClick = entry.getValue();
            if (!StringUtils.isNotBlank((String)openAndClick)) continue;
            String[] split = openAndClick.split("-");
            allOpenPv = split[0];
            allClickpv = split[1];
            if (StringUtils.isBlank((String)allOpenPv)) {
                allOpenPv = "0";
            }
            if (StringUtils.isBlank((String)allClickpv)) {
                allClickpv = "0";
            }
            if (Integer.valueOf(allOpenPv) <= 1000) continue;
            tmpRecord = new AdAssetsTmpStatistics();
            tmpRecord.setAssetsId(Long.valueOf(entry.getKey()));
            tmpRecord.setActualClickRate(df.format(Math.round(Double.parseDouble(allClickpv) * 100.0 / Double.parseDouble(allOpenPv))) + "%");
            assetsTmpStatisticsList.add(tmpRecord);
        }
        LOGGER.info("\u5f00\u59cb\u5220\u9664\u65e7\u7684\u4e34\u65f6\u8868\u6570\u636e");
        this.adAssetsTmpStatisticsMapper.deleteAll();
        if (assetsTmpStatisticsList != null && !assetsTmpStatisticsList.isEmpty()) {
            LOGGER.info("\u5f00\u59cb\u6267\u884c\u7edf\u8ba1\u6570\u636e\u5165\u4e34\u65f6\u8868");
            this.adAssetsTmpStatisticsMapper.insertBatch(assetsTmpStatisticsList);
        }
        LOGGER.info("\u5f00\u59cb\u5220\u9664\u65e7\u7684\u6b63\u5f0f\u8868\u6570\u636e");
        this.adAssetsStatisticsMapper.deleteAll();
        List selectTmpAssetsData = this.adAssetsStatisticsMapper.selectTmpAssetsData();
        if (selectTmpAssetsData != null && !selectTmpAssetsData.isEmpty()) {
            LOGGER.info("\u5f00\u59cb\u6267\u884c\u67e5\u8be2\u6570\u636e\u5165\u6b63\u5f0f\u8868");
            this.adAssetsStatisticsMapper.insertBatch(selectTmpAssetsData);
        }
    }

    @Override
    public long queryAdAssetsLowClickRateCount(AdAssetsStatisticsDto record) throws Exception {
        return this.adAssetsStatisticsMapper.statAdAssetsLowClickRateCount(record);
    }

    @Override
    public List<Long> queryAssetsLowClickRate(AdAssetsStatisticsDto record) throws Exception {
        return this.adAssetsStatisticsMapper.selectAssetsLowClickRate(record);
    }

    @Override
    public List<Long> queryAdTicketLowClickRate(AdAssetsStatisticsDto record) throws Exception {
        return this.adAssetsStatisticsMapper.selectAdTicketLowClickRate(record);
    }
}

