/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.ext.GetuiTagDictMapperExt;
import com.bxm.adsmanager.model.dao.adkeeper.GetuiTagDict;
import com.bxm.adsmanager.model.dao.adkeeper.GetuiTagDictExample;
import com.bxm.adsmanager.model.vo.GetuiTagDictListVo;
import com.bxm.adsmanager.service.adkeeper.GetuiTagDictService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetuiTagDictServiceImpl
implements GetuiTagDictService {
    private static final Logger log = LoggerFactory.getLogger(GetuiTagDictServiceImpl.class);
    @Autowired
    private GetuiTagDictMapperExt getuiTagDictMapperExt;

    @Override
    public List<GetuiTagDictListVo> findAll() {
        ArrayList<GetuiTagDictListVo> getuiTagDictListVos = new ArrayList<GetuiTagDictListVo>();
        List getuiTagDicts = this.getuiTagDictMapperExt.selectByExample(null);
        if (CollectionUtils.isEmpty((Collection)getuiTagDicts)) {
            return Collections.emptyList();
        }
        List tagGroupDictList = getuiTagDicts.stream().filter(p -> GetuiTagDict.IS_DICT_GROUP_TRUE.equals(p.getIsDictGroup())).collect(Collectors.toList());
        Map<String, List<GetuiTagDict>> singleMap = getuiTagDicts.stream().filter(p -> GetuiTagDict.IS_DICT_GROUP_FALSE.equals(p.getIsDictGroup())).collect(Collectors.groupingBy(GetuiTagDict::getParentDictValue));
        for (GetuiTagDict getuiTagDict : tagGroupDictList) {
            GetuiTagDictListVo getuiTagDictListVo = new GetuiTagDictListVo();
            BeanUtils.copyProperties((Object)getuiTagDict, (Object)getuiTagDictListVo);
            List<GetuiTagDict> childGetuiTagDictList = singleMap.get(getuiTagDict.getDictValue());
            if (CollectionUtils.isNotEmpty(childGetuiTagDictList)) {
                ArrayList<GetuiTagDictListVo.GetuiTagDictChildVo> dictChildVoList = new ArrayList<GetuiTagDictListVo.GetuiTagDictChildVo>();
                for (GetuiTagDict tagDict : childGetuiTagDictList) {
                    GetuiTagDictListVo.GetuiTagDictChildVo getuiTagDictChildVo = new GetuiTagDictListVo.GetuiTagDictChildVo();
                    BeanUtils.copyProperties((Object)tagDict, (Object)getuiTagDictChildVo);
                    dictChildVoList.add(getuiTagDictChildVo);
                }
                getuiTagDictListVo.setValues(dictChildVoList);
            }
            getuiTagDictListVos.add(getuiTagDictListVo);
        }
        return getuiTagDictListVos;
    }

    @Override
    public List<String> buildRealTag(List<String> tagValues) {
        ArrayList<String> lastTagValues = new ArrayList<String>(tagValues.size());
        GetuiTagDictExample getuiTagDictExample = new GetuiTagDictExample();
        getuiTagDictExample.createCriteria().andIsDictGroupEqualTo(GetuiTagDict.IS_DICT_GROUP_FALSE);
        List allGetuiTagDicts = this.getuiTagDictMapperExt.selectByExample(getuiTagDictExample);
        Map<String, GetuiTagDict> tagDictMap = allGetuiTagDicts.stream().collect(Collectors.toMap(GetuiTagDict::getDictValue, p -> p));
        Map<String, List<GetuiTagDict>> childTagDictByParentDictValueMap = allGetuiTagDicts.stream().filter(p -> GetuiTagDict.IS_ALL_FALSE.equals(p.getIsAll())).collect(Collectors.groupingBy(GetuiTagDict::getParentDictValue));
        ArrayList lastGetuiTagDicts = new ArrayList(10);
        for (String tagValue : tagValues) {
            String[] split = tagValue.split(",");
            String allTag = null;
            for (String tag : split) {
                GetuiTagDict getuiTagDict = tagDictMap.get(tag);
                if (getuiTagDict == null || !GetuiTagDict.IS_ALL_TRUE.equals(getuiTagDict.getIsAll())) continue;
                allTag = getuiTagDict.getParentDictValue();
                break;
            }
            if (allTag != null) {
                List<GetuiTagDict> getuiTagDicts = childTagDictByParentDictValueMap.get(allTag);
                if (!CollectionUtils.isNotEmpty(getuiTagDicts)) continue;
                String allChildTagValue = getuiTagDicts.stream().map(p -> StringUtils.isNotBlank((CharSequence)p.getDictValueExt()) ? p.getDictValueExt() : p.getDictValue()).collect(Collectors.joining(","));
                lastTagValues.add(allChildTagValue);
                continue;
            }
            StringBuffer extDictTag = new StringBuffer();
            for (String tag : split) {
                GetuiTagDict getuiTagDict = tagDictMap.get(tag);
                if (getuiTagDict == null) continue;
                extDictTag.append(StringUtils.isNotBlank((CharSequence)getuiTagDict.getDictValueExt()) ? getuiTagDict.getDictValueExt() : getuiTagDict.getDictValue());
                extDictTag.append(",");
            }
            if (extDictTag.length() > 0) {
                extDictTag.deleteCharAt(extDictTag.length() - 1);
            }
            lastTagValues.add(extDictTag.toString());
        }
        log.info("\u4e2a\u63a8\u4eba\u7fa4\u6700\u7ec8\u6807\u7b7e\uff1a{}", (Object)StringUtils.join(lastTagValues, (String)","));
        return lastTagValues;
    }
}

