/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.adkeeper.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.ext.InfoActivityCertificateMapperExt;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.model.dao.adkeeper.InfoActivityCertificate;
import com.bxm.adsmanager.service.adkeeper.InfoActivityCertificateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InfoActivityCertificateServiceImpl
implements InfoActivityCertificateService {
    @Autowired
    private InfoActivityCertificateMapperExt infoActivityCertificateMapperExt;

    @Override
    public List<InfoActivityCertificate> findCertificateByKeyword(String keyword) {
        HashMap<String, String> maps = new HashMap<String, String>(16);
        maps.put("keyword", keyword);
        List certificateByKeyword = this.infoActivityCertificateMapperExt.findCertificateByKeywords(maps);
        if (CollectionUtils.isEmpty((Collection)certificateByKeyword)) {
            return new ArrayList<InfoActivityCertificate>();
        }
        return certificateByKeyword;
    }

    @Override
    public List<InfoActivityCertificate> findCertificateInfoByCertificates(StringBuffer ids) {
        ArrayList<Long> certificates = new ArrayList<Long>();
        HashMap<String, ArrayList<Long>> paramsMap = new HashMap<String, ArrayList<Long>>(16);
        if (ids != null && StringUtils.isNotEmpty((CharSequence)ids)) {
            for (String id : ids.toString().split(",")) {
                try {
                    certificates.add(Long.valueOf(id));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            paramsMap.put("certificates", certificates);
        }
        if (certificates.size() == 0) {
            return null;
        }
        List certificateInfos = this.infoActivityCertificateMapperExt.findCertificateInfoByCertificates(paramsMap);
        if (CollectionUtils.isEmpty((Collection)certificateInfos)) {
            return new ArrayList<InfoActivityCertificate>();
        }
        return certificateInfos;
    }

    @Override
    public List<InfoActivityCertificate> findCertificateByParams(String keyword, List<AdvertiserDto> advertiserList, Integer ticketType) {
        List certificateByKeyword;
        HashMap<String, Object> maps = new HashMap<String, Object>(16);
        maps.put("keyword", keyword);
        maps.put("ticketType", ticketType);
        if (CollectionUtils.isNotEmpty(advertiserList)) {
            maps.put("advertiserList", advertiserList);
        }
        if (CollectionUtils.isEmpty((Collection)(certificateByKeyword = this.infoActivityCertificateMapperExt.findCertificateByKeywords(maps)))) {
            return new ArrayList<InfoActivityCertificate>();
        }
        return certificateByKeyword;
    }
}

